/*	@(#)cg2var.h 1.2 86/10/08 SMI	*/

/*
 * Copyright (c) 1983 by Sun Microsystems, Inc.
 */

/*
 * Information pertaining to the Sun-2 color buffer but not to pixrects in
 * general is stored in the struct pointed to by the pr_data attribute of the
 * pixrect.
 * One property of the color buffer not shared with all pixrects is that
 * it has a color map.  The color map type and colormap contents are
 * specified by the putcolormap operation.
 */
struct	cg2pr {
	struct	cg2fb *cgpr_va;
	int	cgpr_fd;
	int	cgpr_planes;		/* color bit plane mask reg */
	struct	pr_pos cgpr_offset;
};

#define cg2_d(pr) ((struct cg2pr *)(pr)->pr_data)
#define cg2_fbfrompr(pr) (((struct cg2pr *)(pr)->pr_data)->cgpr_va)
#define cg2_ropword(cgd, plane, ax, ay)					\
		(cg2_ropwordaddr((cgd)->cgpr_va, (plane),		\
		 (cgd)->cgpr_offset.x+(ax),(cgd)->cgpr_offset.y+(ay)) )
#define cg2_pixel(cgd, ax, ay)						\
		(cg2_pixaddr((cgd)->cgpr_va,				\
		 (cgd)->cgpr_offset.x+(ax),(cgd)->cgpr_offset.y+(ay)) )
#define cg2_roppixel(cgd, ax, ay)					\
		(cg2_roppixaddr((cgd)->cgpr_va,				\
		 (cgd)->cgpr_offset.x+(ax),(cgd)->cgpr_offset.y+(ay)) )
#define cg2_prd_skew(cgd, ax)						\
		 (((cgd)->cgpr_offset.x+(ax)) & 15)


extern	struct pixrectops cg2_ops;

int	cg2_rop();
int	cg2_putcolormap();
int	cg2_putattributes();

#ifndef KERNEL
int	cg2_stencil();
int	cg2_batchrop();
struct	pixrect *cg2_make();
int	cg2_destroy();
int	cg2_get();
int	cg2_put();
int	cg2_vector();
struct	pixrect *cg2_region();
int	cg2_getcolormap();
int	cg2_getattributes();
#endif !KERNEL
