/*
**	Check that the password entry list pointed to by "*te" does NOT
**	contain the string pointed to by "pe->p_string[LNAME]".
**	On return "*te" contains the seek address for the last entry
**	in the list or "PWENTNULL" if the list is null.
**	Returns 1 if string is NOT in list,
**		0 if string IS in list and
**		PWERROR on error
*/ 

#include	<pwr.h>


chkentry(pe, te)
	register struct pwent *pe;
	register long *te;
{

	register struct pwent *rp;
	register loglen;

	struct pwent p;
	char buf[LOGLEN];


	for(rp = &p; *te != PWENTNULL; *te = rp->pw_next)
	{
		lseek(pwfd, *te, 0);
		if(read(pwfd, (char *)rp, PWENTLEN) != PWENTLEN)
			return(PWERROR);
		if((loglen = (int)rp->pw_strings[LNAME]) > LOGLEN)
			loglen = LOGLEN;
		if(read(pwfd, buf, loglen) != loglen)
			return(PWERROR);
		buf[LOGLEN-1] = '\0';
		if(!strcmp(pe->pw_strings[LNAME], buf))
			return(0);
		if(rp->pw_next == PWENTNULL)
			break;
	}

	/*	now "*TE" is seek address of last entry or null */ 

	return(1);
}
