#define	TLIMIT		600	/* the time that the program is allowed to run for */
#define TERMWIDTH	79	/* width of the screen */
#define STARTCHAR	'0'
#define	ENDCHAR	'}'
#define	GRON	'\021'
#define	GROFF	'\023'
#define	PLENGTH	24

#include	<signal.h>

char finish[]	= "\n\n\023Ta Ta\n";

quit()
{
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	write(1, finish, sizeof finish);
	sleep(4);
	exit();
}

main()
{
	register char ch;
	register short count, lcount;

	signal(SIGINT, quit);
	signal(SIGQUIT, quit);
	signal(SIGALRM, quit);
	alarm(TLIMIT);
	ch = STARTCHAR;
	lcount = 1;
	for(;;)
	{
		for(count = 0; count < TERMWIDTH; count++)
		{
			if(ch > ENDCHAR)
				ch = STARTCHAR;
			putchar(ch++);
		}
		putchar('\n');
		if(++lcount % PLENGTH == 0)
				putchar(lcount / PLENGTH & 01 ? GRON : GROFF);
	}
}
