h56893
s 00006/00006/01107
d D 1.3 81/05/12 20:45:40 root 3 2
c no sys subdirectory in includes anymore
e
s 00001/00001/01112
d D 1.2 81/01/31 14:52:20 root 2 1
c original from elecvax 20/1/81 no changes needed
e
s 01113/00000/00000
d D 1.1 81/01/23 13:09:49 root 1 0
e
u
U
t
T
I 1
/*
**	System initialisation and terminal start-up
**
**	Bugs and comments to:	Piers Lauder
**				Dept of Comp Sci
**				Sydney University
**	May '80.
*/

#include	<local-system>
D 3
#include	<sys/param.h>
#include	<sys/proc.h>
E 3
I 3
#include	<param.h>
#include	<proc.h>
E 3
#include	<passwd.h>
D 3
#include	<sys/retlim.h>
#include	<sys/stat.h>
#include	<sys/dir.h>
D 2
#include	<fcntl.h>
E 2
I 2
#include	<sys/fcntl.h>
E 3
I 3
#include	<retlim.h>
#include	<stat.h>
#include	<dir.h>
#include	<fcntl.h>
E 3
E 2
#include	<signal.h>
#include	<wtmp.h>
#include	<setjmp.h>


/* (not	DEBUG)
#define	DEBUG		1	/* for diagnostics on failed subprocesses */
/* (not	USRTMP)
#define	USRTMP		1	/* if /usr/tmp/ separate from /tmp */
#define	MAXUDIRS	10	/* Maximum user directories that will be removed from tmpdir at any one hit */
#define	NPROC		400	/* Max procs ? */

char	shell[]		= "/bin/sh";
char	shellarg0[]	= "-sh";
char	runc[]		= "/etc/rc";
char	runcarg0[]	= "-RC";
char	ifile[]		= "/etc/ttys";
char	getty[]		= "/etc/getty";
char	newinit[]	= "/etc/init";
char	utmpf[]		= UTMPF;
char	wtmpf[]		= WTMPF;
char	ctty[]		= "/dev/console";
char	dev[]		= "/dev/";
char	homedir[]	= "/";
char	tmpdir[]	= "/tmp";
#ifdef	USRTMP
char	usrtmp[]	= "/usr/tmp";
#endif	USRTMP
char	chkptf[]	= "/etc/lnodes.chkpt";
char	rmtree[]	= "/bin/rm";
#define	RMTREENAME	rmtree+5
#define	RMTREEFLAG	"-rf"
char *	initname;
#define	INITNAME	"INIT 1"
#define	INITSTATE	      5
char *	envinit[]	= { "HOME=/etc", "PATH=/etc/bin:/bin:/usr/bin:.", 0 };
extern
char **	environ;

/*
**	Corpse returned by limits call
*/

struct retlim		corpse;

/*
**	Tab structure to hold terminal configurations
*/

struct	tab
{
	char	line[LINESIZ+1];	/* +1 is room for null sentinel */
	char	comn;	/* non-zero means active line */
#	ifdef	TTY_GROUP
	char	tgroup;
#	endif	TTY_GROUP
	short	slot;
	union
	{
		short	t_pid;
		char	t_flag;
	}
		t_un;
}
	itab[NTTYS]
	,line;

/*
**	Miscellaneous data
*/

#define	NACP	(NPROC-2)	/* max number of async procs that could exit simultaneously */
short	plist[NACP];		/* list of active accounting processes */
short	fi;
char	tty[(sizeof dev)+LINESIZ+1];
short	count;			/* state count for runcom() */
short	newslot;		/* next available slot in utmp */

jmp_buf	onebuf[1];
jmp_buf	twobuf[1];
jmp_buf	threebuf[1];
jmp_buf	ninebuf[1];
jmp_buf	alrmbuf[1];
int	sigcatch();
#define	NULLBUF		(jmp_buf *)0

struct states
{
	int	st_signo;
	int	(*st_action)();
	jmp_buf	*st_jmpbuf;
}
	ST[]	=
{
	 {SIGALRM,	SIG_IGN,	alrmbuf}	/* 0 */
	,{SIGHUP,	sigcatch,	onebuf}		/* 1 - single user */
	,{SIGQUIT,	SIG_IGN,	twobuf}		/* 2 - multi-user */
	,{SIGTERM,	SIG_IGN,	threebuf}	/* 3 - close down */
	,{SIGTRAP,	SIG_IGN,	NULLBUF}
	,{SIGIOT,	SIG_IGN,	NULLBUF}
	,{SIGEMT,	SIG_IGN,	NULLBUF}
	,{SIGFPE,	SIG_IGN,	NULLBUF}
	,{SIGBUS,	SIG_IGN,	NULLBUF}
	,{SIGPIPE,	sigcatch,	ninebuf}	/* 9 - reboot "init" */
};
#define	NST	(sizeof ST/sizeof ST[0])

#define	RESTART		1
#define	RECONFIG	2
#define	CLOSE		3
#define	REBOOT		9

char	curstate[]	= "1";
char	prevstate[]	= "1";



/*
**	Init - loop to control all
*/

main(argc, argv)
	int		argc;
	char *		argv[];
{
	nice( -20 );

	/*
	**	If invoked with an argument in range '1'-'9'
	**	 and not process 1, signal the real init.
	*/

	if ( getpid() != 1 )
	{
		register char	c;

		if ( argc > 1 && ((c = *argv[1]) <= '9' && c >= '1') && kill(1, ST[c-'0'].st_signo) != SYSERROR )
			return 0;
		return 1;
	}

	/*
	**	Reboot init?
	*/

	if ( setjmp(ST[REBOOT].st_jmpbuf) )
		reboot();

	/*
	**	Set arg 0
	*/

	initname = argv[0];
	setname(INITNAME);

	/*
	**	If system had crashed, do checkpointing
	*/

	chkpt();

	/*
	**	The main loop, we get back here after an "init 1"
	*/

	setjmp(ST[RESTART].st_jmpbuf);
	setsigs();
	setstate('1');

	shutdown();
	single();

	setstate('2');

	runcom(curstate, count++, prevstate);

	/*
	**	Write system boot time to wtmp
	*/

	wrwtmp( S_TYPE, (struct tab *)0 );

	close( creat( utmpf, 0644 ) );

	/*
	**	Terminal configuration loop, reentered by "init 2".
	*/

	if ( setjmp(ST[RECONFIG].st_jmpbuf) )
		setstate('2');
	signal(ST[RECONFIG].st_signo, sigcatch);

	merge();

	/*
	**	Terminal start-up, terminated by "init 3"
	*/

	if ( setjmp(ST[CLOSE].st_jmpbuf) )
	{
		setstate('3');
		multiple(1);
	}
	else
	{
		signal(ST[CLOSE].st_signo, sigcatch);
		multiple(0);
	}

	/*
	**	Shutdown
	*/

	unlink(utmpf);
	wrwtmp(T_TYPE, (struct tab *)0);

	error("all shells dead - shutdown complete");
	sync();

	return 0;
}




/*
**	Reboot init
*/

reboot()
{
	ignsigs();
	shutdown();
	wrwtmp(T_TYPE, (struct tab *)0);
	sync();
	execl(newinit, (char *)0);
#	ifdef	DEBUG
	error(newinit);
#	endif	DEBUG
}



/*
**	If checkpoint file exists, update lnodes contained in it.
*/

chkpt()
{
	register	fd;
	struct pwent	pe;
	struct lnode	ln;

	if ( (fd = open( chkptf, 0 )) != SYSERROR )
	{
		while ( read( fd, (char *)&ln, sizeof ln ) == sizeof ln )
		{
			pe.pw_limits.l_uid = ln.l_uid;

			if ( getpwlog(&pe, (char *)0, 0) != PWERROR )
			{
				pe.pw_limits.l_usage = ln.l_usage;
				pe.pw_limits.l_flags = ln.l_flags & ~(LOGGEDIN|CURCLASS);
				pe.pw_limits.l_duse = ln.l_duse;
				updtpwent( &pe );
			}
		}

		pwclose();
		close( fd );
		unlink( chkptf );
	}
}




/*
**	Shutdown everything and clean up dead procs
*/

shutdown()
{
	register struct tab	*p;
	register		i;

	kill(-1, SIGTERM);
	sleep(2);

	for( p = &itab[0] ; p < &itab[NTTYS] ; p++ )
		term(p);

	for ( i=0 ; i<3 ; i++ )
	{
		if ( !setjmp(ST[0].st_jmpbuf) )
		{
			signal(ST[0].st_signo, sigcatch);
			alarm(30);
			multiple(1);	/* clean up dead procs */
			alarm(0);
			signal(ST[0].st_signo, SIG_IGN);
			break;
		}
		kill(-1, SIGKILL);
	}

#	ifdef	DEBUG
	{
		char		file[2];
		extern		errno;

		for ( i=0, file[0] = '0', file[1] = '\0' ; i < 10 ; i++, file[0]++ )
			if ( close(i) != SYSERROR )
			{
				errno = 0;
				error(file);
			}
	}
#	endif	DEBUG
}



/*
**	Run a shell on console
*/

single()
{
	register	pid;

	switch ( pid = fork() )
	{
	 case	SYSERROR:
		break;

	 case 0:
		resetsigs();
		signal(SIGALRM, SIG_IGN);	/* so shell won't timeout */
		setpgrp();
		open(ctty, 2);
		dup(0);
		dup(0);
		nice( 20 );
		environ = envinit;
		execl(shell, shellarg0, (char *)0);
#		ifdef	DEBUG
		error( shell );
#		endif	DEBUG
		sleep( 10 );
		exit(1);

	 default:
		while(wait((int *)0) != pid);
	}
}



/*
**	Run the start-up file
*/

runcom(cs, n, ps)
	char *		cs;
	int		n;
	char *		ps;
{
	register	pid;

	switch ( pid = fork() )
	{
	 case SYSERROR:
		break;

	 case 0:
		resetsigs();
		/* setpgrp(); */
		open(ctty, 2);
		dup(0);
		dup(0);
		nice( 20 );
		environ = envinit;
		execl(shell, runcarg0, runc, cs, itoa(n), ps, (char *)0);
#		ifdef	DEBUG
		error( shell );
#		endif	DEBUG
		exit(1);

	 default:
		while(wait((int *)0) != pid);
	}
}



/*
**	Loop for restarting dead shells and collecting their remains
*/

multiple(terminate)
{
	register struct tab	*p;
	register		pid;

	while ( (pid = limits( &corpse, L_DEADLIM )) != SYSERROR )
	{
		ignsigs();

		for( p = &itab[0] ; p < &itab[NTTYS] ; p++ )
			if ( p->t_un.t_pid == pid )
				if ( !terminate && p->comn != '\0' )
				{
					dfork( p );
					goto contin;
				}
				else
				{
					p->t_un.t_pid = 0;
					p->comn = '\0';
					break;
				}

		/*
		**	Async process or termination
		*/

		if ( !inlist( pid ) )
		{
			switch ( pid = fork() )
			{
			 case SYSERROR:
				admin( p, 0 );
				break;

			 case 0:
				setname("admin");
				admin( p, 1 );
				exit( 0 );

			 default:
				enter( pid );	/* enter a/c process in list */
			}
		}

	contin:;
		corpse.r_proc.p_pid = 0;	/* accounting done flag */

		/*
		**	Restart any failed forks
		*/

		for ( p = &itab[0] ; p < &itab[NTTYS] ; p++ )
			if ( p->t_un.t_pid == -1 )
				if ( terminate )
				{
					p->t_un.t_pid = 0;
					p->comn = '\0';
				}
				else
					dfork( p );

		setsigs();
	}
}



/*
**	Terminate known shell
*/

term(p)
	register struct tab *	p;
{
	if(p->t_un.t_pid > 0)
		kill(p->t_un.t_pid, SIGKILL);
	p->comn = '\0';
}



/*
**	Read a line from tty configuration file
**
**	lines have form:-
**		char 1			'0' or '1'
**		char 2			type
**		char 3			group
**		char 4..4+LINESIZ	name
**		[space or tab] ...	anything you like
*/

rline()
{
	register	c, i;

	if ( (c = get()) == -1 )
		return(0);
	if(c == 0)
		goto bad;
	line.t_un.t_flag = c;
	if ( (c = get()) <= 0 )
		goto bad;
	line.comn = c;
#	ifdef	TTY_GROUP
	if ( (c = get()) <= 0 )
		goto bad;
	line.tgroup = c;
#	endif	TTY_GROUP
	for(i=0; i<LINESIZ+1; i++)
		line.line[i] = 0;
	for(i=0; i<LINESIZ; i++)
	{
		if ( (c = get()) <= 0 || c == ' ' || c == '\t' )
			break;
		line.line[i] = c;
	}
	while(c > 0)
		c = get();
	maktty(line.line);
	if(access(tty, 06) != SYSERROR)
		return(1);

bad:
	line.t_un.t_flag = '0';
	return(1);
}



/*
**	Make up full path name for a tty in "tty"
*/

maktty(lin)
	register char *	lin;
{
	register	i, j;

	for(i=0; dev[i]; i++)
		tty[i] = dev[i];
	for(j=0 ; lin[j] && j < LINESIZ ;)
		tty[i++] = lin[j++];
	tty[i] = 0;
}



/*
**	Get one char from file
*/

get()
{
	char	b;

	if(read(fi, &b, 1) != 1)
		return(-1);
	if(b == '\n')
		return(0);
	return((unsigned)b);
}



/*
**	Read tty configuration file and merge new lines into table, dispatching any discontinued ttys.
*/

merge()
{
	register struct tab	*p, *q;
	register		i;

	if ( (fi = open(ifile, 0)) == SYSERROR )
		return;

	q = &itab[0];

	while(rline())
	{
		if(line.t_un.t_flag == '0')
			continue;

		for( p = &itab[0] ; p < &itab[NTTYS] ; p++ )
		{
			if(p->comn != '\0')
				for(i=0; i<LINESIZ; i++)
					if(p->line[i] != line.line[i])
						goto contin;

			if(p >= q)
			{
				for(i=0; i<LINESIZ; i++)
				{
					p->line[i] = q->line[i];
					q->line[i] = line.line[i];
				}
				p->comn = q->comn;
				q->comn = line.comn;
#				ifdef	TTY_GROUP
				p->tgroup = q->tgroup;
				q->tgroup = line.tgroup;
#				endif	TTY_GROUP
				i = p->slot;
				p->slot = q->slot;
				if ( (q->slot = i) == 0 )
					q->slot = ++newslot;
				i = p->t_un.t_pid;
				p->t_un.t_pid = q->t_un.t_pid;
				q->t_un.t_pid = i;
				q++;
			}
			break;
		contin:
			;
		}
	}

	close(fi);

	for(; q < &itab[NTTYS]; q++)
		term(q);

#	ifdef	DEBUG
	if ( corpse.r_proc.p_pid != 0 )
	{
		error("corpse down but not dead!");
		corpse.r_proc.p_pid = 0;
	}
#	endif	DEBUG

	for( p = &itab[0] ; p < &itab[NTTYS] ; p++ )
		if(p->comn != '\0' && p->t_un.t_pid == 0)
			dfork(p);
}



/*
**	Start up a getty on a tty, after accounting the dead shell
*/

dfork(p)
	register struct tab *	p;
{
	register		pid;
	char			type[2];
#	ifdef	TTY_GROUP
	char			group[2];
#	endif	TTY_GROUP

	switch ( pid = fork() )
	{
	 case 0:
		setname("admin");
		admin( p, 1 );
		setname("init");
		resetsigs();
		signal(SIGINT, SIG_IGN);
		signal(SIGQUIT, SIG_IGN);
		setpgrp();
		maktty(p->line);
		chown(tty, 0, 0);
		chmod(tty, 0600);
		open(tty, 2);
		dup(0);
		dup(0);
		nice( 20 );
		type[0] = p->comn;
		type[1] = 0;
#		ifdef	TTY_GROUP
		group[0] = p->tgroup;
		group[1] = 0;
		execl(getty, getty+5, type, tty+(sizeof dev)-1, itoa( p->slot-1 ), group, (char *)0);
#		else	TTY_GROUP
		execl(getty, getty+5, type, tty+(sizeof dev)-1, itoa( p->slot-1 ), (char *)0);
#		endif	TTY_GROUP
#		ifdef	DEBUG
		error( getty );
#		endif	DEBUG
		exit(1);

	 case SYSERROR:
		sleep(2);
		admin( p, 0 );
	}
	p->t_un.t_pid = pid;
}



/*
**	Admin collects dead procs and updates the wtmp and passwd files
**
**		Note:	This should not be run in the main init, as it is
**			possible to get hung on locked passwd file.
*/

admin( p, flag )
	struct tab	*p;
	int		flag;	/* TRUE if not proc 1 */
{
	register	f;
	struct pwent	pe;
	struct utmp	utmp;

	if ( corpse.r_proc.p_pid == 0 )
		return;	/* already done */

	if ( p == &itab[NTTYS] )
		p = 0;

	pe.pw_limits.l_uid = corpse.r_lnode.l_uid;

	if ( getpwlog( &pe, (char *)0, 0 ) == SYSERROR )
	{
#		ifdef	DEBUG
		if ( flag )
			error("unknown uid!");
#		endif	DEBUG
		pe.pw_limits.l_uid = 1;
		getpwlog( &pe, (char *)0, 0 );
		corpse.r_lnode.l_refcount = 0;	/* NO tmpclean() ! */
	}

	pwclose();

	if ( corpse.r_lnode.l_refcount == 1 )	/* user's last proc */
	{
#		ifdef	USRTMP
		tmpclean(usrtmp, flag);
#		endif	USRTMP
		tmpclean(tmpdir, flag);
		pe.pw_limits.l_duse = corpse.r_lnode.l_duse;
		pe.pw_limits.l_usage = corpse.r_lnode.l_usage;
	}

	time( &pe.pw_extime );
	pe.pw_cputime += corpse.r_proc.xp_utime + corpse.r_proc.xp_stime;

	if ( p && (f = open(utmpf, 2)) != SYSERROR )
	{
		lseek( f, (long)((p->slot-1)*UTMPSIZ), 0 );

		if ( read(f, (char *)&utmp, UTMPSIZ) == UTMPSIZ )
		{
			if ( utmp.ut_line[0] )
				pe.pw_contime += pe.pw_extime - utmp.ut_time;
			else
				if ( pe.pw_limits.l_uid == 0 )	/* terminating getty */
				{
					close( f );
					return;
				}
			utmp.ut_line[0] = 0;	/* flag */
			utmp.ut_time = pe.pw_extime;
			lseek(f, -(long)UTMPSIZ, 1);
			write(f, (char *)&utmp, UTMPSIZ);
		}
		close(f);
	}

	pe.pw_limits.l_flags = corpse.r_lnode.l_flags & ~(LOGGEDIN|CURCLASS);

	updtpwent( &pe );
	pwclose();

	wrwtmp( p ? O_TYPE : W_TYPE, p );
}



/*
**	Tmpclean - clean user's files out of tmpd and update his disk usage,
*/

int
tmpclean(tmpd, flag)
	char *			tmpd;
	int			flag;	/* TRUE if not proc 1 */
{
	char			udirs[MAXUDIRS][DIRSIZ+1];
	struct stat		statb;
	struct { struct direct d; char zero; } dirb;
	register char		*name = dirb.d.d_name;
	register		fd;
	register dusage_t	dused = 0;
	register		dircount = 0;
	int			ret = 1;
#	define	dotdot(A)	(A[0]=='.'&&(A[1]==0||(A[1]=='.'&&A[2]==0)))

	if ( chdir( tmpd ) == SYSERROR )
		return ret;

	if ( (fd = open( tmpd, 0 )) != SYSERROR )
	{
		while ( read( fd, (char *)&dirb.d, sizeof dirb.d ) == sizeof dirb.d )
		{
			if ( dirb.d.d_ino
			     && !dotdot( name )
				&& stat( name, &statb ) != SYSERROR
				   && corpse.r_lnode.l_uid == statb.st_uid
			   )
			{
				chmod( name, 0700 );

				if ( (statb.st_mode & S_IFMT) == S_IFDIR )
				{
					if ( dircount < MAXUDIRS )
						strncpy( udirs[dircount++], name, DIRSIZ );
				}
				else
				{
					register	du;

					if ( (du = unlink( name )) != SYSERROR )
						dused += (dusage_t)du;
				}
			}
		}

		close( fd );
	}

	if ( dused < corpse.r_lnode.l_duse )
		corpse.r_lnode.l_duse -= dused;

	if ( dircount && flag )
	{
		register	pid;
		char *		rmtrargs[MAXUDIRS+3];

		switch ( pid = fork() )
		{
		 case SYSERROR:
			break;

		 case 0:
			while ( (pid = fork()) == SYSERROR )
				sleep(10);
			if ( pid )
				exit(0);	/* back to mother */
			resetsigs();
			rmtrargs[0] = RMTREENAME;
			rmtrargs[1] = RMTREEFLAG;

			for ( fd = 0 ; fd < dircount ; fd++ )
				rmtrargs[fd+2] = udirs[fd];

			rmtrargs[fd+2] = 0;

			open( ctty, 2 );
			dup( 0 );
			dup( 0 );
			limits( &corpse.r_lnode, L_SETLIM );	/* a REAL zombie ! */
			nice( 20 );
			execv( rmtree, rmtrargs );
#			ifdef	DEBUG
			error( rmtree );
#			endif	DEBUG
			exit( 1 );

		 default:
			while(wait((int *)0) != pid);
			ret = 0;
		}
	}

	chdir( homedir );
	return ret;
}



/*
**	Wrwtmp - write account record into wtmp file
*/

wrwtmp( type, p )
	register struct tab	*p;
{
	register		f;
	struct wtmp		wtmp;

	if ( (f = open( wtmpf, O_WRITE|O_APPEND )) != SYSERROR )
	{
		wtmp.w_type = type;

		if ( p )
		{
			register char *	cp;
			extern char *	strcmp();

			if ( strcmp(p->line, "console") == (char *)0 )
				cp = "co";
			else
				cp = p->line + strlen(p->line) - 2;

			wtmp.w_ttyid[0] = *cp++;
			wtmp.w_ttyid[1] = *cp;
		}

		wtmp.w_uid = corpse.r_lnode.l_uid;
		time( &wtmp.w_finishtime );
		ltol3( wtmp.w_usertime, &corpse.r_proc.xp_utime, 1 );
		ltol3( wtmp.w_systime, &corpse.r_proc.xp_stime, 1 );

		write( f, (char *)&wtmp, sizeof wtmp );
		close( f );
	}
}



/*
**	Enter accounting process id in list, return TRUE if successful
*/

enter( pid )
	short		pid;
{
	register short	*p;

	for ( p = plist ; p < &plist[NACP] ; p++ )
		if ( *p == 0 )
		{
			*p = pid;
			return 1;
		}

	return 0;
}



/*
**	Inlist returns TRUE if "pid" is successfully removed from list
*/

inlist( pid )
	register short	pid;
{
	register short	*p;

	for ( p = plist ; p < &plist[NACP] ; p++ )
		if ( *p == pid )
		{
			*p = 0;
			return 1;
		}

	return 0;
}




/*
**	Setsigs - sets signals used in communicating with proc 1
*/

setsigs()
{
	register	i;

	for ( i = 0 ; i < NST ; i++ )
		signal(ST[i].st_signo, ST[i].st_action);
}




/*
**	Ignsigs - ignore signals used in communicating with proc 1
**		  and remember previous state.
*/

ignsigs()
{
	register	i;

	for ( i = 0 ; i < NST ; i++ )
		ST[i].st_action = signal(ST[i].st_signo, SIG_IGN);
}




/*
**	Resetsigs - resets communication signals to default
*/

resetsigs()
{
	register	i;

	for ( i = 0 ; i < NST ; i++ )
		signal(ST[i].st_signo, SIG_DFL);
}




/*
**	Sigcatch - catch a signal and perform action from table ST
*/

sigcatch(s)
{
	register struct states *	sp;
	register jmp_buf *		j;

	signal(s, SIG_IGN);

	for ( sp = ST ; sp < &ST[NST] ; sp++ )
		if ( s == sp->st_signo && (j = sp->st_jmpbuf) != NULLBUF )
			longjmp(j, s);
}





/*
**	Setname - changes "initname"
*/

setname( cp )
	register char *	cp;
{
	register char *	np;

	np = initname;
	do
		*np++ = *cp;
	while
		(*cp++);
	while ( *np )
		*np++ = '\0';
}




/*
**	Setstate - change state name
*/

setstate(state)
	char	state;
{
	prevstate[0] = curstate[0];
	initname[INITSTATE] = curstate[0] = state;
}



/*
**	Error prints error message on console
**
**		WARNING - do not use in process 1, as this will attach init to a terminal!
*/

error( s )
	register char	*s;
{
	register	f;
	static char	id[]	= "\ninit: ";
#	ifdef	DEBUG
	extern		errno;
	int		se = errno;
#	endif	DEBUG

	if ( (f = open( ctty, 1 )) != SYSERROR )
	{
		write( f, id, (sizeof id)-1 );
#		ifdef	DEBUG
		if ( errno = se )
		{
			fcntl(f, F_DUPFD, 2);
			perror( s );
			close(2);
			errno = 0;
		}
		else
#		endif	DEBUG
		{
			while ( *s )
				write(f, s++, 1);
			write(f, "\n", 1);
		}
		close( f );
	}
}
E 1
