/*
 *	Mount
 *
 *	Returns exit codes as follows...
 *
 *	0 - Success
 *	1 - Failure, no mount performed.
 *	2 - Failure after mount has succeeded.
 *
 *	In the last case the file system is mounted, but "mtab" is
 *	incorrect.
 */

#include	<sys/param.h>	/* for NMOUNT */
#include	<stdio.h>
#include	<mtab.h>
struct	mtab mtab[NMOUNT];
char mtabf[] = MTABF;

main(argc, argv)
register char **argv;
{
	register struct mtab *mp;
	register char *np;
	int n, mf, ro;
	char outbuf[BUFSIZ];

	setbuf(stdout, outbuf);
	if ((mf = open(mtabf, 0)) == -1)
	{
		perror(mtabf);
		exit(1);
	}
	n = read(mf, mtab, sizeof mtab);
	if (n % sizeof mtab[0])
	{
		fprintf(stderr, "%s: wrong format\n", mtabf);
		exit(1);
	}
	if (argc == 1)
	{
		for (mp = mtab; mp < &mtab[NMOUNT]; mp++)
		{
			if (mp->m_file[0])
			{
				printf("%s on %s", mp->m_spec, mp->m_file);
				if (mp->m_prot)
					printf(" (Read only)");
				printf("\n");
			}
		}
		exit(0);
	}
	if (argc < 3)
	{
		fprintf(stderr, "Usage: mount [ special pathname [-] ]\n");
		exit(1);
	}
	ro = (argc > 3);
	if (mount(argv[1], argv[2], ro))
	{
		perror("mount");
		exit(1);
	}
	np = argv[1];
	while (*np++);
	np--;
	while (*--np == '/')
		*np = '\0';
	while (np > argv[1] && *--np != '/');
	if (*np == '/')
		np++;
	argv[1] = np;
	for (mp = mtab; mp < &mtab[NMOUNT]; mp++)
	{
		if (mp->m_file[0] == 0)
		{
			np = mp->m_spec;
			while (np < &mp->m_spec[sizeof mp->m_spec - 1])
				if ((*np++ = *argv[1]++) == 0)
					argv[1]--;
			np = mp->m_file;
			while (np < &mp->m_file[sizeof mp->m_file - 1])
				if ((*np++ = *argv[2]++) == 0)
					argv[2]--;
			mp->m_prot = ro;
			mp = &mtab[NMOUNT];
			while ((--mp)->m_file[0] == 0);
			close(mf);
			if ((mf = creat(mtabf, 0644)) == -1)
			{
				perror(mtabf);
				exit(2);
			}
			n = (mp-mtab+1) * (sizeof mtab[0]);
			if (write(mf, mtab, n) != n)
			{
				perror("write");
				exit(2);
			}
			exit(0);
		}
	}
	fprintf(stderr, "Mount table full\n");
	exit(2);
}
