#include	<cplot.h>
#include	<math.h>
#include	<setjmp.h>
#include	<signal.h>

#define		MODULE		0
#define		LINE		1
#define		ARC		2
#define		CIRCLE		3
#define		STRING		4
#define		CONNECTION	5

/* COLORS for the AED */
#define	RED	1
#define	GREEN	2
#define	YELLOW	3
#define	BLUE	4
#define	MAGENTA	5
#define	CYAN	6
#define	WHITE	7

/* structure for a list of points on a line */
union lineseg {
	struct {
		short	delta:14;
		short	dmode:2;
	} a;
	struct {
		short	delta1;
	} b;
	struct {
		short	deltax1:7;
		short	deltay1:7;
		short	dmode:2;
	} c;
};
#define DELTAX	0
#define DELTAY	1
#define DELTAXY	2
#define SDELTAXY 3

union unit {
	struct line {
		short			op:6;
		short			level:10;
		union	unit		*up;
		short			x, y;

		int	nsegs;
		union	lineseg *ls;
	} l;
	struct sarc {
		short			op:6;
		short			level:10;
		union	unit		*up;
		short			x, y;

		short	x1, y1;
		short	cx, cy;
	} arc;
	struct scir {
		short			op:6;
		short			level:10;
		union	unit		*up;
		short			x, y;

		short	rad;
	} cir;
	struct sstr {
		short			op:6;
		short			level:10;
		union	unit		*up;
		short			x, y;

		short			srot;
		short			sscale;
		unsigned short		cnt;
		char *sp;			/* space but more will be allocated */
	}str;
	struct smod {
		short			op:6;
		short			modnum:10;
		union	unit		*up;
		short			x, y;

		short			mrot;
		short			mscale;
	} mod;
};

#define NSYMS	100
#define NAMESIZ	  14

#define	DEF	  01	/* the module is defined */
#define	LIB	  02	/* the module is from a library */
#define TEMP	  04	/* the module is incore temporarily */
#define PRINT	 010	/* currently printing this module */
#define EDIT	 020	/* currently editing this module */
#define LEVEL	 040	/* this module has been processed for the level it
			   contains (to speed up printing) */

struct symbol {
	char		name[NAMESIZ];
	union unit	*list;
	short		def;
	short		size;
	short		mlevel;		/* the levels used in this module */
	long		discaddr;
};

extern struct symbol symtab[];
extern unsigned nsyms;
extern struct symbol *lookup();

/* maximum number of incore modules for printing */
#define MAXINCORE 10

int ed();
int print();
int clr();
int grid();
int writef();
int readf();
int lib();
int reset();
int new();
int setlevel();
int list();
int rename();
int wplot();
int plot();
int endit();
int set();
int size();
int debug();

struct table {
	char	*cmd;	/* command string */
	int	(*f)();	/* pointer to command function */
	char	argc;	/* number of arguments required, 0 means any count is passed */
	char	flg;	/* flag to indicate if command may be executed from edit mode */
	char	*usage;	/* usage string */
};

#define	BUFSZ	100

char *malloc();
char *realloc();
char *strncpy();
char *mktemp();
union unit *last();

extern float sscale;
extern float gridscale;
extern float xbottom, xtop;
extern float ybottom, ytop;

extern int line;
extern int levelmask;
extern double xsiz, ysiz;
extern float baser[4];
extern float scale;
extern int currscale;
extern int charscale;
extern int currrotation;

extern jmp_buf env;
extern jmp_buf plotenv;
extern plotting;
extern FILE *tempfile;
extern char *tempname;
extern int CHANGED;
char *mmalloc();
