#include	<stdio.h>
/*
 *	detab [infile [outfile] ]
 *		This program replaces all tabs by blanks
 *		in infile placing result in outfile.
 *		May be used as a filter.
 *		also see 'entab'
 */
#define EOLN	'\n'
#define CR	'\r'
#define FF	'\f'
#define TAB	'\t'
#define BS	'\b'

FILE	*iptr, *optr;

main(argc, argv)
char *argv[];
{
	register c, ocol;

	if(argc > 3)
	{
		fprintf(stderr, "Usage: detab [ infile [ outfile ] ]\n");
		return 1;
	}
	if(argc > 1)
	{
		if((iptr = fopen(argv[1], "r")) == NULL)
		{
			perror( argv[1] );
			return 1;
		}
	}
	else
	{
		iptr = stdin;	/* use standard input */
	}
	if(argc > 2)
	{
		if((optr = fopen(argv[2], "w")) == NULL)
		{
			perror( argv[2] );
			return 1;
		}
	}
	else
	{
		optr = stdout;	/* use standard output */
	}
	/* here beginneth the program */ 

	ocol = 0;
	while((c = getc(iptr)) != EOF)
	{
		switch(c)
		{
		case EOLN:
		case CR:
		case FF:
			putc(c, optr);
			ocol = 0;
			break;
		case TAB:
			do
			{
				putc(' ', optr);
				ocol++;
			}
			while((ocol%8) != 0);
			break;
		case BS:
			putc(c, optr);
			ocol--;
			break;
		default:
			putc(c, optr);
			ocol++;
			break;
		}
	}
	fflush(optr);
	return 0;
}
