/*
**	chown [name|uid] file ...
*/

#include	<local-system>
#include	<passwd.h>
#include	<stdio.h>




main( c , v )
	register		c;
	register char		*v[];
{
	struct pwent		pe;

	if ( c < 3 )
	{
		fprintf( stderr, "chown name|uid file ...\n" );
		return 1;
	}

	v++;
	pe.pw_strings[LNAME] = *v;
	if ( getpwuid( &pe, (char *)0, 0 ) == PWERROR )
	{
		if( v[0][0] >= '0' && v[0][0] <= '9' )
		{
			pe.pw_limits.l_uid = atoi(*v);
			if ( getpwlog( &pe, (char *)0, 0 ) == PWERROR )
				goto who;
		}
		else
		{
who:
			fprintf( stderr, "who?\n" );
			return 1;
		}
	}

	c--; v++;

	while ( --c )
	{
		if( chown( *v, (int)pe.pw_limits.l_uid, (int)pe.pw_gid ) == SYSERROR )
		{
			perror( *v );
		}
		v++;
	}

	return( 0 );
}
