/*
**	descriptions of things needed by "state" file handling routines
*/

#define	STATEFILE		"/etc/netstate"		/* AUTO Locked */
#define	MAXTOK			HOSTSIZE		/* max size of a string token in "state" file */

/*
**	Format of "netstats":-		[:host@date]...
**
**	Format of "state" file:-	host@date=bytes[,c-host['state]*rate]...
*/

/*
**	record type defintions
*/

enum host_typ
{
	null_t, host_t, chost_t, nchost_t, uchost_t
};

#define	NS_UP			'\0'
#define	NS_DN			'D'

/*
**	Structure to hold network statistics for a host
*/

struct net_stac
{
	struct net_stac *	ns_next;		/* next host !MUST BE FIRST! */
	struct net_stac *	ns_prev;		/* previous host */
	struct net_stac *	ns_search;		/* search tag */
	time_t			ns_date;		/* last time active */
	long			ns_bytes;		/* bytes received via this host */
	union { long uns_long; short uns_short[2]; } ns_un;
	enum host_typ		ns_type;		/* record tag */
	char			ns_host[HOSTSIZE];	/* host name */
	char			ns_state;		/* link state */
};

typedef struct net_stac *	Nsp;
#define	NULLNSP			(Nsp)0

#define	ns_rate			ns_un.uns_long		/* bytes/sec between this and previous */
#define	ns_links		ns_un.uns_short[0]	/* links to this host */
#define	ns_chosts		ns_un.uns_short[1]	/* connected hosts in next list */

/*
**	Declare lists
*/

Nsp				New_stacs;		/* latest net stats from file transfer */
Nsp				State_stacs;		/* contents of "state" file */
Nsp				Hosts_stacs;		/* reverse list of unique hosts */
Nsp				Home_stac;		/* pointer to NETID host */
Nsp				Prev_stac;		/* penultimate host in New_stacs */
char				Orglstate;		/* previous state for origin host */

/*
**	Routines declared in "statelib.c"
*/


int				hconnected();		/* TRUE if two args connected */
char *				findhost();		/* read state file, find directly connected host leading to arg */
int				getstats();		/* set up New_stacs from contents of passed string */
int				modstats();		/* modify State_stacs with new info from New_stacs */
char *				nextup();		/* find next host not mentioned in statistics */
char *				prevhost();		/* search statistics for previous host */
int				printstats();		/* print statistics from New_stacs */
FILE *				readstate();		/* read state file into State_stats */
int				setrates();		/* set rates by scanning contents of New_stacs */
int				upstate();		/* open, read, modify, and write new "state" file */
int				writestate();		/* write updated State_stacs to new "state" file */

Nsp				nsalloc();		/* allocate a new "net_stac" structure */

/*
**	Routines needed by "statelib.c"
*/

extern long			atol();			/* convert ascii string to long */
extern char *			ctime();		/* time conversion */
extern char *			malloc();		/* memory allocation *
int				neterror();		/* handles errors */
char *				strchr();		/* find char */
int				strncmp();		/* compare strings */
char *				strncpy();		/* copy strings */

/*
**	Miscellany
*/

#define	STREQUAL		0			/* "strncmp" value */
#define	NULLSTR			(char *)0
#define	min(A,B)		(A<B?A:B)
#define	HOUR			(60*60)
