
# print/file interface to "net"

USAGE="username:hostname [file ...]"

if [ $# -lt 1 ]
then
	echo "Usage: $0 $USAGE"
	exit 1
fi

case "$0"
in
	netpr)
		QFLAG=-p
		PFLAG=-P"-i$LNAME"
		;;
	netsend)
		QFLAG=-f
		PFLAG=
		;;
	*)
		echo "Usage: $0 $USAGE"
		exit 1
		;;
esac

NAME=`echo $1 | cut -d: -f1`
HOST=`echo $1 | cut -d: -f2`

if [ ${NAME}x = x -o ${HOST}x = x -o ${NAME}x = ${HOST}x ]
then
	echo "Usage: $0 $USAGE"
	exit 1
fi

if [ $# = 1 ]
then
	net $QFLAG -n$NAME -h$HOST $PFLAG
else
	shift
	for file
	do
		case $file
		in
			-*)
				if [ ${endflgs}x = x ]
				then
					flag="$flag $file"
					continue
				fi
				;;
			*)
				endfls=1
				;;
		esac
		net $QFLAG -n$NAME -h$HOST $PFLAG $flag $file
	done
fi
