/*
**	Read reply packet from remote
*/

#include	"proto.h"
#include	"list.h"
#include	"bytes.h"
#include	"timeouts.h"
#include	"err.h"


getreply(alp, remote)
	listp *	alp;
{
#	ifdef	DEBUG
	printf("getreply: ");
#	endif	DEBUG
	do
	{
		if ( tread(remote, &reply, sizeof reply, xtimeout) )
		{
			errs[E_TIMEOUTS].e_count++;
			return 0;
		}

		for(;;)
		{
			switch ( reply.r_typ & 0xff )
			{
			 case NAK:
				errs[E_NAKS].e_count++;
			 case ACK:
				starting = 0;
				break;
			 case ETX:
				if ( reply.r_seq == reply.r_typ )
					break;
			 default:
				if ( !starting )
					errs[E_SYNC].e_count++;
				reply.r_typ = reply.r_seq;
				if ( tread(remote, &reply.r_seq, 1, xtimeout) )
				{
					errs[E_TIMEOUTS].e_count++;
					return 0;
				}
				continue;
			}
			break;
		}
	}
	while
		( (*alp = inlist(reply.r_seq&0xff)) == (listp)0 );

#	ifdef	DEBUG
	printf("returns\n");
#	endif	DEBUG
	return reply.r_typ & 0xff;
}
