.text
/
/
/	subroutines for various spitbol functions that cannot
/	be done easily through normal pdp-11 instructions.
/
/
	.globl	adr,cmc,cvd,dvi,dvr,fts,itr,ldr
	.globl	mlr,ngr,rmi,rti,sbr,str,trc
/
/	register equates
/
cp	= r0
wa	= r1
wb	= r2
wc	= r3
xl	= r4
xr	= r5
ia	= wc
/
/	no floating point support - so just return
/
adr:dvr:ldr:mlr:sbr:
	mov	(sp)+,(sp)		/ remove parameter from stack
ngr:str:
fts:itr:rti:
	sev
	rts	pc
/
/	compare two character strings
/		xl -> first string
/		xr -> second string
/		wa =  length of strings
/
/	calling sequence
/
/		jsr	pc,cmc
/		.word	plbl1.		/ return to plbl1. if (xl)<(xr)
/		.word	plbl2.		/ return to plbl2. if (xl)>(xr)
/
cmc:	cmpb	(xl)+,(xr)+		/ compare two bytes
	bhi	xlgtxr			/ branch if high
	blo	xlltxr			/ branch if low
	sob	wa,cmc			/ loop thru string
	clr	xl
	clr	xr
	add	$4.,(sp)		/ bump over ppms
	rts	pc			/ equal - do normal return
xlltxr: clr	xl
	clr	xr
	mov	*(sp)+,pc		/ take exit parm 1.
xlgtxr: clr	xl
	clr	xr
	add	$2.,(sp)
	mov	*(sp)+,pc		/ take exit parm 2.
/
/	perform integer division consistent with arithmetic division
/
/	cvd - divide ia by 10. returning character code in wa
/
cvd:	mov	ia-1,-(sp)		/ save work register
	tst	ia			/ test dividend
	sxt	ia-1			/ extend high order part of dividend
	div	$10.,ia-1		/ divide by 10.
	mov	ia,wa			/ put remainder in wa
	mov	ia-1,ia			/ set quotient in ia
	mov	(sp)+,ia-1		/ restore work register
	neg	wa			/ make sign of remainder positive
	add	$60,wa			/ compute character code
	rts	pc			/ return
/
/	dvi - do integer division consistent with arithmetic division
/
dvi:	mov	ia-1,-(sp)		/ save work register
	mov	*4(sp),4(sp)		/ get divisor
	tst	ia			/ test dividend
	sxt	ia-1			/ extend high order part of dividend
	div	4.(sp),ia-1		/ divide by parameter on stack
	xor	ia,4.(sp)		/ are signs of divisor&remainder same?
	bge	1f			/ yes - skip
	dec	ia-1			/ no - adjust quotient down by 1.
1:	mov	ia-1,ia			/ return quotient
	mov	(sp)+,ia-1		/ restore work register
	mov	(sp)+,(sp)		/ remove parameter
	rts	pc			/ return
/
/	rmi - generate integer remainder consistent with dvi
/
rmi:	mov	ia-1,-(sp)	/ ssave work register
	mov	*4(sp),4(sp)		/ get divisor
	tst	ia			/ test dividend
	sxt	ia-1			/ extend high order part of dividend
	div	4.(sp),ia-1		/ divide by parameter on stack
	mov	ia,ia-1			/ save copy of remainder
	xor	ia-1,4.(sp)		/ are signs of divisor&remainder same?
	bge	1f			/ yes - skip
	add	4.(sp),ia		/ no - adjust remainder mod divisor
1:	mov	(sp)+,ia-1		/ restore work register
	mov	(sp)+,(sp)		/ remove parameter
	rts	pc			/ return
/
/	trc - translate characters
/
/	calling sequence
/
/		xl -> character string to be translated
/		xr -> translate table
/		wa =  length of string to be translated
/
trc:	mov	xr,-(sp)		/ (sp) -> translate table
	tst	wa			/ check for null string
	beq	2f
1:	movb	(xl),xr			/ pick up source byte
	add	(sp),xr			/ point to character in translate table
	movb	(xr),(xl)+		/ store translated character back
	sob	wa,1b			/ loop thru string
2:     tst     (sp)+		/ pop stack
	clr	xl			/ clear
	clr	xr			/  registers
	rts	pc			/ return
/
/
/
