#include	"../h/local.h"
#include	"ass00.h"
#include	"assex.h"

#define COPYFINAL	1
#define COPYTEMP	0

/*
 * collection of routines to deal with relocation business
 */

void	dataprocess();
void	textprocess();

relc_t *
text_reloc(glosym,off,typ) glob_t *glosym; {

	/*
	 * prepare the relocation that has to be done at text-offset off
	 * according to global symbol glosym.
	 * NOTE: The pointer glosym will point into mglobs[], while at
	 *       the time copyout() is called all the symbols here
	 *       will have disappeared.
	 *	 The procedure upd_reloc() will change this pointer
	 *	 into the one in xglobs[] later.
	 */

	if (nxtextreloc >= &textreloc[oursize->n_txtrel-1])
		tablecompress(textprocess,&tfile);
	nxtextreloc->r_off = off;
	nxtextreloc->r_val.rel_gp = glosym;
	nxtextreloc->r_typ = typ;	/* flags of instruction */
	return(nxtextreloc++);
}

relc_t *
data_reloc(arg,off,typ) {

	/*
	 * Same as above.
	 */

	if ( nxdatareloc >= &datareloc[oursize->n_datrel-1] )
		tablecompress(dataprocess,&dfile);
	nxdatareloc->r_off = off;
	nxdatareloc->r_val.rel_i = arg;
	nxdatareloc->r_typ = typ;
	return(nxdatareloc++);
}

copyout() {
	register i;

	/*
	 * Make the e.out file that looks as follows:
	 *
	 *	__________________________
	 *	|      MAGIC		 | \
	 *	|      FLAGS		 |  \
	 *	|      UNRESOLVED	 |   \
	 *	|      VERSION		 |    |	8 word header
	 *	|      <UNUSED>		 |    |	for interpreter selection
	 *	|      <UNUSED>		 |   /
	 *	|      <UNUSED>		 |  /
	 * 	|      <UNUSED>		 | /
	 *	|      NTEXT 		 | \
	 *	|      NDATA  		 |  \
	 *	|      NPROC 		 |   \
	 *	|      ENTRY-POINT       |    |	8 word header
	 *	|      NLINES  		 |    |	for interpreter proper
	 *      |      <UNUSED>          |   /
	 *	|      <UNUSED>          |  /
	 *	|      <UNUSED>		 | /
	 *	|________________________|
	 *	|			 |
	 *	|      TEXT		 |        if odd-sized zero filled
	 *	|			 |
	 *	|________________________|
	 *	|			 |
	 *	|      DATA		 |	  if odd-sized zero filled
	 *	|			 |
	 *	|________________________|
	 *	|			 |
	 *	|      PROCTABEL	 |
	 *	|			 |
	 *	|________________________|
	 *
	 *
	 */

	if ((i = creat(eout,0644)) < 0)
		fatal("can't create e.out");
	finit(&ifile,i);
	frewind(&tfile);
	frewind(&dfile);
	xputw(EMMAGIC,&ifile);
	xputw(intflags,&ifile);
	xputw(unresolved,&ifile);
	xputw(VERSION,&ifile);
	xputw(0,&ifile);
	xputw(0,&ifile);
	xputw(0,&ifile);
	xputw(0,&ifile);
	xputw((textbytes+1) & ~1,&ifile);
	xputw(datablocks,&ifile);
	xputw(procnum,&ifile);
	xputw(searchproc("_main",xprocs,oursize->n_xproc)->p_num,&ifile);
	xputw(sourcelines,&ifile);
	xputw(0,&ifile);
	xputw(0,&ifile);
	xputw(0,&ifile);

	textprocess(&tfile,&ifile,COPYFINAL);
	if(odd(textbytes))
		xputc(0,&ifile);

	dataprocess(&dfile,&ifile,COPYFINAL);
	for (i=0;i<procnum;i++) {
		xputw(proctab[i].pr_par,&ifile);
		xputw(proctab[i].pr_off,&ifile);
	}
	pflush(&ifile);
	close(ifile.fd);
}

dataprocess(f1,f2,final) FILE *f1,*f2; int final; {
	register relc_t *p;
	register n;
	FOFFSET i;

	p=datareloc;
	for (i=0;i<dataoff;i++) {
		if (i==p->r_off) {
			switch(p->r_typ) {
			case RELGLO:
				if (p->r_val.rel_gp->g_status&DEF) {
					n=p->r_val.rel_gp->g_val;
					p->r_typ= RELEMPTY;
				} else n = 0;
				break;
			case RELCON:
				n=p->r_val.rel_i;
				p->r_typ=RELEMPTY;
				break;
			case RELLOC:
			case RELHEAD:
				n=0;
				break;
			default:
				fatal("Bad r_typ in dataprocess");
			}
			xputw(xgetw(f1)+n,f2);
			p++; i++;
		} else
			xputc(xgetc(f1),f2);
	}
	if (final != COPYFINAL) {
		compress(datareloc,&nxdatareloc);
		for (p=datareloc;p<nxdatareloc;p++)
			if (p->r_typ == RELHEAD)
				lastheader = p;
	}
}

textprocess(f1,f2,final) FILE *f1,*f2; int final; {
	register relc_t	*p;
	register n;
	FOFFSET i;

	p=textreloc;
	for(i=0;i<textoff;i++) {
		if( i == p->r_off ) {
			if (p->r_typ&MNS) {
				p->r_typ =| RELEMPTY;
				n=p->r_val.rel_i;
			} else {
				if (p->r_val.rel_gp->g_status&DEF) {
					p->r_typ =| RELEMPTY;
					n=p->r_val.rel_gp->g_val;
				} else
					n=0;
			}
			switch(p->r_typ&MNXYZ) {
			default:
				fatal("Bad typ in relocation");
			case MN0:
				break;
			case MNX:
				if (odd(n))
					error("Bad offset during reloc",0);
				n =>> 1;
				break;
			case MNY:
				if (odd(n)) {
					if (n==1)
						n = 0;
					else
						error("Bad offset during reloc",0);
				} else
					n =>> 1;
				break;
			}
			n = (n<<8) | (n>>8 & 0377);	/* swap bytes */
			xputw(xgetw(f1) + n,f2);
			p++; i++;
		} else
			xputc(xgetc(f1),f2);
	}
	if (final != COPYFINAL)
		compress(textreloc,&nxtextreloc);
}

compress(table,endpointer) relc_t *table, **endpointer; {
	register relc_t *p1,*p2,*end;

	end = *endpointer;
	for (p1=table; p1 < end && !(p1->r_typ&RELEMPTY) ; p1++)
		;
	if (p1 >= end)
		fatal("relocation table overflow");
	p2 = p1;
	while (++p1 < end) {
		if (!(p1->r_typ&RELEMPTY)) {
			p2->r_val = p1->r_val;
			p2->r_typ = p1->r_typ;
			p2->r_off = p1->r_off;
			p2++;
		}
	}
	*endpointer = p2;
}

tablecompress(proc,f) int (*proc)(); FILE *f; {
	FILE copy;

	frewind(f);
	bmove(chp_cast f,chp_cast &copy,sizeof copy);
	finit(f,tmpfil());
	(*proc)(&copy,f,COPYTEMP);
        close(copy.fd);
}
