#include	"../h/local.h"
#include	"ass00.h"
#include	"assex.h"
#include	"../h/em1.h"
/*
** utilities of EM1-assembler/loader
*/

int globstep;

/*
 * glohash returns an index in table and leaves a stepsize in globstep
 *
 */

int glohash(aname,size) char *aname; {
	register char *p;
	register i;
	register sum;

	/*
	 * Computes a hash-value from a string.
	 * Algorithm is adding all the characters after shifting some way.
	 */

	for(sum=i=0,p=aname;*p;i =+ 3)
		sum =+ (*p++)<<(i&07);
	sum =& 077777;
	globstep = (sum / size) + 7;
	return(sum % size);
}

/*
 * lookup idname in labeltable , if it is not there enter it
 * return index in labeltable
 */

glob_t *glo2lookup(name,status) char *name; {

	return(glolookup(name,status,mglobs,oursize->n_mlab));
}

glob_t *xglolookup(name,status) char *name; {

	return(glolookup(name,status,xglobs,oursize->n_glab));
}

glob_t *glolookup(name,status,table,size)
char *name;	/* name */
int status;	/* kind of lookup */
glob_t *table;	/* which table to use */
int size;	/* size for hash */
{
	register glob_t *g;
	glob_t *x;
	register rem,j;

	/*
	 * lookup global symbol name in specified table.
	 * Various actions are taken depending on status.
	 *
	 * DEFINING:
	 *	Lookup or enter the symbol, check for mult. def.
	 * OCCURRING:
	 *	Lookup the symbol, should be known by now.
	 * IMPORTING:
	 *	Lookup or enter the symbol, noop if defined.
	 * FORWARDING
	 *	Lookup or enter the symbol, must be declared in module
	 * EXPORTING:
	 *	Lookup or enter the symbol, set EXP flag
	 * SEARCHING:
	 *	Lookup the symbol, return 0 if not found.
	 * ENTERING:
	 *	Lookup or enter the symbol, don't check
	 */

	rem = glohash(name,size);
	j = 0;
	g = &table[rem];
	while (g->g_name[0] != 0 && strcmp(name,g->g_name) != 0) {
		j++;
		if (j>size)
			fatal("global label table overflow");
		rem = (rem + globstep) % size;
		g = &table[rem];
	}
	if (g->g_name[0] == 0) {
		/*
		 * This symbol is shining new.
		 * Enter it in table except for status = SEARCHING
		 */
		if (status == SEARCHING)
			return(0);
		strcpy(g->g_name,name);
		g->g_status = 0;
		g->g_val=0;
	}
	switch(status) {
	case SEARCHING:	/* nothing special */
	case ENTERING:
		break;
	case FORWARDING:	/* noop if defined already */
		if ((g->g_status&DEF) == 0)
			g->g_status =| FWD;
		break;
	case IMPORTING:		/* lookup in other table */
		x = xglolookup(g->g_name,SEARCHING);
		if (x && (x->g_status&DEF)) {
			g->g_status =| DEF;
			g->g_val = x->g_val;
		}
		g->g_status =| IMP;
		break;
	case EXPORTING:	/* nothing special */
		g->g_status =| EXP;
		break;
	case DEFINING:	/* Thou shalt not redefine */
		if (g->g_status&DEF)
			error("global symbol %s redefined",name);
		g->g_status =| DEF;
		break;
	case OCCURRING:	/* Should be defined or imported by now */
		if ((g->g_status&(DEF|IMP|FWD)) == 0)
			error("undefined global symbol %s",name);
		g->g_status =| OCC;
		break;
	default:
		fatal("bad status in glolookup");
	}
	return(g);
}

#define locstep 1

#define lochash(n) (((n)-1)%oursize->n_llab)

locl_t *loclookup(an,status) {
	register locl_t *lbp;
	register num,i;

	if (nlocs == oursize->n_llab)
		fatal("local label table overflow");
	num = an;
	i = lochash(num);
	lbp = &locs[i];
	while (lbp->l_num != num && lbp->l_num != 0) {
		i = (i + locstep) % oursize->n_llab;
		lbp = &locs[i];
	}
	if (lbp->l_num == 0) {
		lbp->l_num=num;
		lbp->l_defined = (status==OCCURRING ? NO : YES);
		lbp->l_val=0;
		++nlocs;
	} else 
		if (status == DEFINING) {
			if (lbp->l_defined == YES)
				error("multiple defined local symbol",0);
			else
				lbp->l_defined = YES;
		}
	if (status == DEFINING)
		lbp->l_defl= last_line;
	return(lbp);
}

proc_t *prolookup(name,status) char *name; {
	register proc_t *p;
	register pstat;

	/*
	 * Look up a procedure name according to status
	 *
	 * PRO_OCC:
	 *	Search both tables, local table first.
	 *	If not found, enter in global table
	 * PRO_LOC:
	 *	Enter symbol in local table.
	 * PRO_DFL:
	 *	Define local procedure.
	 * PRO_DFX:
	 *	Define external procedure.
	 */

	switch(status) {
	case PRO_OCC:
		p = searchproc(name,mprocs,oursize->n_mproc);
		if (p->p_name[0]) {
			p->p_status =| OCC;
			return(p);
		}
		p = searchproc(name,xprocs,oursize->n_xproc);
		if (p->p_name[0]) {
			p->p_status =| OCC;
			return(p);
		}
		++unresolved;
		pstat = OCC|IMP;
		break;
	case PRO_LOC:
		p = searchproc(name,mprocs,oursize->n_mproc);
		if (p->p_name[0])
			error("pro %s redeclared by FWP",name);
		pstat = 0;
		break;
	case PRO_DFL:
		p = searchproc(name,mprocs,oursize->n_mproc);
		if (p->p_name[0]) {
			if (p->p_status&DEF)
				error("local pro %s redeclared",name);
			p->p_status =| DEF;
			return(p);
		}
		pstat = DEF;
		break;
	case PRO_DFX:
		if (searchproc(name,mprocs,oursize->n_mproc)->p_name[0])
			error("global pro %s already exists local",name);
		p = searchproc(name,xprocs,oursize->n_xproc);
		if (p->p_name[0]) {
			if (p->p_status&(DEF|EXP))
				error("global pro %s redeclared",name);
			p->p_status =| (DEF|EXP);
			--unresolved;
			return(p);
		}
		pstat = DEF|EXP;
		break;
	default:
		fatal("bad status in prolookup");
	}
	return(enterproc(name,pstat,p));
}

proc_t *searchproc(name,table,size)
	char *name;
	proc_t *table;
	int size;
{
	register proc_t *p;
	register rem,j;

	/*
	 * return a pointer into table to the place where the procedure
	 * name is or should be if in the table.
	 */

	rem = glohash(name,size);
	j = 0;
	p = &table[rem];
	while (p->p_name[0] != 0 && strcmp(name,p->p_name) != 0) {
		j++;
		if (j>size)
			fatal("procedure table overflow");
		rem = (rem + globstep) % size;
		p = &table[rem];
	}
	return(p);
}

proc_t *enterproc(name,status,place)
char *name;
char status;
proc_t *place; {
	register proc_t *p;

	/*
	 * Enter the procedure name into the table at place place.
	 * Place had better be computed by searchproc().
	 *
	 * NOTE:
	 *	At this point the procedure gets assigned a number.
	 *	This number is used as a parameter of cal and in some
	 *	other ways. There exists a 1-1 correspondence between
	 *	procedures and numbers.
	 *	Two local procedures with the same name in different
	 *	modules have different numbers.
	 */

	p=place;
	strcpy(p->p_name,name);
	p->p_status = status;
	if (procnum>=oursize->n_proc)
		fatal("too many procedures");
	p->p_num = procnum++;
	return(p);
}
