/*
 * compile time options
 */

/* #define DUMP		1	/* dump between passes */
/* #define TIMING	1	/* some timing measurements */

#ifndef DUMP
#define dump()			/* nothing */
#endif

#ifndef TIMING
#define timing()		/* nothing */
#endif

/*
 * incompatibilities between C version 6 and C version 7
 */

#ifdef C7
#define	lnp_cast		(line_t *)
#define gbp_cast		(glob_t *)
#define lbp_cast		(locl_t *)
#define prp_cast		(proc_t *)
#define ptp_cast		(ptab_t *)
#define rlp_cast		(relc_t *)
#define chp_cast		(char   *)
#define ipp_cast		(int   **)
#define iip_cast		(int    *)
#define	int_cast		(int     )
/* inclusion of UNIX V7 archive header here could not be done by an include
   because version 6 C includes files even if not IFDEFFED */
#define	ARMAG	0177545
struct	ar_hdr {
	char	ar_name[14];
	long	ar_date;
	char	ar_uid;
	char	ar_gid;
	int	ar_mode;
	long	ar_size;
};
/* end of inclusion */
#endif

#ifndef C7
#define	lnp_cast	/* nothing */
#define	gbp_cast	/* nothing */
#define	lbp_cast	/* nothing */
#define	prp_cast	/* nothing */
#define	ptp_cast	/* nothing */
#define	rlp_cast	/* nothing */
#define	chp_cast	/* nothing */
#define	ipp_cast	/* nothing */
#define	iip_cast	/* nothing */
#define	int_cast	/* nothing */
#define	ARMAG		0177555
struct	ar_hdr {	/* definition of UNIX archive header */
	char	ar_name[8];
	int	ar_date[2];
	char	ar_uid;
	char	ar_mode;
	int	ar_size;
};
#endif

#ifdef NC6
#define C7	1
#endif

#ifdef C7
typedef	struct lines		line_t;
typedef	struct loc_label	locl_t;
typedef	struct glob_label	glob_t;
typedef	struct rel		relc_t;
typedef	struct mnems		mnem_t;
typedef	struct sizes		size_t;
typedef	struct ar_hdr		arch_t;
typedef	struct procs		proc_t;
typedef	struct proctab		ptab_t;
typedef struct file		FILE;

typedef union {
	int	ad_i;
	locl_t	*ad_lp;
	glob_t	*ad_gp;
	proc_t	*ad_pp;
}	addr_u;

typedef union {
	int	rel_i;
	locl_t	*rel_lp;
	glob_t	*rel_gp;
} rel_u;

#define	EQ			=
#endif
#ifndef C7
#define	line_t	struct lines
#define	locl_t	struct loc_label
#define	glob_t	struct glob_label
#define	relc_t	struct rel
#define	mnem_t	struct mnems
#define	size_t	struct sizes
#define	arch_t	struct ar_hdr
#define	proc_t	struct procs
#define	ptab_t	struct proctab
#define	FILE	struct file

#define addr_u	int
#define rel_u	int

#define	EQ		/* nothing */
#endif

#define FOFFSET		unsigned		/* offset into file */

/*
 * Global variables and definitions for EM1-assembler/loader
 */

#define DEFINING	0	/* parameters for glolookup */
#define OCCURRING	1
#define IMPORTING	2
#define EXPORTING	3
#define SEARCHING	4
#define ENTERING	5
#define FORWARDING	6

#define PRO_OCC		0	/* parameters for prolookup */
#define PRO_LOC		1
#define PRO_DFL		2
#define PRO_DFX		3

#define ESC		0	/* escape byte in code */

#define TRUE		1
#define FALSE		0

#define EMMAGIC		(172|(14<<8))
#define CCMAGIC		(172|(0<<8))
#define ARCCMAGIC	(172|(1<<8))
#define ARGUARD		(172|(2<<8))

#define IDLENGTH	8	/* length of glo's and pro's */
#define MAXSTRING	200
#define MRKDEPTH	40
#define ABSSIZE		8

#define odd(n)	((n)&1)		/* boolean odd function */

struct	lines {
	char	instr_num;	/* index into menmon[] */
	char	type1;		/* see below */
	addr_u	ad;		/* depending on type, various pointers */
	char	format;		/* see below */
	char	length;		/* superfluous, is determined by format */
};

/* contents of type1 */
#define MISSING		0	/* no operand */
#define CONST		1	/* ad contains operand */
#define PROCNAME	2	/* ad contains struct procs pointer */
#define GLOSYM		3	/* ad contains pointer into mproc[] */
#define LOCSYM		4	/* ad contains pointer into locs[] */
#define PSEUDO		5	/* pseudo instruction on this line */

/* contents of format */
#define UNDEF		0	/* no format yet */
#define F00		1	/* no code for this line */
#define FNN		2	/* No escape, no operand, 1 byte */
#define FEN		3	/* Escape, no operand, 2 bytes */
#define FNL		4	/* No escape, long operand, 3 bytes */
#define FEL		5	/* Escape, long operand, 4 bytes */
#define FNS		6	/* No escape, short operand, 2 bytes */
#define FES		7	/* Escape, short operand, 3 bytes */
#define FNM		8	/* No escape, operand in opcode, 1 byte */

struct	loc_label {
	int	l_num;		/* number of label */
	char	l_defined;	/* see below */
	int	l_min,l_max;	/* boundaries of value */
	int	l_val;		/* real value */
	struct lines	*l_defl;	/* pointer to line in which defined */
};

/* contents of l_defined */
#define NO		0	/* not defined yet */
#define YES		1	/* defined */
#define REVERSE		2	/* intermediate state */

struct	glob_label {
	char	g_name[IDLENGTH+1];	/* name + null-byte */
	char	g_status;	/* see below */
	int	g_val;		/* value if status&DEF */
};

/* contents of g_status */
#define DEF		01	/* defined */
#define OCC		02	/* used */
#define IMP		04	/* imported */
#define EXP		010	/* exported */
#define REL		020	/* relocatable */
#define FWD		040	/* forward referenced */

struct	rel {			/* for relocation tables */
	FOFFSET	r_off;		/* offset in text/data of word to relocate */
	rel_u	r_val; 	/* constant or pointer to global symbol */
	int	r_typ;		/* different use in text or data */
};

/*
 * When used with textrelocation r_typ contains the MNXYZ bits as defined
 * below together with the MNS bit if r_val contains an integer
 */

/* Contents of r_typ when used with data relocation */
#define RELEMPTY	010000		/* used in text as well as data */
#define RELGLO		0
#define RELLOC		1
#define RELCON		2
#define RELHEAD		3

/* modes of data output */
#define DATA_NUL	0
#define DATA_BSS	1
#define DATA_CON	2
#define DATA_POINTER	3
#define DATA_LONG	4
#define DATA_REAL	5

/* headers of datablocks written */
#define HEADBSS		0000000
#define HEADCON		0100000
#define HEADPOINTER	0120000
#define HEADLONG	0140000
#define HEADREAL	0160000

struct	mnems {
	char	m_name[3];	/* ascii name */
	char	m_nminis;	/* # of operands that fit in the opcode */
	char	m_mbase;	/* lowest of these */
	char	m_nshorties;	/* # of operand-groups with hibyte in opcode */
	char	m_sbase;	/* lowest of these */
	char	m_obase;	/* opcode of long instruction */
	int	m_flags;	/* see flags */
};

/* definition of m_flags */
#define MN0		0	/* pseudo flag to indicate normal case */
#define MNS		01	/* shorties or no operand escaped */
#define MNL		02	/* long instruction escaped */
#define MNXYZ		014	/* determines legal values of operand */
#define		MNX	004	/* only even operands allowed */
#define		MNY	010	/* only 1,2,4,6 etc.. allowed */
#define		MNZ	014	/* no operands */
#define MNABCEM		0160	/* a variety of instructions exists */
#define		MNA	0020	/* alternate context mark */
#define		MNB	0040	/* branch instruction */
#define		MNM	0060	/* normal context mark */
#define		MNC	0100	/* call instruction */
#define		MNE	0120	/* instruction with address of external */
#define	MNO		0200	/* minis start at 1 not at 0 */

#define NDEFAULT	3	/* number of different sizes available */
struct	sizes {
	int	n_lines;	/* # of lines per proc */
	int	n_llab;		/* # of local lables per proc */
	int	n_mlab;		/* # of global labels per module */
	int	n_glab;		/* # of extern global labels */
	int	n_mproc;	/* # of local procs per module */
	int	n_xproc;	/* # of external procs */
	int	n_proc;		/* total # of procedures */
	int	n_txtrel;	/* # of relocations in text */
	int	n_datrel;	/* # of relocations in data */
};

struct	procs {			/* format of mprocs[] and xprocs[] */
	char	p_name[IDLENGTH+1];	/* name + 1 null-byte */
	char	p_status;	/* same bits as g_status except REL */
	int	p_num;		/* unique procedure descriptor */
};

struct	proctab {
	int	pr_off;		/* distance from pb */
	int	pr_par;		/* number of bytes parameters */
};


#define	BUFSIZ		512

struct	file {
	int	fd;
	int	nleft;
	char	*nextp;
	char	buff[BUFSIZ];
};

#ifndef C7
struct {int	ad_i;};
struct {locl_t	*ad_lp;};
struct {glob_t	*ad_gp;};
struct {proc_t	*ad_pp;};
struct {int	rel_i;};
struct {locl_t	*rel_lp;};
struct {glob_t	*rel_gp;};
#endif

#define	LONGTYPE	long
