(*	SEARCH scans file input and prints all lines that match the pattern
		passed as an argument to it on the command line *)
program search(input, output);
const
	maxpat = 50;	(* This constant should be somewhat larger
			   but smaller values make testing easier *)
type
	(* Pattern Data Structure *)
	patindextype = 0..maxpat;
	charset = set of char;
	itemtype = record
			(* Item can be repeated 0 or more times *)
			repeated : Boolean;
			(* Set of possible characters to be matched *)
			possiblechars : charset
		   end;
	patterntype = record
			(* Match pattern from the beginning of line *)
			matchatstart,
			(* Match pattern to the end of the line *)
			matchatend : Boolean;
			(* Items are to match a contiguous string
			  within a line *)
			patitems : array[1..maxpat] of itemtype;
			(* Number of items in the pattern *)
			patlen : patindextype
		      end;
	(* Error message string type *)
	msgtype = packed array[1..50] of char;
var
	pattern : patterntype;	(* Internal representation of pattern *)

procedure error(msg : msgtype);
begin
	message('search: ',msg);
	halt
	{ false }
end (* error *);

#include "getpattern.i"

#include "scanfile.i"

begin (* search *)
	getpattern(pattern);
	{ pattern = internal form of argument from command line }
	scanfile(pattern, input)
	{ All lines in file input that match pattern have been printed }
end (* search *).
