#include "const.h"
#include "y.tab.h"

struct labltab *findlbl();
char	*keywd[] =
	{
		"comp",	"c",	"else",	"end",
		"gc", 	"ic",	"if",	"lit",
		"l",	"not", 	"reset","r",
		"set",	"slit",	"then", "when",
		"zext",	"z"
	};
char	*condtb[] =
	{
		"abt",	"aov",	"cov",	"gc1",
		"gc2", 	"int",	"lc1",	"lc2",
		"lc3", 	"lst",	"mst",	"rdc",
		"sai"
	};
char	*keywd2[] =
	{
		"a1",	"a2",	"a3",	"ampcr",
		"ctr",	"csar"
	};
char	*bdesttb[] =
	{
		"bad",	"bba",	"bbe",	"bbi",
		"bc4",	"bc8",	"bex",	"bmi",
		"br1",	"br2"
	};
char	*mdesttb[] =
	{
		"mar",	"mar1",	"mar2",	"mir"
	};
char	*lisdest[] =
	{
		"lctr",	"lmar",	"inc",	"sar"
	};
char	*mdoptb[] =
	{
		"mr1",	"mr2",	"mw1",	"mw2",
		"dr1",	"dr2",	"dw1",	"dw2"
	};
int	mdopta[] =
	{
		2,	3,	6,	7,
		10,	11,	14,	15
	};
char	*adoptbl[] =
	{
		"+",	"nor",	"nri",	"++",
		"nan",	"oad",	"xor",	"nim",
		"imp",	"eqv",	"aad",	"and",
		"--",	"rim",	"or",	"-"
	};
char	*suctbl[] =
	{
		"wait",
		"step",
		"save",
		"skip",
		"jump",
		"exec",
		"call",
		"retn"
	};

yylex()
{
	extern int yylval;
	extern char	*skipblank();
	register int a;

	if( EOL )
	{
		for( a=0 ; a<16 ; a++ )	nano[a] = 0;
		for( a=0 ; a<4 ; a++ )	mpm[a] = 0;

		a = readline(fdi,buf);
		if( a == 0 )	return( '\0' );
		if( a == -1 )
		{
			perr("Read error on input");
			return( '\0' );
		}

		if( ECHO )
		{
			printf("%4d	",linecnt);
			fprintf(stdout,buf);
		}
		setflg = FALSE;
		mflag = FALSE;
		sucflg = FALSE;
		lopflag = FALSE;
		ctrflag = FALSE;
		lctrflg = FALSE;
		marflag = FALSE;
		lmarflg = FALSE;
		sarflag = FALSE;
		csarflg = FALSE;
		compl = FALSE;
		sflag = FALSE;
		litflg = FALSE;
		destflg = FALSE;
		plusflg = FALSE;
		minusflg = FALSE;
		lbflag = FALSE;
		litfirst = FALSE;
		EOL = FALSE;

		x_input = 0;
		y_input = 0;
		p1 = buf;
		litptr = litarr;

		if( a <= 0 )
		{
			if( a < 0 )	printf("Read error on input.\n");
			return( 0 );
		}
	}
	p1 = skipblank(p1);

	if( *p1 == '\n' || *p1 == '$' )
	{
		EOL = TRUE;
		return( '\n' );
	}
/*
 *	test for a digit on input.
 *	0 and 1 are special cases in the rules section.
 */
	if( *p1 >= '0' && *p1 <= '9' )
	{
		yylval = readnum(p1);
		p1 = nxtkey(p1);

		if( yylval == 0 )
		{
			if( chk01(p1) )	return( ADZERO );
			else		return( '0' );
		}
		if( yylval == 1 )
		{
			if( chk01(p1) )	return( ADONE );
			else		return( '1' );
		}
		return( NUMBER );
	}
	if( (*p1 >= 'a' && *p1 <= 'z') || (*p1 >= 'A' && *p1 <= 'Z') )
	{
		if( *p1 == 'b' )
		{
			if( a = btest() )	return( a );
		}
/*
 *	now check for key words...
 *	note that keytest, mdoptst, adoptst and succtst set the
 *	value of yylval themselves.
 */
		if( adoptst() )		return( ADDOP );
		if( succtst() )		return( SUCCESSOR );
		if( test( "commnt",p1 ) )
		{
			*p1 = '\n';
			return( COMMENT );
		}

		switch( *p1 )
		{
		case 'a':
			if( (a = search( keywd2,0,3,p1 )) != -1 )
			{
				p1 = nxtkey(p1);
				destflg = TRUE;
				if( adtype() )	return( keyw2a[a] );
				else	return( keyw2[a] );
			}
			if( a = lookup( condtb,condta,0,1 ) )
				return( a );
			break;
		case 'b':
			if( a = lookup( bdesttb,destbtbl,0,9 ) )
			{
				destflg = TRUE;
				return( a );
			}
			break;
		case 'c':
			if( (a = search( keywd2,4,5,p1 )) != -1 )
			{
				p1 = nxtkey(p1);
				destflg = TRUE;
				if( adtype() )	return( keyw2a[a] );
				else	return( keyw2[a] );
			}
			if( a = lookup( condtb,condta,2,2 ) )
				return( a );
			if( a = lookup( keywd,keyword,0,1 ) )
				return( a );
			break;
		case 'd':
			if( yylval = lookup( mdoptb,mdopta,4,7 ) )
				return( MDOP );
			break;
		case 'e':
			if( a = lookup( keywd,keyword,2,3 ) )
				return( a );
			break;
		case 'g':
			if( a = lookup( keywd,keyword,4,4 ) )
				return( a );
			if( a = lookup( condtb,condta,3,4 ) )
				return( a );
			break;
		case 'i':
			if( a = lookup( keywd,keyword,5,6 ) )
				return( a );
			if( a = lookup( condtb,condta,5,5 ) )
				return( a );
			if( a = lookup( lisdest,destlis,2,2 ) )
			{
				destflg = TRUE;
				return( a );
			}
			break;
		case 'l':
			if( a = lookup( keywd,keyword,7,8 ) )
				return( a );
			if( a = lookup( condtb,condta,6,9 ) )
				return( a );
			if( a = lookup( lisdest,destlis,0,1 ) )
			{
				destflg = TRUE;
				return( a );
			}
			break;
		case 'm':
			if( yylval = lookup( mdoptb,mdopta,0,3 ) )
				return( MDOP );
			if( a = lookup( condtb,condta,10,10 ) )
				return( a );
			if( a = lookup( mdesttb,destmtbl,0,3 ) )
			{
				destflg = TRUE;
				return( a );
			}
			break;
		case 'n':
			if( a = lookup( keywd,keyword,9,9 ) )
				return( a );
			break;
		case 'r':
			if( a = lookup( keywd,keyword,10,11 ) )
				return( a );
			if( a = lookup( condtb,condta,11,11 ) )
				return( a );
			break;
		case 's':
			if( a = lookup( keywd,keyword,12,13 ) )
				return( a );
			if( a = lookup( condtb,condta,12,12 ) )
				return( a );
			if( a = lookup( lisdest,destlis,3,3 ) )
			{
				destflg = TRUE;
				return( a );
			}
			break;
		case 't':
			if( a = lookup( keywd,keyword,14,14 ) )
				return( a );
			break;
		case 'w':
			if( a = lookup( keywd,keyword,15,15 ) )
				return( a );
			break;
		case 'z':
			if( a = lookup( keywd,keyword,16,17 ) )
				return( a );
		}

		yylval = (int)(p1);
		p1 = nxtkey(p1);

		if( *p1 != '.' )
		{
			lbflag = TRUE;
			return( LABEL );
		}
		else
		{
			p1++;
			return( LBLDOT );
		}
	}
	if( *p1 == ',' )	return( commatype(p1++) );
	if( *p1 == '+' )	return( plustype(p1++) );
	if( *p1 == '-' )	return( minustype(p1++) );

	if( *p1 == '=' )	destflg = TRUE;
	return( *p1++ );
}

succtst()
{
	register int	a;

	for( a=0 ; a<8 ; a++ )
	{
		if( test( suctbl[a],p1 ) )
		{
			yylval = a;
			p1 = nxtkey(p1);
			return( TRUE );
		}
	}
	return( FALSE );
}

adoptst()
{
	register int	a;

	for( a=0 ; a<16 ; a++ )
	{
		if( test( adoptbl[a],p1 ) )
		{
			yylval = a;
			p1 = nxtkey(p1);
			return( TRUE );
		}
	}
	return( FALSE );
}

test(sp1,sp2)
register char	*sp1,*sp2;
{
/*
 *	keyword is in string pointed to by sp1, input string is
 *	pointed to by sp2.
 */
	while( *sp1 )
	{
		if( *sp1++ != *sp2++ )	return( FALSE );
	}
/*
 *	now check that sp2 contains no more alphanumeric characters
 *	since we don't want strings such as "whenever" or "notes"
 *	to be taken as key words.
 */
	if( *sp2 >= 'a' && *sp2 <= 'z' ||
	    *sp2 >= 'A' && *sp2 <= 'Z' ||
	    *sp2 >= '0' && *sp2 <= '9' )	return( FALSE );

	return( TRUE );
}

perr(sptr)
register char	*sptr;
{
	extern	char	*itoa();
	extern	int	yyline;

	printf("Line ");
	printf(itoa(yyline,4));
	printf(" : ");
	printf("Error - ");
	printf(sptr);
	printf(".\n");
	errcnt++;
	return;
}

litstore(a,b)
struct	litinfo	*a;
int	b;
{
	int	c;

	c = a->litvalu;
	if( a->flagl )
	{
		switch( b )
		{
		case AMPCR:	mpm[0] = 014;
		case SAR:	return;
		case LIT:	nano[1] = TRUE;	/* use nano for flags */
		case SLIT:	if( sflag )	mpm[0] |= 010;
				else		mpm[0] = 016;
				if( litfirst )	nano[0] = TRUE;
				return;
		}
	}

	switch( b )
	{
	case AMPCR:
		if( c >= 010000 )	perr("ampcr literal too big");
		mpm[0] = 014;
		mpm[1] = (c>>8) & 017;
		mpm[2] = (c>>4) & 017;
		mpm[3] = c & 017;
		return;
	case SAR:
		if( a->flagc )	c++;
		if( c >= 040 )	perr("sar literal too big");
		mpm[0] |= (c>>3) & 03;
		mpm[1] = (c & 03) | ((c<<1) & 010);
		return;
	case LIT:
		if( c >= 0400 )	perr("lit literal too big");
		if( sflag )	mpm[0] |= 010;
		else		mpm[0] = 016;
		mpm[2] = (c>>4) & 017;
		mpm[3] = c & 017;
		return;
	case SLIT:
		if( a->flagc )	c++;	/* twos comp */
		if( c >= 040 )	perr("slit literal too big");
		if( sflag )	mpm[0] |= 010;
		else		mpm[0] = 016;
		mpm[2] = (c>>3) & 03;
		mpm[3] = c & 03 | (c<<1) & 010;
		return;
	}
}

length(sptr)
register char	*sptr;
{
	register int	i;

	i = 0;

	while(	('a' <= *sptr && *sptr <= 'z') ||
		('A' <= *sptr && *sptr <= 'Z') ||
		('0' <= *sptr && *sptr <= '9') )
	{
		sptr++;
		i++;
	}
	return( i );
}

printhex(a,fd)
FILE *fd;
{
	register int	x,y,z;
	char	ctemp;
	extern	char	buf1[];
	char	*pptr;
	extern	char	*itoa();

	fprintf(fd,itoa(linecnt,4));
	pptr = buf1;
/* note that itoa also uses buf1 */
	for( x=0 ; x<4 ; x++ )	*pptr++ = ' ';

	for( x=0 ; x<4 ; x++ )
	{
		ctemp = mpm[x] + '0';
		if( ctemp > '9' )	ctemp += 'a' - '9' - 1;
		*pptr++ = ctemp;
	}

	for( x=0 ; x<4 ; x++ )	*pptr++ = ' ';

	if( a )
	{
		for( x=0 ; x<4 ; x++ )
		{
			z = 4*(x+1);

			for( y=4*x ; y<z ; y++ )
			{
				ctemp = nano[y] + '0';
				if( ctemp > '9' )	ctemp += 'a' -'9' - 1;
				*pptr++ = ctemp;
			}

			for( y=0 ; y<4 ; y++ )	*pptr++ = ' ';
		}
	}
	*pptr++ = '\n';
	*pptr++ = '\0';
	fprintf(fd,buf1);
	return;
}

storelit(ptr)
register char	*ptr;
{
	register int	b;
	register char	*ptmp;
	int	a;

	a = length(ptr);
	labtmp.lblsize = a;
	if( a > LABSIZE )	a = LABSIZE;
	ptmp = labtmp.lblbuf;

	for( b=0 ; b<a ; b++ )
	{
		*ptmp++ = *ptr++;
	}

	if( a < LABSIZE )	*ptmp = '\0';
	fwrite(labtmp.lblbuf, LABSIZE, 1, fdl);
	fwrite((char *)(&labtmp.lblsize), 2, 1, fdl);
	fwrite((char *)(&linecnt), 2, 1, fdl);
	fwrite((char *)(&litptr->flagl), 2, 1, fdl);
	return;
}

storelbl(ptr)
register char	*ptr;
{
	register char	*ptmp;
	register int	b;
	int	a;

	if( ovflg )	return;		/* only one message */
	if( labcnt++ > LABDIM )
	{
		perr("too many labels defined");
		ovflg = TRUE;
		return;
	}
	a = length( ptr );
	labptr->lblsize = a;
	if( a > LABSIZE )	a = LABSIZE;
	labptr->lbladdr = linecnt;
	ptmp = labptr->lblbuf;

	for( b=0 ; b<a ; b++ )
		*ptmp++ = *ptr++;

	labptr++;
	return;
}

adtype()
/*
 *	Check to see if the keyword is an adder input or not.
 *	This comes under the heading of "removing ambiguities".
 */
{
	register char	*ptr;

	for( ptr=p1 ; *ptr != '=' ; ptr++ )
	{
		if( *ptr == ',' || *ptr == '\n' || *ptr == '$')	return( FALSE );
	}
	return( TRUE );
}

btest()
{
	register char	*ptr;
	register int	a,bmclv;

	if( (a = length(p1)) == 1 )
	{
		p1++;
		destflg = TRUE;

		if( adtype() )	return( ADB );
		else		return( 'b' );
	}
	if( a != 4 )	return( FALSE );
	ptr = p1+1;
	bmclv = 0;
	compl = FALSE;

	for( a=0 ; a<3 ; a++ )
	{
		switch( *ptr++ )
		{
		case '0':
			bmclv <<= 2;
			break;
		case 't':
			bmclv = ( bmclv << 2 ) | 01;
			break;
		case '1':
			bmclv = ( bmclv << 2 ) | 03;
			if( a == 1 )	compl = TRUE;
			break;
		case 'f':
			bmclv = ( bmclv << 2 ) | 02;
			if( a == 1 )	compl = TRUE;
			break;
		default:
			return( FALSE );
		}
	}
	p1 += 4;
	destflg = TRUE;

	if( compl )	yylval = ~bmclv;
	else		yylval = bmclv;

	return( BMCL );
}

char	*skipblank(ptr)
register char	*ptr;
/*
 *	skip over the blanks and tabs between keywords.
 */
{
	while( *ptr == ' ' || *ptr == '	' )	ptr++;
	return( ptr );
}

char	*nxtkey(ptr)
register char	*ptr;
/*
 *	skip to the start of the next keyword (ptr is assumed to
 *	point to the start of the old keyword).
 */
{
	register int	a;

	if( *ptr == '$' || *ptr == '\n' )
	{
		*ptr = '\n';
		return( ptr );
	}
	if( a = length(ptr) )	ptr += a;
	else	ptr++;
	return( skipblank(ptr) );
}

search(array,from,to,ptr)
char	*array[],*ptr;
int	from,to;
/*
 *	search for a keyword match.
 */
{
	register int	a;

	for( a=from ; a<=to ; a++ )
	{
		if( test( array[a],ptr ) )	return( a );
	}
	return( -1 );
}

lookup(key1,key2,a,b)
char	*key1[];
int	key2[],a,b;
{
	extern	char	*p1;
	int	x;

	if( (x = search( key1,a,b,p1 )) != -1 )
	{
		p1 = nxtkey(p1);
		return( key2[x] );
	}
	return( FALSE );
}
commatype(ptr)
char	*ptr;
{
	register int	a;

	a = FALSE;
	ptr = nxtkey(ptr);

	switch( *ptr )
	{
	case 'a':
		if( search( keywd2,0,3,ptr ) != -1 )
			a = ~a;
		break;
	case 'b':
		if( search( bdesttb,0,9,ptr ) != -1 )
			a = ~a;
		if( length(ptr) == 1 )
			a = ~a;
		break;
	case 'c':
		if( search( keywd2,4,5,ptr ) != -1 )
			a = ~a;
		break;
	case 'i':
		if( search( lisdest,2,2,ptr ) != -1 )
			a = ~a;
		if( test( "if",ptr ) )
		{
			p1 = nxtkey(ptr);
			return( IF );
		}
		break;
	case 'l':
		if( search( lisdest,0,1,ptr ) != -1 )
			a = ~a;
		break;
	case 'm':
		if( search( mdesttb,0,3,ptr ) != -1 )
			a = ~a;
		break;
	case 's':
		if( search( lisdest,3,3,ptr ) != -1 )
			a = ~a;
		break;
	case 'w':
		if( test( "when",ptr ) )
		{
			p1 = nxtkey(ptr);
			return( WHEN );
		}
	}

	if( a && destflg )	return( DESTSEP );
	destflg = FALSE;
	return( COMPSEP );
}

plustype(ptr)
char	*ptr;
{

	if( plusflg )	return( '+' );
/*			second '+' in x+y+1 */
	plusflg = TRUE;
	ptr = nxtkey( nxtkey( ptr ) );	/* look at keyword after next */
	if( *ptr == '+' )	return( '+' );
/*				first '+' in x+y+1 */
	ptr = nxtkey(ptr);
	if( *ptr == '+' )	return( '+' );
/*				first '+' in x + not y + 1 */

	plusflg = FALSE;
	yylval = 0;
/* ordinary '+', as in x+y (or x + not y) */
	return( ADDOP );
}

minustype(ptr)
char	*ptr;
{

	if( minusflg || lbflag )	return( '-' );
	minusflg = TRUE;
	ptr = nxtkey( nxtkey( ptr ) );	/* skip the y_input */

	if( *ptr == '-' )	return( '-' );
	ptr = nxtkey( ptr );	/* may have been NOT y_input */
	if( *ptr == '-' )	return( '-' );

	yylval = 15;
	minusflg = FALSE;
	return( ADDOP );
}

chk01(ptr)
char	*ptr;
{
	char	*ptmp;

	if( litflg )	return( FALSE );
	if( *ptr != '=' )	return( TRUE );
	ptr = nxtkey( ptr );
	ptmp = nxtkey( ptr );

	if( *ptmp == '$' || *ptmp == '\n' )
	{
		/* test for ptr pointing to sar lit or ampcr */

		switch( *ptr )
		{
		case 'a':
			if( test( "ampcr",ptr ) )	return( FALSE );
			break;
		case 'l':
			if( test( "lit",ptr ) )	return( FALSE );
			break;
		case 's':
			if( test( "sar",ptr ) || test( "slit",ptr ) )
				return( FALSE );
		}

		return( TRUE );
	}
	ptr = ptmp;
	if( *ptr != ',' )	return( TRUE );
	ptr = nxtkey( ptr );

	if( *ptr >= '0' && *ptr <= '9' )
	{
		litflg = TRUE;
		return( FALSE );
	}
	return( TRUE );
}

readnum(ptr)
register char	*ptr;
{
	register int	a;

	a = 0;

	while( *ptr >= '0' && *ptr <= '9' )
	{
		a = 10 * a + (*ptr - '0');
		ptr++;
	}
	return( a );
}

yyaccpt()
{
	struct	labltab	*labpt2;
	register int	a;
	int	val,flagrd;
	extern	char	*fnhptr;

	if( errcnt == 0 )	printf("\nNo errors detected.\n");
	else
	{
		if( errcnt == 1 )	printf("\n1 error detected.\n");
		else	printf("\n%d errors detected.\n",errcnt);
	}
	labptr = labarr;
	if( STATS )	printf("\n\tLabels Defined\n\tLabel\t\tAddress\n");

	for( a=0 ; a<labcnt ; a++ )
	{
		if( STATS )	printf("\t%-8s\t%4d\n",labptr->lblbuf,labptr->lbladdr);
		labpt2 = findlbl( labptr->lblbuf,labptr->lblsize );
		if( labptr->lbladdr != labpt2->lbladdr )
			printf("WARNING label %8s multiply defined\n",labptr->lblbuf);
		labptr++;
	}

	
	if((fdl = freopen(lfnptr, "r", fdl)) == NULL)
	{
		perror(lfnptr);
		dexit(1);
	}
	if( STATS )
	{
		printf("\n\tLabels Used\n\tLabel\t\tUsed At\n");
		while(fread(labtmp.lblbuf, LABSIZE, 1, fdl) == 1)
		{
			fread((char *)(&labtmp.lblsize), 2, 1, fdl);
			fread((char *)(&labtmp.lbladdr), 2, 1, fdl);
			fread((char *)(&labtmp.lblflag), 2, 1, fdl);
			printf("\t%-8s\t%4d\n",labtmp.lblbuf,labtmp.lbladdr);
		}
	}

	if( errcnt != 0 )	dexit(0);
	if((fdh = freopen(hfnptr, "r", fdh)) == NULL)
	{
		perror(hfnptr);
		dexit(1);
	}
	rewind(fdh);
	rewind(fdl);
	if( !HEX1 )	fnhptr = mktemp("/tmp/hexaXXXXXX");
	if((fdh1 = fopen(fnhptr, "w+")) == NULL)
	{
		perror(fnhptr);
		dexit(1);
	}
	a = -1;
	linecnt = 0;
	flagrd = FALSE;

	while(fread(labtmp.lblbuf, LABSIZE, 1, fdl) == 1)
	{
		fread((char *)(&labtmp.lblsize), 2, 1, fdl);
		fread((char *)(&labtmp.lbladdr), 2, 1, fdl);
		fread((char *)(&labtmp.lblflag), 2, 1, fdl);
		temp = labtmp.lbladdr - a;
		if((labptr = findlbl( labtmp.lblbuf,labtmp.lblsize )) != NULL)
		{
			val = labptr->lbladdr;
			if( labtmp.lblflag == 2 )
				val--;
			litptr = litarr;
			sflag = FALSE;
			litptr->flagl = FALSE;
			litptr->litvalu = val;
			litptr->flagc = FALSE;
		}
		else
		{
			printf("Label %s not defined.\n",labtmp.lblbuf);
			continue;
		}
		if( temp == 0 )
		{
			sflag = TRUE;
			if( nano[0] )	litstore( litptr,SAR );
			else
			{
				if( nano[1] )	litstore( litptr,LIT );
				else		litstore( litptr,SLIT );
			}
		}
		else
		{
			if( flagrd )
			{
				printhex( 0,fdh1 );
				linecnt++;
			}

			for( a=1 ; a<temp ; a++ )
			{
				fread((char *)mpm, sizeof mpm , 1, fdh);
				fread((char *)nano, sizeof nano , 1, fdh);

				if( mpm[0] == 017 )	printhex( 1,fdh1 );
				else			printhex( 0,fdh1 );

				linecnt++;
			}
			fread((char *)mpm, sizeof mpm , 1, fdh);
			fread((char *)nano, sizeof nano , 1, fdh);

			if( nano[1] )	temp = LIT;
			else		temp = SLIT;

			sflag = FALSE;

			if((mpm[0] & 010) == 0)
				litstore( litptr,SAR );
			else
			if((mpm[0] & 017) == 014)
				litstore( litptr,AMPCR );
			else
			if((mpm[0] & 014) == 010)
			{
				sflag = TRUE;
				if( nano[0] )	/* then lit first */
				{
					litstore( litptr,temp );
					sflag = FALSE;
				}
				else		/* sar first */
				{
					litstore( litptr,SAR );
				}
			}
			else
			if((mpm[0] & 017) == 016)
				litstore( litptr,temp );
			else
			{
				printf("\n\nSNARK CONSULT TUTOR\n\n");
				dexit(1);
			}
			flagrd = TRUE;
			a = labtmp.lbladdr;
		}
	}
	if( linecnt || flagrd )
	{
		printhex( 0,fdh1 );
		linecnt++;
	}

	while( fread((char *)mpm, sizeof mpm, 1, fdh) == 1)
	{
		fread((char *)nano, sizeof nano , 1, fdh);
		if( mpm[0] == 017 )	printhex( 1,fdh1 );
		else			printhex( 0,fdh1 );
		linecnt++;
	}
	rewind(fdh1);
	if( HEX )
	{
		printf("\n\tHex Listing.\n\n");

		while( (a = readline( fdh1,buf )) > 0 )
		{
			fwrite(buf, 1, a, stdout);
		}
	}
	return;
}

char	*itoa(val,digs)
register int	val,digs;
{
	extern	char	buf1[];
	register char	*ptr;

	ptr = &buf1[10];
	*ptr = '\0';
	*--ptr = (val % 10) + '0';
	digs--;

	while( val = val/10 )
	{
		*--ptr = (val % 10) + '0';
		digs--;
	}

	while( digs > 0 )
	{
		*--ptr = ' ';
		digs--;
	}
	return( ptr );
}

compare(ptr1,ptr2,n)
register char	*ptr1,*ptr2;
int	n;
{
	register int	a;

	if( n > 8 )	n = 8;

	for( a=0 ; a<n ; a++ )
	{
		if( *ptr1++ != *ptr2++ )	return( FALSE );
	}
	return( TRUE );
}

struct labltab *findlbl(ptr,c)
char	*ptr;
int	c;
{
	struct	labltab	*labpt1;
	register int	b;

	labpt1 = labarr;

	for( b=0 ; b<labcnt ; b++ )
	{
		if( c == labpt1->lblsize )
		{
			if( compare( labpt1->lblbuf,ptr,c ) )
				return( labpt1 );
		}
		labpt1++;
	}
	return( NULL );
}

/*
 * now an array containing the information on where to put spaces
 * in binary nanoinstruction output.
 */
	int	gaps[] =
		{
			4,	7,	10,	13,
			16,	19,	27,	31,
			33,	36,	40,	42,
			46,	50,	0
		};
binout()
{
	extern	int	nano[],mpm[];
	int	a,*gptr,b,c;
	char	*bptr,obuf[SMALLBUF];

	if( mpm[0] == 0xF )
	{
		bptr = obuf;
		gptr = gaps;

		for( a=0 ; a<54 ; a++ )
		{
			if( a == *gptr )
			{
				*bptr++ = ' ';
				gptr++;
			}
			*bptr++ = '0';
		}
		printf("      nano= ");
		*bptr = '\0';
		c = nano[13] >> 2;
		b = 2;
		a = 12;

		for( bptr-- ; bptr != obuf ; bptr-- )
		{
			if( *bptr == '0' )
			{
				if( b-- == 0 )
				{
					b = 3;
					c = nano[a--];
				}
				*bptr += c & 01;
				c >>= 1;
			}
		}
		*bptr += c & 01;
		printf("%s\n",obuf);
	}
/* now for mpm conversion */
	printf("      mpm=  ");
	bptr = obuf;

	for( a=0 ; a<16 ; a++ )
		*bptr++ = '0';

	*bptr = '\0';
	a = 2;
	b = 4;
	c = mpm[3];

	for( bptr-- ; bptr != obuf ; bptr-- )
	{
		if( b-- == 0 )
		{
			c = mpm[a--];
			b = 3;
		}
		*bptr += c & 01;
		c >>= 1;
	}

	*bptr += c & 01;
	printf("%s\n\n",obuf);
	return;
}
