#ifndef	TYPES_DEFINED
#include	<types.h>
#endif	TYPES_DEFINED

#define	LINESIZ		16		/* max chars in tty name */
#define	UTNAMESIZE	16		/* max chars for login name field */
#define	UTMPF		"/etc/utmp"

/*
 *	utmp structure for logins
 *
 *	written into	UTMPF
 *		by	"login"
 *			( utmp entry cleared by "init" )
 */
struct	utmp
{
	char		ut_line[LINESIZ];	/* byte 0 = 0 means unallocated */
	uid_t		ut_uid;
	dev_t		ut_ttyid;
	time_t		ut_time;
	short		ut_pgrp;		/* process group leader */
	char		ut_name[UTNAMESIZE];
};
#define	UTMPSIZ	(sizeof (struct utmp))
