	.TITLE	PARSE - Table driven string parser.
	.VERSION 20
	.ENABLE	7BIT
/ ++
/	PARSE Y2.0
/
/	(c) 1989 by Johnny Billquist
/
/	History:
/
/	89/01/04 16:00	BQT	X1.0. Split from STRLIB.
/	9/12/27 05:00	BQT	Y2.0. Made from PRSLIB.
/
/ --
/
	.FSECT	PARSE
/
/ PARSE comparse a string with a table of strings with correspondant numbers.
/ If a match is found, the number is returned. No skip if no match.
/
	0			/For return address.
	CLA
	TAD I	PARSE		/Get arg1.
	ISZ	PARSE
	DCA	P$		/Save as pointer to string.
	TAD I	PARSE		/Get arg2.
	ISZ	PARSE
	DCA	T$		/Save as pointer to table.
	RDF			/Get return field.
	TAD	(CDF CIF)
	DCA	R$

1$:	TAD I	T$		/Get entry in table.
	ISZ	T$
	SNA			/End of table?
	JMP	R$		/Yes. No match found.
	DCA	TS$		/No. Save word as pointer to table string.
	TAD	P$		/Get string pointer.
	DCA	TP$		/Save as tmp pointer.
2$:	TAD I	TP$		/Get string char.
	ISZ	TP$
	SNA			/End of string?
	JMP	E$		/Yes. Possible match.
	JMS	CVTUC$		/No. Convert to uppercase.
	CIA			/Make compare.
	DCA	TMP$		/Save comparator.
	TAD I	TS$		/Get table string char.
	ISZ	TS$
	JMS	CVTUC$		/Convert to uppercase.
	TAD	TMP$		/Compare.
	SNA CLA			/Equals?
	JMP	2$		/Yes. Check next char.
	ISZ	T$		/No. Bump table pointer to next string.
	JMP	1$		/Repeat.

E$:	TAD I	TS$		/Possible match. Get table string char.
	SNA			/End of this string too?
	JMP	M$		/Yes. Match!
	AND	(40)		/Check if LC bit on char.
	TAD	(-40)
	SNA
	JMP	M$		/Was LC. Match!
	ISZ	T$		/No match. Bump table pointer to next string.
	JMP	1$		/Repeat.

M$:	TAD I	T$		/Match. Get correspondant value.
	ISZ	PARSE		/Bump return.
R$:	HLT			/Return field.
	JMP I	PARSE		/Return.

CVTUC$:	0			/Convert to uppercase routine...
	TAD	(-140)		/Separate LC from rest.
	SMA			/Was it LC?
	TAD	(-40)		/Yes. Make into UC.
	TAD	(140)		/Normalize.
	JMP I	CVTUC$		/Return.
/
P$:	0			/Pointer to string.
T$:	0			/Pointer to table.
TS$:	0			/Table string pointer.
TP$:	0			/Tmp string pointer.
TMP$:	0			/Comparator.
/
$
