This is a documentation of the macro facilities available
in COMMON.MA and LNKLIB.RB by Johnny Billquist.

(c) 1989, 1990 by Johnny Billquist
All rights reserved
This documentations is free for copying, as long
as the above copyright is left intact.


Declaration macros:
===================


		C L K D E F

Syntax:

[label,]	CLKDEF	clktyp

Explanation:
Declares macros for clockhandling. The macro takes one argument,
specifying which type of clock the system has, and makes available
the correct macros to handle specified clock.
See also CLKxxx macros.

CLKTYP:

Symbol:	Value:	Frequency:
DK8EA	1	100/120 Hz (Line freq.)
DK8EC	2	Hardware dep.
DK8EP	3	100 Hz
DKC8A	4	100 Hz

Example:

	CLKDEF	DK8EP		/Setup clock type.
	CLKON			/Turn clock on.
1$:	CLKSKP			/Skip if clock bong.
	JMP	1$		/Repeat.
	.			/We got it!


		. F I B

Syntax:

label,		.FIB	[devadr],[devnum],[bufadr]

Explanation:
.FIB sets up a proper FIB for FILEIO, as documented in the FILEIO
documentation.
The label becomes the name for the FIB, and the FIB is referred through
its label. FIB stands for File Id Block, and contains all elements
neccesary for FILEIO to do transparent byte file io.
The FIB consists of the following:

Offset	Symbol	Type
+00	DEVADR	Address of device handler
+01	DEVNUM	Number of device handler
+02	BUFADR	Address of file buffer
+03	BUFFLD	Field of buffer address
+04	FILLIN	Spare
+05	BUFCNT	Count into buffer
+06	FILBLK	Current file block
+07	FILFLG	File flags
+10	FILBEG	Starting block of file
+11	FILSIZ	File size
+12	FILEND	Ending block of file
+13	FILNAM	Filename
+14		:
+15		:
+16	FILEXT	File extension
+17	FILDAT	File date

Offset 00-03 is filled in before any file operation. The rest is filled out
upon open or create. Note that the FILEND is not always equal to
FILBEG+FILSIZ. If a file is created FILSIZ equals zero, but FILEND points
at last free block.

Any parameter may be changed at runtime, even if it is specified by the
.FIB macro.
Any parameter not specified, is set to zero.
BUFFLD is calculated from bufadr, if specified.
A .FIB should be in a data section, it can not be executed!

Example:

	.DSECT	MYFIBS

MYFILE,	.FIB	7607,1,MYBUFF	/Sets up a FIB for the system device handler.



	.EXIT

End program and recall OS/8.

	.END	[start]

End assembly, and set up optional start address.
String manipulation macros:
===========================

General:
Strings are always arrays of words, terminated by a zero, unless otherwise
specified.



		L O C C

Syntax:

[label,]	LOCC	mystring

Explanation:
LOCC locates a character within a string. Returning the position
of the character in the string, or zero, if not found.
Mystring must be in the same field as the call.

Example:

	TAD	(" )		/Search for a space.
	LOCC	MYSTR		/AC should be 4 after this.
	.

MYSTR,	TEXT	/FOO IS A BAR/



		M O V C

Syntax:

[label,]	MOVC	[source],destination,length

Explanation:
MOVC moves a <length> block of words from source to destination.
No checking is done for end of string.
Source and destination is field independant.
If no source is specified, the source pointer is taken from AC,
current field at runtime.

Example:

	MOVC	FBUF,TBUF,20	/Moves 20 chars from FBUF to TBUF

	.DSECT	BUFFERS
	FIELD	1
FBUF,	ZBLOCK	20

	FIELD	0
TBUF,	ZBLOCK	20



		C M P C

Syntax:

[label,]	CMPC	[source1],source2

Explanation:
CMPC compares two string for equal. If the strings are equal, a SKIP
is done.
Both strings must be in the calling field.
If source1 is not specified, it will be taken from AC at runtime.

Example:

	TAD	(STRING		/Get pointer to string.
	CMPC	,CMPSTR		/Compare if equals CMPSTR.
	JMP	NOTEQUAL	/Was not.
	.			/Was.

	.DSECT	STRNG
STRING,	TEXT	"MY"
CMPSTR,	TEXT	"THIS IS MY STRING"


		S K P C

Syntax:

[label,]	SKPC	string

Explanation:
SKPC skips all leading occurances of space,
returning a pointer to the first non-space character.

Example:

	SKPC	MYSTRING
	DCA	STRPTR		/Save pointer to first nonspace.



		. G E T S T R

Syntax:

[label,]	.GETSTR	[source],destination,length[,separator]

Explanation:
.GETSTR is a special macro for parsing input. It returns a substring
from source in destination, terminated by separator/space or a NUL.
The destination is terminated by a NUL, and if longer than length, it
is truncated to length, plus a NUL.
If source is not specified, it is taken from AC at runtime.
On return AC points at the rest of the string.
.GETSTR skips leading spaces.

Example:

	.GETSTR	INLINE,COMMAND,7	/Get command, max 7 chars.
	DCA	NXTCMD			/Save pointer to next command.

	.DSECT	DATA
INLINE,	ZBLOCK	100
COMMAND,ZBLOCK	10			/Should be one more than at .GETSTR
					/to make place for terminating NUL.
Conversion macros:			(.DEFPRS)
==================


		. F P A R S E

Syntax:

[label,]	.FPARSE	[source],destination

Explanation:
.FPARSE is a filename parser. It parses a filename of the type
"DEV:FILENA.EX" into a DEVICE and FILENAME block, as the
pseudoops. DEVICE and FILENAME, but at runtime.
If source is not specified, it is taken from AC at runtime.
Source is a string, and destination is a fixed block of 6 words.

Example:

	TAD	(INSTR		/String with filename.
	.FPARSE	,FDEV		/Parse into FDEV+FNAM

INSTR,	ZBLOCK	20
FDEV,	DEVICE	XXXX
FNAM,	FILENAM	ABCDEF.GH


		. T R N S L T

Syntax:

[label,]	.TRSNLT	table

Explanation:
.TRNSLT traslates the value in AC according to a table.
The table consists of doublewords. The first, is the one to match,
the second is the result. the table starts with a word, telling
how many pairs there are.
If a match is found, a SKIP is executed.

Example:

	TAD	WORD		/We want to translate word.
	.TRNSLT	TABLE
	JMP	NOMATCH		/No match found.
	.			/Match found. AC translated.

	.DSECT	TABLES
TABLE,	4
	1;-1
	2;-2
	3;-3
	4;-4



		. P A R S E

Syntax:

[label,]	.PARSE	[source],table

Explanation:
.PARSE looks through a table of strings for a match, and if one is
found, a SKIP is executed, and AC equals the translation.
The table consists of doublewords, the first pointing to a string, and
the second to the translation if it is a match.
The table is terminated by a zero for string pointer.
The strings are UPPERCASE for the required parts, and lowercase for the 
optional parts.
If no source is specified, it is taken from AC at runtime.

Example:

	.PARSE	STRING,TABLE	/Parse string....
	JMP	HUH		/No comprende.
	.			/I got you... AC translated.

	.DSECT	DATA
STRING,	ZBLOCK	10

TABLE,	STR1;1
	STR2;2
	0

STR1,	TEXT	/FOObar/	/Ony FOO neccessary.
STR2,	TEXT	/BARf/		/Only BAR neccessary.



		. F I X F I L

Syntax:

[label,]	.FIXFIL	[address]
		[address]

Explanation:
FIXFIL is used to remove the * wildcard, and replaces this with
? on the location in the file, and on all following locations
in the field of the filename. Address is either given on same
line, or if no argument is given, the address can be given
on next line.


		. C O P Y F

Syntax:

[label,]	.COPYF	[match],source,destination

Explanation:
COPYF is used to copy a filename according to a wildcard match.
The filename at address match is copied to destination.
However, when the sixbit char at match is a ? (77), the corresponding
character will be taken from the filename at source instead.
Conversion macros:
==================
		.CVTxy

Syntax:

[label,]	.CVTxy	string

Explanation:
.CVT routines sonvert ascii numbers to binary and vice versa.
The possible variants are:
	.CVTBD		/Binary to decimal
	.CVTBO		/Binary to octal
	.CVTDB		/Decimal to binary
	.CVTOB		/Octal to binary

The result is either from, or to AC.
The string is terminated by any non-numerical, and must reside in the
same field as the caller.

Example:

	.CVTDB	STRING	/This example converts a string from decimal
	.CVTBO	STRING	/to octal.

	.DSECT	DATA
STRING,	ZBLOCK	6
Clock macros:
=============


Macro:	Does:
CLKON	Turns clock on. Clears AC.
CLKOF	Turns clock off. Clears AC.
CLKSKP	Skip if clock has fired.
CLKCLR	Clear clock fire. Clear AC.

See CLKDEF for more info.
General IO macros:
==================



		. P R I N T

Syntax:

[label,]	.PRINT	[string]

Explanation:
.PRINT prints the string through the PUT routine, it is possible
to write your own PUT routine to print.
The string is terminated by a NUL, and is field independant.
If no string address is given, AC is assumed to hold the pointer,
and the current field is assumed.

Example:

	.PRINT	MYSTR

	.DESCT	TXT
MYSTR,	TEXT	/Hello world!/



		. P S I X

Explanation:
This routine is the same as .PRINT, except that is handles
sixbit strings. It has @ as a prefix char for controlchars.

Example:

	.PSIX	MYSTR

	.DSECT	TXT
	.ENABLE	SIXBIT
MYSTR,	TEXT	"HELLO WORLD!@M@J@"	/Note that it must terminate with a
					/@ to be certain that two @, making
					/a NUL is present.


		. P F N A M

Syntax:

[label,]	.PFNAM	[address]

Explanation:
.FPNAM prints a sixbit filename with the PUT routine.
A period is included in the output, and all spaces and
@ are skipped.



		. I N P U T

Syntax:

[label,]	.INPUT	string,length

Explanation:
.INPUT calls GET, which can be your own, or STDIO.
.INPUT reads a line of chars, with line editing, terminated by a CR, ^C,
^Z, or ESC.
.INPUT handles ^U and RUBOUT.
The input buffer is terminated by a NUL.
If length is reached, no more chars can be entered.
The NUL is appended after the string, even if it is of length.
On return, MQ contains then number of chars read, and AC contains
the terminating character.

Example:

	.INPUT	INBUF,77

INBUF,	ZBLOCK	100		/Must be one more than in the call.
FILEIO macro calls:
===================

General: All error arguments are addresses of error handling routines.
	If no address is specified, a HLT will be executed if error.


		. L O O K U P

Syntax:

[label,]	.LOOKUP	fib,name,err

Explanation:

.LOOKUP fills out the FIB with information of the file requested,
without setting the "file open" bit in FILFLG.
On entry, AC contains an index, specifying which file, in
order of appearance to return info on.
If AC is zero, the first file is returned.
Name is a pointer to a FILENAME text, which may contain wildcards.
(* and ?).
If it is successful, AC will be zero. If an error occurs,
if AC is negative, it is fatal, but if AC is positive, it
indicates how many files NOT found according to filespec.
If it is zero, a non-fatal device error occured.

Example:

	TAD	(2	/Lookup second file to match...
	.LOOKUP	FIB,FNAM,ERR
	.		/File found...

ERR,	SMA SZA
	JMP	NOTFUN	/File not found.
	.		/Fatal error.

	.DSECT	DATA
FNAM,	FILENAME	*.PA
FIB,	.FIB		7607,1,MYBUFF	/Setup for SYS:
MYBUFF,	ZBLOCK		400


		. I O P E N

Syntax:

[label,]	.IOPEN	fib,name,err

Explanation:

This routine works exactly as the USR LOOKUP function,
except that it takes its argument from the FIB, and filles
the FIB with some info as well. The FILDAT is not supplied
with this function.
Except for the AC, which is meaningless, the syntax is as
for .LOOKUP.


		. O O P E N

Syntax:

[label,]	.OOPEN	fib,name,err

Explanation:

This is the same routine as the USR ENTER function, except
that it uses the FIB for file information.
AC, if non-zero specifies the max size of the file, as for
ENTER.
See .LOOKUP for example.


		. P U T

Syntax:

[label,]	.PUT	fib,err

Explanation:

.PUT writes the filebuffer to the block specified in the AC,
or if AC is zero, to the next sequential block.
On return, AC contains the block # on which the data was written.

Example:

	TAD	(1	/Write block #1. (The first block in the file)
	.PUT	FIB,ERR
	CLA		/AC is one, we already know that!

	.DSECT	DATA
FIB,	ZBLOCK	20


		. G E T

Syntax:

[label,]	.GET	fib,err

Explanation:

.GET is the opposite to .PUT, and works in the same manner, concerning
the AC argument.

Example:

			/This is a short copy program.
1$:	CLA		/Get next block.
	.GET	IFIB,EOF	/Read block.
				/AC is now block # read.
	.PUT	OFIB		/Write block at same place in output.
	JMP	1$		/Repeat.

EOF,	.			/EOF detected, I assume.

	.DSECT	DATA
IFIB,	.FIB	,,BUFF		/Note, both fibs use same data area.
OFIB,	.FIB	,,BUFF


		. O C H A R

Syntax:

[label,]	.OCHAR	fib,err

Explanation:

.OCHAR output the eightbit character in AC on file.
AC is preserved after the call.

Example:

	TAD	(232	/Output ^Z.
	.OCHAR	FIB,ERR	/Do it!
	.		/Done. AC is still 232.


		. I C H A R

Syntax:

[label,]	.ICHAR	fib,err

Explanation:

.ICHAR reads the next eightbit character from file into AC.
This is the opposite to .OCHAR



		. F P R I N T

Syntax:

[label,]	.FPRINT	fib,txt,err

Explanation:

.FPRINT prints a string on a file. See PSIX for example
and string format.
Txt must be in calling field.



		. P O S I T
		. P O S I T P

These functions is not guaranteed to work, or remain as they
are now, and is therefore not documented.


		. C L O S E

Syntax:

[label,]	.CLOSE	fib,err

Explanation:

.CLOSE closes the file. If it was opened with .OOPEN, it will be
made permanent.
Also, if the file buffer is modified, it will be written onto disk.

Example:

	TAD	(232	/^Z
	.OCHAR	FIB,OUTERR	/Put EOF.
	.CLOSE	FIB,CLOERR	/Close file.

OUTERR,	.			/Output error...
CLOERR,	.			/Close error...

	.DSECT	DATA
FIB,	ZBLOCK	20
USR macros:
===========


CALUSR	function

Makes a call the the USR, with the function argument specified
by the function parameter.


		. F E T C H

Syntax:

[label,]	.FETCH	devptr,devadr,err

Explanation:

.FETCH calls the USR fetch function. Devptr points to
the device name, and devadr points to the device address
argument. This makes .FETCH reexecutable.
On return, AC points to arg1. See OS/8 software support manual.

Example:

	.FETCH	DEVNAM,DEVADR,FERR
	DCA	10
	TAD I	10	/AC gets device number.
	DCA	FIB+DEVNUM
	TAD I	10	/AC gets entry point.
	DCA	FIB+DEVADR
	.		/Now we have a better FIB...

FERR,	.		/Fetch error.


	.DSECT	DATA
FIB,	.FIB	,,BUFFER
BUFFER,	ZBLOCK	400

DEVNAM,	DEVICE	DSK	/Device is DSK:
DEVADR,	6000!1		/Handler shall load into 6000, and can be 2 pages.



.USRERR	errno
Makes a call to USR for the USER ERROR XXXX where XXXX is errno.

.USRIN
Swaps in USR permanently.

.USROUT
Swaps out USR, after .USRIN

.RESET	[tentative]
Calls USR RESET. If tentative is given any value, a zero is added
to keep tentative files.
