/*
 * rtdir.cpp
 *
 * Utility to print the directory of files from an RT-11 diskette 
 * with optional filename selection, to cout.
 *
 * John Dudeck   SIM International   25-Aug-92
 */
#include <iostream.h>
#include <stdlib.h>
#include "rtdisk.h"
#include "rtfile.h"

main(int argc, char *argv[]) {
   RTdisk src;
   
   if (argc > 2
      || argc == 2 && argv[1][0] == '/') {
      cout << "Usage: RTDIR [filespec]\n"
           << "   'filespec' must be on an RT-11 diskette\n"
           << "   MS-DOS style wildcards may be specified using '*' and '?'\n";
      exit(1);
   }
   if (argc == 2) src.setsrc(argv[1]);
   src.print_directory();
}
