/*
 *	pdp8/e emulator
 *
 *	Author:
 *		Bill Haygood
 *		41832 Ernest Road
 *		Loon Lake, WA 99148-9607
 *		Internet: billh@comtch.iea.com
 *		Voice/AnsMach/FAX \
 *			or	   509-233-2555
 *		  Cellular/Pager  /
 *
 *	Copyright 1992, 1993 by the author with all rights reserved.
 *
 *	Memory Reference Instruction (MRI) module.
 */
#include "pdp8regs.h"

/* -------------------------------------------------------------------- */
VOID i0000 (VOID)
{
    AC &= *(base + (IF + INST)) | 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i0200 (VOID)
{
    AC &= *(base + (IF + (PC & 07600) + (INST & 0177))) | 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i0400 (VOID)
{
    AC &= *(base + (DF + *(base + (IF + (INST & 0177))))) | 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i0410 (VOID)
{
    REG UWORD *p = base + (IF + (INST & 0177)) ;
    AC &= *(base + (DF + (*p = ++*p & 07777))) | 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i0600 (VOID)
{
    AC &= *(base + (DF + *(base + (IF + (PC & 07600)
					+ (INST & 0177))))) | 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i0610 (VOID)
{
    REG UINT page = PC & 07600 ;
    REG UWORD *p = base + (IF + page + (INST & 0177)) ;
    if (!page && (++*p & 010000))
	*p &= 07777 ;
    AC &= *(base + (DF + *p)) | 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i1000 (VOID)
{
    AC = (AC + *(base + (IF + (INST & 0177)))) & 017777 ;
}
/* -------------------------------------------------------------------- */
VOID i1200 (VOID)
{
    AC = (AC + *(base + (IF + (PC & 07600) + (INST & 0177)))) & 017777 ;
}
/* -------------------------------------------------------------------- */
VOID i1400 (VOID)
{
    AC = (AC + *(base + (DF + *(base + (IF + (INST & 0177)))))) & 017777 ;
}
/* -------------------------------------------------------------------- */
VOID i1410 (VOID)
{
    REG UWORD *p = base + (IF + (INST & 0177)) ;
    AC = (AC + *(base + (DF + (*p = ++*p & 07777)))) & 017777 ;
}
/* -------------------------------------------------------------------- */
VOID i1600 (VOID)
{
    AC = (AC + *(base + (DF + *(base + (IF + (PC & 07600)
					+ (INST & 0177)))))) & 017777 ;
}
/* -------------------------------------------------------------------- */
VOID i1610 (VOID)
{
    REG UINT page = PC & 07600 ;
    REG UWORD *p = base + (IF + page + (INST & 0177)) ;
    if (!page && (++*p & 010000))
	*p &= 07777 ;
    AC = (AC + *(base + (DF + *p))) & 017777 ;
}
/* -------------------------------------------------------------------- */
VOID i2000 (VOID)
{
    REG UWORD *p = base + (IF + (INST & 0177)) ;
    if (!(*p = ++*p & 07777))
	++PC ;
}
/* -------------------------------------------------------------------- */
VOID i2200 (VOID)
{
    REG UWORD *p = base + (IF + (PC & 07600) + (INST & 0177)) ;
    if (!(*p = ++*p & 07777))
	++PC ;
}
/* -------------------------------------------------------------------- */
VOID i2400 (VOID)
{
    REG UWORD *p = base + (DF + *(base + (IF + (INST & 0177)))) ;
    if (!(*p = ++*p & 07777))
	++PC ;
}
/* -------------------------------------------------------------------- */
VOID i2410 (VOID)
{
    REG UWORD *p = base + (IF + (INST & 0177)) ;
    *p = ++*p & 07777 ;
    p = base + (DF + *p) ;
    if (!(*p = ++*p & 07777))
	++PC ;
}
/* -------------------------------------------------------------------- */
VOID i2600 (VOID)
{
    REG UWORD *p = base
		+ (DF + *(base + (IF + (PC & 07600) + (INST & 0177)))) ;
    if (!(*p = ++*p & 07777))
	++PC ;
}
/* -------------------------------------------------------------------- */
VOID i2610 (VOID)
{
    REG UINT page = PC & 07600 ;
    REG UWORD *p = base + (IF + page + (INST & 0177)) ;
    if (!page)
	*p = ++*p & 07777 ;
    p = base + (DF + *p) ;
    if (!(*p = ++*p & 07777))
	++PC ;
}
/* -------------------------------------------------------------------- */
VOID i3000 (VOID)
{
    *(base + (IF + (INST & 0177))) = AC & 07777 ;
    AC &= 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i3200 (VOID)
{
    *(base + (IF + (PC & 07600) + (INST & 0177))) = AC & 07777 ;
    AC &= 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i3400 (VOID)
{
    *(base + (DF + *(base + (IF + (INST & 0177))))) = AC & 07777 ;
    AC &= 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i3410 (VOID)
{
    REG UWORD *p = base + (IF + (INST & 0177)) ;
    *p = ++*p & 07777 ;
    *(base + (DF + *p)) = AC & 07777 ;
    AC &= 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i3600 (VOID)
{
    *(base + (DF + *(base + (IF + (PC & 07600) + (INST & 0177)))))
							= AC & 07777 ;
    AC &= 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i3610 (VOID)
{
    REG UINT page = PC & 07600 ;
    REG UWORD *p = base + (IF + page + (INST & 0177)) ;
    if (!page)
	*p = ++*p & 07777 ;
    *(base + (DF + *p)) = AC & 07777 ;
    AC &= 010000 ;
}
/* -------------------------------------------------------------------- */
VOID i4000 (VOID)
{
    REG UINT temp = INST & 0177 ;
    *(base + (IB + temp)) = ++PC & 07777 ;
    PC = temp ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
VOID i4200 (VOID)
{
    REG UINT temp = (PC & 07600) + (INST & 0177) ;
    *(base + (IB + temp)) = ++PC & 07777 ;
    PC = temp ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
VOID i4400 (VOID)
{
    REG UINT temp = *(base + (IF + (INST & 0177))) ;
    *(base + (IB + temp )) = ++PC & 07777 ;
    PC = temp ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
VOID i4410 (VOID)
{
    REG UWORD *p = base + (IF + (INST & 0177)) ;
    *(base + (IB + (*p = ++*p & 07777))) = ++PC & 07777 ;
    PC = *p ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
VOID i4600 (VOID)
{
    REG UINT temp = *(base + (IF + (PC & 07600) + (INST & 0177))) ;
    *(base + (IB + temp)) = ++PC & 07777 ;
    PC = temp ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
VOID i4610 (VOID)
{
    REG UINT page = PC & 07600 ;
    REG UWORD *p = base + (IF + page + (INST & 0177)) ;
    if (!page)
	*p = ++*p & 07777 ;
    *(base + (IB + *p)) = ++PC & 07777 ;
    PC = *p ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
VOID i5000 (VOID)
{
    PC = (INST & 0177) - 1 ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
VOID i5200 (VOID)
{
    PC = ((PC & 07600) + (INST & 0177)) - 1 ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
VOID i5400 (VOID)
{
    PC = *(base + (IF + (INST & 0177))) - 1 ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
VOID i5410 (VOID)
{
    REG UWORD *p = base + (IF + (INST & 0177)) ;
    PC = *p ;
    *p = ++*p & 07777 ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
VOID i5600 (VOID)
{
    PC = *(base + (IF + (PC & 07600) + (INST & 0177))) - 1 ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
VOID i5610 (VOID)
{
    REG UINT page = PC & 07600 ;
    REG UWORD *p = base + (IF + page + (INST & 0177)) ;
    if (!page)
	*p = ++*p & 07777 ;
    PC = *p - 1 ;
    IF = IB ;
    if (int_ena)
	UF = UB ;
    int_inh = FALSE ;
}
/* -------------------------------------------------------------------- */
