/*
 *	pdp8/e emulator
 *
 *	Author:
 *		Bill Haygood
 *		41832 Ernest Road
 *		Loon Lake, WA 99148-9607
 *		Internet: billh@comtch.iea.com
 *		Voice/AnsMach/FAX \
 *			or	   509-233-2555
 *		  Cellular/Pager  /
 *
 *	Copyright 1992, 1993 by the author with all rights reserved.
 *
 *	Input / Output Transfer (IOT) module.
 */
#include "pdp8regs.h"

#define	LP8ERROR 0	/* Currently don't support LP8 error flag */

extern	INT	GetChar (INT, INT) ;
extern	VOID	PutChar (INT, UBYTE) ;
extern	VOID	rk8writ (INT unit) ;
extern	VOID	rk8read (INT unit) ;
extern	INT	rk8io (INT unit, INT block, UBYTE half,
					UBYTE rwflag, UINT memadr) ;

/*
 *	IOT Instructions
 */
VOID iuser (VOID)
{
    io_flags |= userFLAG ;
}
VOID i6000 (VOID)				/* SKON		6000	*/
{
    if (int_ena)
	++PC ;
    int_ena = delay = FALSE ;
}
VOID i6001 (VOID)				/* ION		6001	*/
{
    int_ena = delay = TRUE ;
    if (SF & BIT5)
	int_mask |= userFLAG ;
}
VOID i6002 (VOID)				/* IOF		6002	*/
{
    int_ena = delay = FALSE ;
}
VOID i6003 (VOID)				/* SRQ		6003	*/
{
    if (io_flags & int_mask)
	++PC ;
}
VOID i6004 (VOID)				/* GTF		6004	*/
{
    AC = (AC & 010000) | ((AC & 010000) >> 1)	/* Save the LINK	*/
	| ((EAE == 'B' && GTF) ? BIT1 : 0)	/* Save the GTF		*/
	| ((io_flags & int_mask) ? BIT2 : 0)	/* Save Interrupt Req	*/
	| (int_inh << 8)			/* Save Interrupt Inh	*/
	| (int_ena << 7)			/* Save Interrupt Ena	*/
	| SF ;					/* Save UF, IF, DF	*/
}
VOID i6005 (VOID)				/* RTF		6005	*/
{
    AC = (AC & 07777) | ((AC & BIT0) << 1) ;	/* Restore LINK	*/
    if (EAE == 'B')
	GTF = (AC & BIT1) >> 10 ;		/* Restore GTF	*/
    SF = AC & 0177 ;				/* Restore SF	*/
    if (UB = (AC & BIT5) << 6)			/* Restore UB	*/
	int_mask |= userFLAG ;
    IB = (AC & 070) << 9 ;			/* Restore IB	*/
    DF = (AC & 07) << 12 ;			/* Restore DF	*/
    int_ena = delay = int_inh = TRUE ;
}
VOID i6006 (VOID)				/* SGT		6006	*/
{
    if (EAE == 'B' && GTF)
	++PC ;
}
VOID i6007 (VOID)				/* CAF		6007	*/
{
    AC = 0 ;		/* Clear pdp8 registers	*/
    int_ena = int_inh = delay = UF = FALSE ;
    io_flags = FALSE ;	/* no flags, but serial IE's = 1! */
    int_mask = coninFLAG | conoutFLAG | auxinFLAG | auxoutFLAG ;
    if (UB)
	int_mask |= userFLAG ;
    if (EAE)
    {
	EAE = 'A' ;		/* Set EAE mode A	*/
	GTF = FALSE ;
	SC = 0 ;
    }
    if (FPP)
    {
	io_flags &= ~fppFLAG ;	/* Clear FPP Int flag	*/
	fpp_mode = LEAV ;	/* Interleaved mode	*/
	fpp_run = FALSE ;	/* Stop the FPP		*/
	fpp_pause = FALSE ;	/* ditto		*/
	fpp_data = FP ;		/* Enable FP mode	*/
	fpp_stat = 0 ;		/* Clear FPP status	*/
    }
    coninchar = 0 ;
    auxinchar = 0 ;
    rk8command = 0 ;		/* Clear RK8-E regs	*/
    rk8curaddr = 0 ;
    rk8block   = 0 ;
    rk8status  = 0 ;
    rk8unit = 0 ;
    rk8lock = FALSE ;
}

/*
 *	PT8-E (Paper tape reader/punch)
 */
VOID i6010 (VOID)				/* RPE		6010	*/
{
    int_mask |= pt8rdrFLAG | pt8punFLAG ;
}
VOID i6011 (VOID)				/* RSF		6011	*/
{
    if (io_flags & pt8rdrFLAG)
	++PC ;
}
VOID i6012 (VOID)				/* RRB		6012	*/
{
    if (pt8reader == NULL)
	pt8rdrbuffer = 0377 ;
    AC |= pt8rdrbuffer ;
    io_flags &= ~pt8rdrFLAG ;
}
VOID i6014 (VOID)				/* RFC		6014	*/
{
    io_flags &= ~pt8rdrFLAG ;
    if (!pt8reader)
    {
	*chrsout = '\0' ;
	printf ("Enter PTReader file name: ") ;
	scanf ("%s", chrsout) ;
	if (*chrsout)
	{
	    if (!(pt8reader = fopen (chrsout, "r")))
		printf ("Specified PTReader file not found.\n") ;
	}
    }
    if (pt8reader)
    {
	if (fread (&pt8rdrbuffer, 1, 1, pt8reader) == 1)
	    io_flags |= pt8rdrFLAG ;
	else
	{
	    fclose (pt8reader) ;
	    pt8reader = NULL ;
	}
    }
}
VOID i6016 (VOID)				/* RRB RFC	6016	*/
{
    if (!pt8reader)
    {
	*chrsout = '\0' ;
	printf ("Enter PTReader file name: ") ;
	scanf ("%s", chrsout) ;
	if (*chrsout)
	{
	    if (!(pt8reader = fopen (chrsout, "r")))
		printf ("Specified PTReader file not found.\n") ;
	}
    }
    if (pt8reader)
    {
	io_flags &= ~pt8rdrFLAG ;
	AC |= pt8rdrbuffer ;
	if (fread (&pt8rdrbuffer, 1, 1, pt8reader) == 1)
	    io_flags |= pt8rdrFLAG ;
	else
	{
	    fclose (pt8reader) ;
	    pt8reader = NULL ;
	}
    }
}
VOID i6017 (VOID)				/*		6017	*/
{
    if (pt8reader)
    {
	fclose (pt8reader) ;
	pt8reader = NULL ;
    }
}
VOID i6020 (VOID)				/* PCE		6020	*/
{
    int_mask &= ~(pt8rdrFLAG | pt8punFLAG) ;
}
VOID i6021 (VOID)				/* PSF		6021	*/
{
    if (io_flags & pt8punFLAG)
	++PC ;
}
VOID i6022 (VOID)				/* PCF		6022	*/
{
    io_flags &= ~pt8punFLAG ;
}
VOID i6024 (VOID)				/* PPC		6024	*/
{
    if (!pt8punch)
    {
	*chrsout = '\0' ;
	printf ("Enter PTPunch file name: ") ;
	scanf ("%s", chrsout) ;
	if (*chrsout)
	{
	    if (!(pt8punch = fopen (chrsout, "w")))
		printf ("Could not open specified PTPunch file.\n") ;
	}
    }
    if (pt8punch)
    {
	pt8punbuffer = AC & 0377 ;
	fwrite (&pt8punbuffer, 1, 1, pt8punch) ;
    }
}
						/*		6025	*/
VOID i6026 (VOID)				/* PLS		6026	*/
{
    if (!pt8punch)
    {
	*chrsout = '\0' ;
	printf ("Enter PTPunch file name: ") ;
	scanf ("%s", chrsout) ;
	if (*chrsout)
	{
	    if (!(pt8punch = fopen (chrsout, "w")))
		printf ("Could not open specified PTPunch file.\n") ;
	}
    }
    if (pt8punch)
    {
	pt8punbuffer = AC & 0377 ;
	fwrite (&pt8punbuffer, 1, 1, pt8punch) ;
	io_flags |= pt8punFLAG ;
    }
}
VOID i6027 (VOID)				/*		6027	*/
{
    if (pt8punch)
    {
	fclose (pt8punch) ;
	pt8punch = NULL ;
    }
}
/*
 *	Console keyboard.
 */
VOID i6030 (VOID)				/* KCF		6030	*/
{
    io_flags &= ~coninFLAG ;
}
VOID i6031 (VOID)				/* KSF		6031	*/
{
    if (io_flags & coninFLAG)
	++PC ;
}
VOID i6032 (VOID)				/* KCC		6032	*/
{
    GetChar (003, TRUE) ;
    io_flags &= ~coninFLAG ;
    AC &= 010000 ;
}
VOID i6034 (VOID)				/* KRS		6034	*/
{
    AC |= GetChar (003, FALSE) ;
}
VOID i6035 (VOID)				/* KIE		6035	*/
{
    if (AC & 1)
	int_mask |= coninFLAG | conoutFLAG ;
    else
	int_mask &= ~(coninFLAG | conoutFLAG) ;
}
VOID i6036 (VOID)				/* KRB		6036	*/
{
    io_flags &= ~coninFLAG ;
    AC = (AC & 010000) | GetChar (003, TRUE) ;
}
/*
 *	Console display.
 */
VOID i6040 (VOID)				/* TFL		6040	*/
{
    io_flags |= conoutFLAG ;
}
VOID i6041 (VOID)				/* TSF		6041	*/
{
    if (io_flags & conoutFLAG)
	++PC ;
}
VOID i6042 (VOID)				/* TCF		6042	*/
{
    io_flags &= ~conoutFLAG ;
}
VOID i6044 (VOID)				/* TPC		6044	*/
{
    PutChar (004, (UBYTE) AC) ;
}
VOID i6045 (VOID)				/* TSK		6045	*/
{
    if (io_flags & int_mask & (coninFLAG | conoutFLAG))
	++PC ;
}
VOID i6046 (VOID)				/* TLS		6046	*/
{
    PutChar (004, (UBYTE) AC) ;
    io_flags |= conoutFLAG ;
}

/*
 *	100/120 Hz clock IOTs (DK8-EA, DK8E-C, PDP8-A, VT78, VT278).
 */
VOID i6131 (VOID)				/* CLEI		6131	*/
{
    int_mask |= clockFLAG ;
}
VOID i6132 (VOID)				/* CLDI		6132	*/
{
    int_mask &= ~clockFLAG ;
}
VOID i6133 (VOID)				/* CLSK		6133	*/
{
    if (io_flags & clockFLAG)
    {
	io_flags &= ~clockFLAG ;
	++PC ;
    }
}
/*
 *	PDP8/a clock IOTs
 */
VOID i6135 (VOID)				/* CLIE		6135	*/
{
    if (AC & 1)
	int_mask |= clockFLAG ;
    else
	int_mask &= ~clockFLAG ;
}
VOID i6136 (VOID)				/* CLCF		6136	*/
{
    io_flags &= ~clockFLAG ;
}
VOID i6137 (VOID)				/* CLSK		6137	*/
{
    if (io_flags & clockFLAG)
	++PC ;
}

/*
 *	Field change IOTs.
 */
VOID i6201 (VOID)				/* CDF 0	6201	*/
{
    DF = 0 ;
}
VOID i6202 (VOID)				/* CIF 0	6202	*/
{
    IB = 0 ;
    int_inh = TRUE ;
}
VOID i6203 (VOID)				/* CIF CDF 0	6203	*/
{
    IB = DF = 0 ;
    int_inh = TRUE ;
}
/*
 *	Clear User Interrupt.
 */
VOID i6204 (VOID)				/* CINT		6204	*/
{
    io_flags &= ~userFLAG ;
}
VOID i6211 (VOID)				/* CDF 1	6211	*/
{
    DF = 1 << 12 ;
}
VOID i6212 (VOID)				/* CIF 1	6212	*/
{
    IB = 1 << 12 ;
    int_inh = TRUE ;
}
VOID i6213 (VOID)				/* CIF CDF 1	6213	*/
{
    IB = DF = 1 << 12 ;
    int_inh = TRUE ;
}
VOID i6214 (VOID)				/* RDF		6214	*/
{
    AC |= DF >> 9 ;
}
VOID i6221 (VOID)				/* CDF 2	6221	*/
{
    DF = 2 << 12 ;
}
VOID i6222 (VOID)				/* CIF 2	6222	*/
{
    IB = 2 << 12 ;
    int_inh = TRUE ;
}
VOID i6223 (VOID)				/* CIF CDF 2	6223	*/
{
    IB = DF = 2 << 12 ;
    int_inh = TRUE ;
}
VOID i6224 (VOID)				/* RIF		6224	*/
{
    AC |= IF >> 9 ;
}
VOID i6231 (VOID)				/* CDF 3	6231	*/
{
    DF = 3 << 12 ;
}
VOID i6232 (VOID)				/* CIF 3	6232	*/
{
    IB = 3 << 12 ;
    int_inh = TRUE ;
}
VOID i6233 (VOID)				/* CIF CDF 3	6233	*/
{
    IB = DF = 3 << 12 ;
    int_inh = TRUE ;
}
VOID i6234 (VOID)				/* RIB		6234	*/
{
    AC |= SF ;
}
VOID i6241 (VOID)				/* CDF 4	6241	*/
{
    DF = 4 << 12 ;
}
VOID i6242 (VOID)				/* CIF 4	6242	*/
{
    IB = 4 << 12 ;
    int_inh = TRUE ;
}
VOID i6243 (VOID)				/* CIF CDF 4	6243	*/
{
    IB = DF = 4 << 12 ;
    int_inh = TRUE ;
}
VOID i6244 (VOID)				/* RMF		6244	*/
{
    if (UB = (SF & BIT5) << 6)
	int_mask |= userFLAG ;
    IB = (SF & 070) << 9 ;
    DF = (SF & 07) << 12 ;
}
VOID i6251 (VOID)				/* CDF 5	6251	*/
{
    DF = 5 << 12 ;
}
VOID i6252 (VOID)				/* CIF 5	6252	*/
{
    IB = 5 << 12 ;
    int_inh = TRUE ;
}
VOID i6253 (VOID)				/* CIF CDF 5	6253	*/
{
    IB = DF = 5 << 12 ;
    int_inh = TRUE ;
}
/*
 *	Skip on User Interrupt.
 */
VOID i6254 (VOID)				/* SINT		6254	*/
{
    if (io_flags & userFLAG)
	++PC ;
}
VOID i6261 (VOID)				/* CDF 6	6261	*/
{
    DF = 6 << 12 ;
}
VOID i6262 (VOID)				/* CIF 6	6262	*/
{
    IB = 6 << 12 ;
    int_inh = TRUE ;
}
VOID i6263 (VOID)				/* CIF CDF 6	6263	*/
{
    IB = DF = 6 << 12 ;
    int_inh = TRUE ;
}
/*
 *	Clear the User Flag.
 */
VOID i6264 (VOID)				/* CUF		6264	*/
{
    UB = 0 ;
    int_mask &= ~userFLAG ;
}
VOID i6271 (VOID)				/* CDF 7	6271	*/
{
    DF = 7 << 12 ;
}
VOID i6272 (VOID)				/* CIF 7	6272	*/
{
    IB = 7 << 12 ;
    int_inh = TRUE ;
}
VOID i6273 (VOID)				/* CIF CDF 7	6273	*/
{
    IB = DF = 7 << 12 ;
    int_inh = TRUE ;
}
/*
 *	Set the User Flag.
 */
VOID i6274 (VOID)				/* SUF		6274	*/
{
    UB = 1 << 12 ;
    int_mask |= userFLAG ;
    int_inh = TRUE ;
}
/*
 *	FPP-8/A Floating Point Processor
 */
VOID i6551 (VOID)				/* FPINT	6551	*/
{
    if (FPP && io_flags & fppFLAG)
	++PC ;
}
VOID i6552 (VOID)				/* FPICL	6552	*/
{
    if (FPP)
    {
	io_flags &= ~fppFLAG ;		/* Clear FPP Int flag	*/
	fpp_mode = LEAV ;		/* Interleaved mode	*/
	fpp_run = FALSE ;		/* Stop the FPP		*/
	fpp_pause = FALSE ;		/* ditto		*/
	fpp_data = FP ;			/* Enable FP mode	*/
	fpp_stat = 0 ;			/* Clear FPP status	*/
    }
}
VOID i6553 (VOID)				/* FPCOM	6553	*/
{
    if (FPP && fpp_run == FALSE && !(io_flags & fppFLAG))
    {
	fpp_command = (AC & 07777) | 0100000 ;  /* Insure non-zero	*/
						/* See FPEP below	*/
	fpp_stat &= ~(BIT0 | BIT8 | BIT9) ;	/* Set FPP mode FP	*/
	if (fpp_command & BIT0)
	{
	    fpp_stat |= BIT0 ;			/* Set DP in status	*/
	    fpp_data = DP ;			/* Set DP mode		*/
	}
	int_mask &= ~fppFLAG ;			/* Clear interrupts	*/
	if (fpp_command & BIT3)			/* Enable interrupts ?	*/
	    int_mask |= fppFLAG ;		/* Yes			*/
	fpp_mode = LEAV ;			/* Set interleave mode	*/
	if (fpp_command & BIT8)			/* Lockout mode ?	*/
	{
	    fpp_mode = LOCK ;			/* Yes			*/
	    fpp_stat |= BIT8 ;
	}
    }
}
VOID i6554 (VOID)				/* FPHLT	6554	*/
{
    if (FPP && fpp_run)
    {
	fpp_pause = TRUE ;
	fpp_stat |= BIT2 ;
	if (fpp_stat & BIT10)			/* If FPP paused,	*/
	    fpp_pc = --fpp_pc & 077777 ;	/*	decrement FPC	*/
    }
}
VOID i6555 (VOID)				/* FPST		6555	*/
{
    if (FPP && fpp_run == FALSE && !(io_flags & fppFLAG))
    {
	fpp_aptp = ((fpp_command & 07) << 12) | (AC & 07777) ;
	fpp_pc = ((*(base + fpp_aptp) & 07) << 12)
					+ (*(base + fpp_aptp + 1)) ;
	fpp_opadd = fpp_pc ;		/* OPADD (2-5)		*/
	if (!(fpp_command & BIT5))
			fpp_x0 = ((*(base + fpp_aptp) & 070) << 9)
					+ (*(base + fpp_aptp + 2)) ;
	if (!(fpp_command & BIT6))
			fpp_br = ((*(base + fpp_aptp) & 0700) << 6)
					+ (*(base + fpp_aptp + 3)) ;
	if (!(fpp_command & BIT7))
	{
	    fpp_ac [0] = *(base + fpp_aptp + 5) ;
	    fpp_ac [1] = *(base + fpp_aptp + 6) ;
	    fpp_ac [2] = *(base + fpp_aptp + 7) ;
	    if (fpp_data == EP)
	    {
		fpp_ac [3] = *(base + fpp_aptp + 8) ;
		fpp_ac [4] = *(base + fpp_aptp + 9) ;
		fpp_ac [5] = *(base + fpp_aptp + 10) ;
	    }
	}
	fpp_stat &= ~BIT10 ;			/* Clear FPAUSE in stat	*/
	fpp_run = TRUE ;
	fpp_stat |= BIT11 ;			/* Set RUN in status	*/
	++PC ;
    }
}
VOID i6556 (VOID)				/* FPRST	6556	*/
{
    if (FPP)
	AC = (AC & 010000) | fpp_stat ;
}
VOID i6557 (VOID)				/* FPIST	6557	*/
{
    if (FPP && io_flags & fppFLAG)
    {
	++PC ;
	AC = (AC & 010000) | fpp_stat ;
	fpp_stat = 0 ;
	io_flags &= ~fppFLAG ;
    }
}
VOID i6567 (VOID)				/* FPEP		6567	*/
{
    if (FPP)
    {
	if ((AC & BIT0) && fpp_run == FALSE && fpp_command)
	{
	    fpp_stat &= ~BIT0 ;		/* Remove DP mode	*/
	    if (fpp_command & 0100000)
	    {
		fpp_stat |= 4 ;		/* Set EP in status	*/
		fpp_data = EP ;		/* Set EP mode		*/
		fpp_command &= 0107777 ;
	    }
	}
	AC &= 010000 ;
    }
}
/*
 *	LE8-E Line Printer
 */
VOID i6661 (VOID)				/* PSKF		6661	*/
{
    if (io_flags & lp8doneFLAG)
	++PC ;
}
VOID i6662 (VOID)				/* PCLF		6662	*/
{
    io_flags &= ~lp8doneFLAG ;
#if LP8ERROR
    io_flags &= ~lp8errorFLAG ;
#endif
}
VOID i6663 (VOID)				/* PSKE		6663	*/
{
#if LP8ERROR
    if (io_flags & lp8errorFLAG)
	++PC ;
#endif
}
VOID i6664 (VOID)				/* PSTB		6664	*/
{
    if (lp8printer)
    {
	printCHAR = AC & 0177 ;
	fwrite (&printCHAR, 1, 1, lp8printer) ;
    }
}
VOID i6665 (VOID)				/* PSIE		6665	*/
{
    int_mask |= lp8doneFLAG ;
}
VOID i6666 (VOID)				/* PCLF PSTB	6666	*/
{
    if (lp8printer)
    {
	io_flags &= ~lp8doneFLAG ;
	printCHAR = AC & 0177 ;
	if (fwrite (&printCHAR, 1, 1, lp8printer) == 1)
	    io_flags |= lp8doneFLAG ;
#if LP8ERROR
	else /* ignore possibility of error since OS traps it anyway */
	    io_flags |= lp8errorFLAG ;
#endif
    }
    else
	io_flags |= lp8doneFLAG ;	/* set done flag if no printer	*/
}
VOID i6667 (VOID)				/* PCIE		6667	*/
{
    int_mask &= ~lp8doneFLAG ;
}
/*
 *	RK8-E Disk System
 */
VOID i6741 (VOID)				/* DSKP		6741	*/
{
    ++PC ;
}
VOID i6742 (VOID)				/* DCLR		6742	*/
{
    rk8status = 0 ;
    switch (AC & 3)
    {
	case 00 :
	    AC &= 010000 ;
	    break ;
	case 01 :
	    AC &= 010000 ;
	    rk8command = 0 ;
	    rk8curaddr = 0 ;
	    rk8block = 0 ;
	    break ;
	case 02 :
	    AC &= 010000 ;
	    if (rk8 [rk8unit].drive)
	    {
		if (rk8 [rk8unit].dirty)
		    rk8writ (rk8unit) ;
		if (rk8 [rk8unit].cyl)
		{
		    rk8 [rk8unit].cyl = 0 ;
		    rk8read (rk8unit) ;
		}
	    }
	    else
		rk8status |= BIT10 ;
	    break ;
	case 03 :
	    AC &= 010000 ;
	    rk8status |= BIT10 ;
    }
    io_flags |= rk8FLAG ;
}
VOID i6743 (VOID)				/* DLAG		6743	*/
{
    rk8block = ((rk8command & 1) << 12) | (AC & 07777) ;
    AC &= 010000 ;
    if (rk8block > 014537)
	rk8status |= BIT11 ;
    rk8words = (rk8command & BIT5) ? 128 : 256 ;
    rk8write = FALSE ;
    if (rk8 [rk8unit].drive)
    {
	rk8count = 0 ;
	switch (rk8command & 07000)
	{
	    case 00000 :	/* Read Data	*/
	    case 01000 :	/* Read All	*/
		if (rk8block <= 014537)
		    rk8count = rk8io (rk8unit, rk8block,
				(UBYTE) rk8command & BIT5, FALSE,
				((rk8command & 070) << 9) | rk8curaddr) ;
		rk8curaddr = (rk8curaddr + rk8count) & 07777 ;
		io_flags |= rk8FLAG ;
		break ;
	    case 02000 :	/* Set Write Protect	*/
		rk8lock = TRUE ;
		io_flags |= rk8FLAG ;
		break ;
	    case 03000 :	/* Seek Only	*/
		if (rk8 [rk8unit].cyl != (rk8block >> 5)
						&& rk8 [rk8unit].dirty)
		    rk8writ (rk8unit) ;
		rk8 [rk8unit].cyl = rk8block >> 5 ;
		rk8read (rk8unit) ;
		if (rk8command & BIT4)
		    io_flags |= rk8FLAG ;
		break ;
	    case 04000 :	/* Write Data	*/
	    case 05000 :	/* Write All	*/
		if (rk8lock == FALSE)
		{
		    rk8write = TRUE ;
		    if (rk8block <= 014537)
			rk8count = rk8io (rk8unit, rk8block,
					(UBYTE) rk8command & BIT5, TRUE,
					((rk8command & 070) << 9)
					+ rk8curaddr) ;
		    rk8curaddr = (rk8curaddr + rk8count) & 07777 ;
		    break ;
		}
		else
		    rk8status |= BIT7 ;
		io_flags |= rk8FLAG ;
		break ;
	    case 06000 :	/* Cases 6 & 7 unused	*/
	    case 07000 :
		io_flags |= rk8FLAG ;
		break ;
	}
    }
    else
    {
	rk8status |= BIT4 | BIT10 ;
	io_flags |= rk8FLAG ;
    }
}
VOID i6744 (VOID)				/* DLCA		6744	*/
{
    rk8curaddr = AC & 07777 ;
    AC &= 010000 ;
}
VOID i6745 (VOID)				/* DRST		6745	*/
{
    AC = (AC & 010000) | rk8status ;
}
VOID i6746 (VOID)				/* DLDC		6746	*/
{
    rk8command = AC & 07777 ;
    AC &= 010000 ;
    rk8status = 0 ;
    rk8unit = (rk8command & 06) >> 1 ;
    if (rk8command & BIT3)
	io_flags |= rk8FLAG ;
    if (rk8command & BIT4)
	int_mask |= rk8FLAG ;
}

VOID i6750 (VOID)				/* ZEROMEM		*/
{
    UWORD *p = base ;
    INT i = 8192 ;

    dateword = *(base + 017666) ;	/* Save field 1 date word	*/
    while (i--)				/* Clear 32K memory to zeroes	*/
	*p++ = 0 , *p++ = 0 , *p++ = 0 , *p++ = 0 ;
    run = FALSE ;			/* HLT the PDP8 CPU		*/
}

VOID i6760 (VOID)				/* AC2SR	6760	*/
{
    SR = AC & 07777 ;		/* Set SR = AC, clear AC	*/
    AC &= 010000 ;
}

VOID i6770 (VOID)				/* DOS/SHELL	6770	*/
{
    UWORD *p ;
    INT i ;

    i = 0 ;
    p = base + 01000 ;
    while (*p && i < 80)
	chrsout [i++] = *p++ & 0177 ;
    chrsout [i] = '\0' ;
    if (!strncmp (chrsout, "DOS ", 4) && chrsout [4])
	AC = (AC & 010000) | (system (&chrsout [4]) & 07777) ;
    else
	if (!strcmp (chrsout, "SH") || !strcmp (chrsout, "SHE")
		|| !strcmp (chrsout, "SHEL")
		|| !strcmp (chrsout, "SHELL"))
	{
	    AC = (AC & 010000) ;	/* Clear pdp8 AC	*/
#ifdef AMIGA
	    AC |= system ("NewShell <nil: >nil:"
			" con:0/12/640/79/AmigaShell/CLOSE") & 07777 ;
#else
	    AC |= system ("shell") & 07777 ;
#endif
	}
}

/*
 *	Auxilliary keyboard.
 */
VOID iakcf (VOID)				/* AKCF		6400	*/
{
    io_flags &= ~auxinFLAG ;
}
VOID iaksf (VOID)				/* AKSF		6401	*/
{
    if (io_flags & auxinFLAG)
	++PC ;
}
VOID iakcc (VOID)				/* AKCC		6402	*/
{
    GetChar (040, TRUE) ;
    io_flags &= ~auxinFLAG ;
    AC &= 010000 ;
}
VOID iakrs (VOID)				/* AKRS		6404	*/
{
    AC |= GetChar (040, FALSE) ;
}
VOID iakie (VOID)				/* AKIE		6405	*/
{
    if (AC & 1)
	int_mask |= auxinFLAG | auxoutFLAG ;
    else
	int_mask &= ~(auxinFLAG | auxoutFLAG) ;
}
VOID iakrb (VOID)				/* AKRB		6406	*/
{
    io_flags &= ~auxinFLAG ;
    AC = (AC & 010000) | GetChar (040, TRUE) ;
}
/*
 *	Auxilliary display.
 */
VOID iatfl (VOID)				/* ATFL		6410	*/
{
    io_flags |= auxoutFLAG ;
}
VOID iatsf (VOID)				/* ATSF		6411	*/
{
    if (io_flags & auxoutFLAG)
	++PC ;
}
VOID iatcf (VOID)				/* ATCF		6412	*/
{
    io_flags &= ~auxoutFLAG ;
}
VOID iatpc (VOID)				/* ATPC		6414	*/
{
    PutChar (041, (UBYTE) AC) ;
}
VOID iatsk (VOID)				/* ATSK		6415	*/
{
    if (io_flags & int_mask & (auxinFLAG | auxoutFLAG))
	++PC ;
}
VOID iatls (VOID)				/* ATLS		6416	*/
{
    PutChar (041, (UBYTE) AC) ;
    io_flags |= auxoutFLAG ;
}
/* -------------------------------------------------------------------- */
