* Program     CMAIN.cmd
* Author      joe stegman  for Ashton-Tate
* Date        23 Feb 1983

*    Sample program for dBASE II(tm)  release 2.4
* Please make any changes to these programs to suit your needs.

*    CMAIN.cmd      This program is a tickle calendar file program. Any kind
* of data may be stored in the data base. The recall may be by tickle date or
* by a keyword of up to 10 char.

*    The report generated by the program is using the report verb of dBASE II.
* The report sequence is by TICKLE date or KEYWORD. Other reports could be
* generated to list records in any other sequence or another format.

* The database files:	First the TEXT file
* TEXT.dbf holds all the following data for the entries.
*    Contact name       25 char (10 characters for the KEY)
*    Company name       25 char (10 characters for the KEY)
*    Address            30 char
*    City               20 char
*    State               2 char
*    Zip code           10 char (99999-9999)
*    Phone number       12 char (999/999-9999)
*    Your Initials       3 char
*    Entry Date          8 char MM/DD/YY
*    Tickle Date         8 char MM/DD/YY
*    Line one           50 char This is the text data
*    Line two           50 char second line of text data
*    Keyword            10 char   used for specific recall...

* KEYWORD.ndx  -  keyword+$(tkl:date,7,2)+$(tkl:date,1,2)+$(tkl:date,4,2)
*    places the file in keyword order then tickle date

* TICKLE.ndx   -  $(tkl:date,7,2)+$(tkl:date,1,2)+$(tkl:date,4,2)
*    places file in chronological order by tickle date

* uses the following command and other dBASE II support files:
*    cprint.cmd     Prints a report sequenced by the index file selected.
*    appecard.fmt   Format file for appending new cards to database
*    editcard.fmt   Format file for editing existing cards in database
*    tickle.frm     Report format file
*    text.dbf       Datebase of tickle cards
*    tickle.ndx     Tickle date index
*    keyword.ndx    Keyword&tickle date index

**
**   Begin command file
**

clear
set talk off

* Load the date test routine into memory and set the call address
LOAD datetest
SET CALL TO 42240

ERASE
*  Read the current date, then set the system date
STORE DATE() TO tmp:date
DO WHILE DATE() = '00/00/00'
  @ 5,5 SAY "Please enter Today's Date (MM/DD/YY) ";
      GET tmp:date PICT '99/99/99'
  READ
 *   erase any error message
  @ 5,60
 *   test the date, if not correct display an error message, reprompt
  CALL tmp:date
  IF tmp:date = '    '
    @ 5,60 SAY '** Date Invalid **'
  ELSE
    *  use macro expansion to set the system date.
    SET date TO &tmp:date
  ENDIF
ENDDO

* open the DBF, NDX files
USE text
SET index TO tickle, keyword
*  if look for the tmp:date in the recall fld
* find todays date in the file
STORE $(tmp:date,7,2)+$(tmp:date,1,2)+$(tmp:date,4,2) TO tmp:date
FIND &tmp:date
*  if today is not in file, position to record 1
IF # = 0
  skip
ENDIF
RELE tmp:date
STORE T TO tklindex
*  initialize the Index file flag line '' * ''
STORE 5 TO line
*  initialize the deleted record counter, used to prompt for PACK..
STORE 0 TO delcnt

*  This is a forever loop, note the "T"
DO WHILE T
 *   display the current record and the main menu
  ERASE
  @  1,10 SAY "Tickle File Control Screen"
 *   Do not display any data if no records in file.
  IF ##0
    @  2,54 SAY "Deleted (T/F)"
    @  $,$+3 SAY * USIN 'X'
    @  3, 0 SAY "Contact  " +contact
    @  3,54 SAY "Your Initials " +initials
    @  4, 0 SAY "Company  " +company
    @  4,54 SAY "Entry Date    " +e:date
    @  5, 0 SAY "Address  " +address
    @  5,54 SAY "Tickle Date   " +tkl:date
    @  6, 0 SAY "City     " +city
    @  6,54 SAY "Keyword   " +keyword
    @  7,53 SAY "* Indicates Index"
    @  7, 0 SAY "State    " +state
    @  7,14 SAY "Zip " +zip
    @  8, 0 SAY "Phone    " +Phone
    @ 10, 2 SAY "Comments  " +line1
    @ 11,12 SAY line2
    @ line,53 SAY '*'
  ENDIF
  @ 18,0 SAY;
'   A)ppend new cards         D)elete this card         F)ind card'
  @ 19,0 SAY;
'   E)dit existing cards      R)ecall this card         S)et INDEX'
  @ 20,0 SAY;
'   P)rint range of cards     Q)uit to dBASE II'
  @ 21,0 SAY;
'   > skip forward one card   < skip backward one card'
  @ 23,0 SAY 'Enter an option from the above menu '
  STORE ' ' TO option
  DO WHILE .not. option$'AEDRPQ<>FS'
    @ 23,35 GET OPTION PICT '!'
    READ
  ENDDO

  @ 23,0 SAY '                                            '
  DO CASE
    CASE option='Q'
      IF delcnt > 0
       * if there were some records deleted, find out if they should be packed
        INPUT 'Do you want to PACK the database file(Y/N) ?' TO ans
        IF ans
          SET index TO tickle,keyword
          ? 'Using PACK to remove cards marked for deletion.'
          PACK
        ENDIF
      ENDIF
      USE
      RELE all
      RETURN

    CASE option='A'
     *   append records to the tickle file using full screen display
     *  the format file allows the program to alter only the required info
     *   leaving other info for display only.
      SET format TO Appecard
      APPEND
      SET format TO

    CASE option='E'
     *  now that some records have been appended to the data file, we can go
     * into the edit for back to the selection line.
      SET format TO Editcard
     *  edit the current record in the index...
      EDIT #
      SET format TO

     *  Edit in this form allows the user to edit any record by moving forward
     * or backward in the file.

    CASE option='D'
     *   Delete current card displayed on screen
     *   don't need to do this if the record is already marked DELETE
      IF .not. *
        delete
        STORE delcnt +1 TO delcnt
      ENDIF

    CASE  option='R'
     *   Recall current card displayed on screen
     *   only need to do this if the record is marked DELETE
      IF *
        recall
        STORE delcnt -1 TO delcnt
      ENDIF

    CASE option='F'
     *   prompt for the card to find
      STORE '          ' TO lookup
      STORE '99/99/99' TO pictchar
      IF .not. tklindex
       *  KEYWORD index set so look for a keyword
        @ 22,0 SAY 'Find is based on KEYWORD.'
        STORE 'XXXXXXXXXX' TO pictchar
      ELSE
        @ 22,0 SAY 'Find is based on TICKLE DATE.'
      ENDIF
      DO WHILE lookup = '          ' .or. # = 0
        @ 23,0 SAY 'Enter the keyword to find, press return to abort find ';
             GET lookup PICT '&pictchar'
        read
        STORE TRIM(lookup) TO lookup
        IF tklindex
          CALL lookup
          STORE $(lookup,7,2)+$(lookup,1,2)+$(lookup,4,2) TO lookup
        ENDIF
        IF lookup#'          '
          FIND &lookup
        ENDIF
      ENDDO


    CASE option='S'
     *  Swith the index between the tickle/keyword indexes
      IF tklindex
        SET index TO keyword,tickle
        STORE F TO tklindex
        STORE 6 TO line
      ELSE
        SET index TO tickle,keyword
        STORE T TO tklindex
        STORE 5 TO line
      ENDIF

    CASE option='P'
     *  Print the cards in recall or keyword order.
      DO cprint
      rele strtdate, stopdate, lkupkey, expression


    CASE  option='>'
     *  skip forward
      SKIP

    CASE option='<'
     *  skip backward
      SKIP -1

  ENDCASE

ENDDO
return
* CMAIN.cmd  EOF
