	; 2708 PROM PROGRAMMER
;
	; SUBROUTINES FROM ASMS80 MONITOR
;
	; PROGRAM TIME 3:20
;
	ORG 100H
;
RAM	EQU 0FEF8H		; START OF TEMP STORAGE
POFF	EQU 0A8H		; PROM OFF
QTYP	EQU -1023D		; 1K BY 8 ROM
THXB	EQU 0F418H		; TYPE 'A' IN ASCII-HEX 2 CH
STACK	EQU RAM-8		; STACK EQUAL TO RAM MINUS 8
GHXW	EQU 0F424H		; GET HEX WORD TO HL
PROM 	EQU 2			; ADDRESS OF PROGRAM PORT
L4AS	EQU 80H			; FIRST 4 BITS OF ADDRESS
L8AS	EQU 90H			; NEXT 4 BITS OF ADDRESS
H2AS	EQU 0A8H		; LAST 2 BITS OF ADDRESS
L4DS	EQU 0B0H		; FIRST 4 BITS OF DATA
H4DS	EQU 0C0H		; LAST 4 BITS OF DATA
DISA	EQU 0A8H		; DISABLE
OF26	EQU 0F0H		; POWER SUPPLIES OFF
BEEP	EQU 07			; ALERT
THXW	EQU 0F41BH		; TYPE 'HL' IN ASCII-HEX 4 CH
TYPE 	EQU  0F403H		; TYPE A CHAR FROM 'A'
GETCH	EQU 0F406H		; GET CHAR TO 'A' (NO ECHO)
ON12	EQU 0A0H		; ON POWER
MSG	EQU 0F40CH		; TYPE MSG, POINTER IN HL
				; ( MSG TERMINATED BY 0FFH )
CRLF	EQU 0A0DH
;
	LXI	SP,STACK
	LXI 	H,0
	SHLD 	STACK+2
	LXI 	B,QTYP
	MVI 	A,26D
	CALL 	TYPE
	MVI 	A,DISA
	OUT 	PROM
	LXI 	H,MSG2
	CALL 	MSG
	CALL 	CHKS
	LXI 	H,MSG1
	CALL 	MSG
	JMP 	PROG
CHKS	LXI 	D,0
	IN 	1		; PORT ONE FOR KEYBOARD INPUT
	ANI 	7FH		; STRIP PARITY
	CPI	1BH		; ESC	
	JZ	TERM	
	CALL	ADRS
	CALL 	STALL
	IN 	PROM
	CPI 	0FFH		;CHECK FOR ERASED ROM
	CNZ 	ERROR
	PUSH 	D
	XCHG
	DAD 	B
	POP 	D		; MAKE  STACK HAPPY
	INX 	D
	JNC 	CHKS+3
	RET
MSG1	DB 	'IF NO ERRORS LISTED'
	DW 	CRLF
	DB 	'ENABLE PROGRAMMER'
	DB  	' INPUT  STARTING ADDRESS'
	DW 	CRLF
	DW 	072AH,-1
MSG2	DW 	CRLF
	DB 	'CHECKING FOR ERASED'
	DB 	' PROM'
	DW 	CRLF
	DW 	CRLF,-1
MSG3	DB 	'PROGRAMMING COMPLETE, TURN'
	DW 	CRLF
	DB 	'+26V AND +12V OFF'
	DW 	CRLF
	DB 	'RETURN KEY TO CONTINUE'
	DW 	CRLF
	DB 	'VERIFYING PROM'
	DW 	CRLF,-1
MSG4	DB 	'THE PRECEEDING LIST REPRESENTS'
	DW 	CRLF
	DB 	'ERRORS IN PROM, IF NO LIST'
	DW 	CRLF
	DW 	CRLF
	DB 	'PROGRAMMING COMPLETE'
	DW 	CRLF,-1
ADRS	MOV 	A,E
	ANI 	0FH
	ADI 	L4AS
	OUT 	PROM
	MOV 	A,E
	RAR! RAR! RAR! RAR!
	ANI 	0FH
	ADI 	L8AS
	OUT  	PROM
	MOV 	A,D
	ANI 	03H
	ADI 	H2AS
	OUT 	PROM
	RET
ADR1	MOV 	A,E
	ANI 	0FH
	ADI 	L4AS
	OUT 	PROM
	MOV 	A,E
	RAR! RAR! RAR! RAR!
	ANI 	0FH
	ADI 	L8AS
	OUT 	PROM
	MOV  	A,D
	ANI 	03H
	STA 	STACK+6
	ADI  	0A0H
	OUT 	PROM
	RET
ERROR	MVI 	A,BEEP
	CALL 	TYPE
	XCHG
	CALL 	THXW
	MVI 	A,20H
	CALL 	TYPE
	IN 	PROM
	CALL 	THXB
	MVI 	A,0DH
	CALL 	TYPE
	MVI 	A,0AH
	CALL 	TYPE
	XCHG
	RET
PROG	CALL 	GHXW
	SHLD 	STACK+4
	MVI 	A,0AH
	CALL 	TYPE
	MVI 	A,0DH
	CALL 	TYPE
	MVI 	A,ON12
	OUT 	PROM
PRO1	LXI 	D,0
	LHLD 	STACK+4
PRO2	IN 	1		; PORT ONE FOR KEYBOARD INPUT
	ANI 	7FH		; STRIP PARITY
	CPI 	1BH		;ESCAPE
	JZ 	TERM		; BACK TO MONITOR
	CALL 	ADR1
	CALL 	DATA
	CALL 	PULS
	PUSH	H
	PUSH 	D
	XCHG
	DAD 	B
	JC 	PASS
	POP 	D
	POP 	H		; EVERY BODY HAPPY
	INX 	H		; BUMP  BY 1
	INX 	D
	LXI 	SP,STACK
	JMP 	PRO2
PULS	MVI 	A,70H
	OUT 	PROM
	MVI 	A,18H
	DCR 	A
	JNZ 	$-1
	MVI 	A,OF26
	OUT 	PROM
	RET
DATA	MOV 	A,M
	ANI 	0FH
	ADI 	L4DS
	OUT 	PROM
	MOV 	A,M
	RAR! RAR! RAR! RAR!
	ANI 	0FH
	ADI 	H4DS
	OUT 	PROM
	RET
PASS	LHLD 	STACK+2
	INX 	H
	SHLD 	STACK+2
	LXI 	D,0FE0BH
	DAD	D
	JNC 	PRO1
VERF	LDA 	STACK+6
	ADI 	POFF
	OUT 	PROM
	MVI 	A,BEEP		; WAKE UP !!!
	CALL 	TYPE
	LXI 	H,MSG3
	CALL 	MSG
	MVI 	A,BEEP
	CALL 	TYPE
HALT	IN 	0		; PORT 0 BIT 1 FOR STATUS
	ANI 	1		 
	JNZ 	HALT
	LHLD 	STACK+4
	LXI 	D,0
VERF1	IN	1		; PORT 1 FFOR KEYBOARD INPUT
	ANI 	7FH		; STRIP PARITY
	CPI 	1BH		; ESCAPE
	JZ 	0F400H		;BACK TO MONITOR
	CALL 	ADRS		;OTHERWISE
	CALL 	STALL		;CONTINUE
	IN 	PROM		; VERIFYING
	CMP	M		; WITH THIS DATA
	CNZ 	ERROR
	PUSH 	D
	PUSH	H
	XCHG
	DAD 	B
	POP 	H
	INX 	H
	POP 	D
	INX 	D
	JNC 	VERF1		;GO BACK AND DO IT AGAIN
	LXI 	H,MSG4
	CALL 	MSG		;PRINT IT
	JMP 	0F400H		;ALL DONE
STALL	MVI 	A,0FFH		;STALL FOR TIME
	DCR	A		; SLOW IT DOWN
	JNZ 	$-1		; UNTIL TIMED OUT
	RET			;GET BACK TO CALLER
TERM	MVI 	A,DISA		;DISABLE NOW
	OUT 	PROM		;HERE
	JMP 	0F400H		;GO TO MONITOR
	END			; LAST ENTRY
