/* -*-c,save-*- */

/*

 * blackjak.c - Black Jack (Las Vagas style) program

 * Robert Heller. Created: Mon Mar 17, 1986 15:30:07.70

 * Last Mod: 

 * 

 * (c) Copyright 1986 by Robert Heller

 *     All Rights Reserved

 * 

 * 

 */



#include <stdio.h>

#include "phrase.h"



#define LOCAL static



/* #define DEBUG /* debugging */



#ifdef DEBUG

#define LOCAL /* static */

#endif





main()

{

    char dealer[10],player[10],temp[2];

    register int chips;

    int bet,shuffle;

    register int dvalue,pvalue;

    char scratch[1024];

    extern int decktype;



    decktype = 1;

    que_init(); card_ini(); 

    printf("Welcome to Las Vagas BlackJack\n\n");

    if (quest("Would you like to know the rules/(yes)1|(YES)1|(no)0|(NO)0") ==

	1) instr();

    srand(gettime());

    chips = (rand() % 100) + 20;

    printf("We'll start you off with %d chips\n",chips);

    shuffle = TRUE;

    do {

        sprintf(scratch,"How much do you want to bet/0(1...%d)",chips);

	quest(scratch,&bet);

	chips -= bet;

	shuffle = !rhand(2,player,shuffle);

	if (shuffle) {

	    printf("re-shuffling the decks...\n");

	    shuffle = !rhand(2,player,shuffle);

	    }

	shuffle = !rhand(2,dealer,shuffle);

	if (shuffle) {

	    printf("re-shuffling the decks...\n");

	    shuffle = !rhand(2,dealer,shuffle);

	    }

	temp[0] = dealer[0]; temp[1] = '\0';

	display(player,scratch);

	pvalue = bcount(player);

	printf("You are dealt %s; which adds up to %d, and the dealer shows ",

	       scratch,pvalue);

	display(temp,scratch);

	printf("%s\n",scratch);

	while (pvalue < 21 &&

	       quest("Hit (H) or Stick (S)/(H)1|(h)1|(S)0|(s)0")) {

	    shuffle = !rhand(1,temp,shuffle);

	    if (shuffle) {

		printf("re-shuffling the decks...\n");

		shuffle = !rhand(1,temp,shuffle);

		}

	    strcat(player,temp);

	    display(player,scratch);

	    pvalue = bcount(player);

	    printf("You now have %s, which adds up to %d\n",scratch,pvalue);

	    }

	if (pvalue > 21) {

	    printf("You are busted.  I take all %d  chips\n",bet);

	    insult(scratch);

	    prblk(scratch);

	    }

	else if (bjack(player,pvalue)) {

	    printf("You have BlackJack!, you win %d chips\n",bet*2);

	    chips += bet*3;

	    praise(scratch);

	    prblk(scratch);

	    }

	else {

	    letmesee(scratch);

	    prblk(scratch);

	    dvalue = bcount(dealer);

	    display(dealer,scratch);

	    printf("I have %s, which adds up to %d\n",scratch,dvalue);

	    while (dvalue <= 16) {

		printf("I take a hit...\n");

		shuffle = !rhand(1,temp,shuffle);

		if (shuffle) {

		    printf("re-shuffling the decks...\n");

		    shuffle = !rhand(1,temp,shuffle);

		    }

		strcat(dealer,temp);

		dvalue = bcount(dealer);

		display(dealer,scratch);

		printf("I now have %s, which adds up to %d\n",scratch,dvalue);

		}

	    if (dvalue > 21) {

		printf("I'm busted. You win %d chips\n",bet);

		praise(scratch);

		prblk(scratch);

		chips += (bet * 2);

		}

	    else if (dvalue >= pvalue) {

		printf("I win!  I get all %d chips\n",bet);

		insult(scratch);

		prblk(scratch);

		}

	    else {

		printf("You beat me.  You win %d chips\n",bet);

		praise(scratch);

		prblk(scratch);

		chips += (bet * 2);

		}

	    }

	printf("You now have %d chips\n",chips);

	} while(chips > 0 && 

    		quest("Another round/(YES)1|(yes)1|(NO)0|(no)0"));

    if (chips > 0) {

	printf("You leave with %d chips.  I'll print you an I.O.U.\n",chips);

	priou(chips);

	}

    }

LOCAL bcount(hand)

char *hand;

{

    char VALS[20];

    register int card,sum1,aces;

    register char *p;



    sum1 = aces = 0;

    vals(hand,VALS);

    for (p=VALS;*p != '\0';p++) {

	card = ((*p) - 'A') + 2;

	if (card == 14) { /* ace */

	    sum1++;

	    aces++;

	    }

	else if (card >= 10) { /* ten or face card */

	    sum1 += 10;

	    }

	else {	/* 2 to 9 */

	    sum1 += card;

	    }

	}

    while (aces-- > 0 && (sum1 + 10) <= 21) sum1 += 10;

    return(sum1);

    }

LOCAL bjack(hand,value)

char *hand;

register int value;

{

    register int card1,card2;

    char v[3];



    if (value != 21 || strlen(hand) != 2) return(FALSE);

    vals(hand,v);

    card1 = v[0];

    card2 = v[1];

    if (card1 == 'J' || card2 == 'J') return(TRUE);

    return(FALSE);

    }

LOCAL prblk(s)

register char *s;

{

    register int len;



    len = 0;

    while (*s != '\0') {

	if (*s <= ' ' && len > 60) {

	    putchar('\n');

	    while (*s > '\0' && *s <= ' ') s++;

	    len = 0;

	    }

	if (*s != '\0') {

	    putchar(*s);

	    len++;

	    s++;

	    }

	}

    if (len > 0) putchar('\n');

    }

LOCAL instr()

{

    printf("\n    Las Vagas BlackJack\n\n");

    printf("    In BlackJack, you and the dealer (the computer) are each\n");

    printf("dealt 2 cards, one face up and one face down.  You then can\n");

    printf("either `hit' (get another card) or `stick' (see what the dealer\n");

    printf("has. The object is to get the highest value hand without going\n");

    printf("over 21.  Cards from 2 to 10 are worth the face value, face cards\n");

    printf("(Jacks, Queens & Kings) are worth 10 and Aces are worth either\n");

    printf("1 or 11.  If you get a Jack and an Ace you have `BlackJack' and\n");

    printf("get double payoff.  If you and the dealer tie, the dealer wins.\n");

    printf("The dealer must take a hit if his hand is not more than 16.\n\n");

    printf("          GOOD LUCK!!!\007\007\007\007\n\n");

    }

LOCAL priou(chips)

register int chips;

{

    FILE *fopen();

    register FILE *printer;

    register int i,len;

    char amt[10];

    register char *p;



    printer = fopen("LST:","w");

    fprintf(printer,"\033\034");

    for (i=0;i<20;i++) fprintf(printer,"\n\n");

    len = 20;

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00eb,printer);

    for (i=1;i<50;i++) fputc(0x00e7,printer);

    fputc(0x00ec,printer);

    fputc('\n',printer);

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00e9,printer);

    for (i=1;i<50;i++) fputc(' ',printer);

    fputc(0x00ea,printer);

    fputc('\n',printer); len++;

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00e9,printer);

    for (i=1;i<50;i++) fputc(' ',printer);

    fputc(0x00ea,printer);

    fputc('\n',printer);

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00e9,printer);

    for (i=1;i<50;i++) fputc(' ',printer);

    fputc(0x00ea,printer);

    fputc('\n',printer); len++;

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00e9,printer);

    fprintf(printer,"===============Las Vagas BlackJack===============");

    fputc(0x00ea,printer);

    fputc('\n',printer);

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00e9,printer);

    for (i=1;i<50;i++) fputc(' ',printer);

    fputc(0x00ea,printer);

    fputc('\n',printer); len++;

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00e9,printer);

    for (i=1;i<10;i++) fputc(' ',printer);

    sprintf(amt,"%9d",chips);

    p = amt;

    while (*p == ' ') *p++ = '*';

    fprintf(printer,"I.O.U in amount %schips",amt);

    for (i=1;i<11;i++) fputc(' ',printer);

    fputc(0x00ea,printer);

    fputc('\n',printer);

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00e9,printer);

    for (i=1;i<50;i++) fputc(' ',printer);

    fputc(0x00ea,printer);

    fputc('\n',printer); len++;

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00e9,printer);

    fprintf(printer,"===============Las Vagas BlackJack===============");

    fputc(0x00ea,printer);

    fputc('\n',printer);

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00e9,printer);

    for (i=1;i<50;i++) fputc(' ',printer);

    fputc(0x00ea,printer);

    fputc('\n',printer); len++;

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00e9,printer);

    for (i=1;i<50;i++) fputc(' ',printer);

    fputc(0x00ea,printer);

    fputc('\n',printer);

    for (i=1;i<10;i++) fputc(' ',printer);

    fputc(0x00ed,printer);

    for (i=1;i<50;i++) fputc(0x00e8,printer);

    fputc(0x00ee,printer);

    fputc('\n',printer); len++;

    for (i=len;i<66;i++) fprintf(printer,"\n\n");

    fprintf(printer,"\033\066");

    fclose(printer);

    }

                                                                                                        