/*
* The official AT&T public domain version of getopt(3).
*/
#include <stdio.h>

int  optopt;                                              /* For getopt */
int  opterr = 1;                                          /* For getopt */
int  optind = 1;                                          /* For getopt */
char *optarg;                                             /* For getopt */

#define ERR(s, c) \
    if (opterr) {   \
        extern int strlen(), write();   \
        char       errbuf[2];           \
        errbuf[0] = c; errbuf[1] = '\n';\
        (void) write(2, argv[0], (unsigned) strlen(argv[0])); \
        (void) write(2, s, (unsigned) strlen(s));\
        (void) write(2, errbuf, 2);\
    }

int getopt(argc, argv, opstring)
int   argc;
char  **argv,
     *opstring;
{
    static int    sp = 1;
    register int  c;
    register char *cp;

    if (sp == 1)
        if (optind >= argc ||
            argv[optind][0] != '-' ||
            argv[optind][1] == '\0')
            return (EOF);
        else
            if (strcmp(argv[optind], "--") == NULL) {
                optind++;
                return (EOF);
            }

    optopt = c = argv[optind][sp];
    if (c == ':' ||
        (cp = strchr(opstring, c)) == NULL) {
        ERR(": illegal option -- ", c);
        if (argv[optind][++sp] == '\0') {
           optind++;
           sp = 1;
        }

        return ('?');
    }

    if (*++cp == ':') {
        if (argv[optind][sp+1] != '\0')
            optarg = &argv[optind++][sp+1];
        else
            if (++optind >= argc) {
                ERR(": option requires an argument -- ", c);
                sp = 1;
                return ('?');
            }
            else
                optarg = argv[optind++];

        sp = 1;
    }
    else {
        if (argv[optind][++sp] == '\0') {
            sp = 1;
            optind++;
        }

        optarg = NULL;
    }

    return (c);

} /* getopt */


#if (0)
/*
* My own version of the UNIX getopt function for non-UNIX systems.  It is not
*  a fully functioning getopt but it will suffice for most anything
*/
int getopt(argc, argv, opstring)
int   argc;
char  **argv,
     *opstring;
{
    int   option = -1,                         /* Option to be returned    */
          index = 0,                           /* Index into opstring      */
          get_args = 0,                        /* Boolean to flag arg val. */
          found = 0,                           /* Boolean flag found flag  */
          loop;                                /* Loop counter for parsing */
    char  flag = NULL;                         /* Flag/option to check for */

    optarg = NULL;

    /* Check for no arguments */
    if (argc == 1)
        return(option);

    if (argv[optind][0] != '-')
        return(option);

    flag = opstring[index++];
    if (opstring[index] == ':')
        get_args = 1;

    /* Scan 'next' argument until the last one */
    for (loop = optind; !found; ) {
        if (flag == argv[loop][1]) {
            if (get_args)
                optarg = (char *) argv[loop] + 2;

            option = argv[loop][1];
            optind = loop + 1;
            found = 1;
        }

        if (!found) {
            /* Didnt match so check next character in opstring */
            flag = opstring[index++];

            /* Check to see if at end of opstring yet */
            if (flag == NULL)
                return ('?');

            if (opstring[index] == ':')
                get_args = 1;
            else
                get_args = 0;
        }
    } /* for (loop = 1; loop < argc; loop++) */

    return(option);

} /* end getopt */
#endif
