
#include <stdio.h>


char includedir[128] = "/lcc-1.9/include";

int info_flag = 0;

/*
** Faked execv()
*/

int fake_execv(char *command, char *args)

{
	int retval;
	FILE *outfile;

	if (!(outfile = fopen("temp.bat", "wt"))) {
		printf("lcc816: unable to open temporary batch file\n");
		exit(1);
	}

	printf("executing: %s %s\n", command, args);
	fprintf(outfile, "@%s %s", command, args);
	fclose(outfile);

	retval = system("temp");

	system("del temp.bat");

	if (retval)
		printf("lcc: %s %s returned %d\n", command, args, retval);


	return retval;
}

/*
** Main
*/

void main(int argc, char **argv)

{
	char vmfile[128], asmfile[128], cppfile[128], args[128];
	int i, retval;
	FILE *outfile;

	/* Handle options */

	printf("lcc65816 v0.10 by Toshiyasu Morita\n");
	printf("(based on lcc-1.9 by Chris Fraser & David Hansen)\n");

	for (i=1; (i < argc) && (argv[i][0] == '-'); i++) {

		if (!strcmp(argv[i], "-info"))
			info_flag = 1;
		else if (!strncmp(argv[i], "-I", 2)) {
			strcat(includedir, " ");
			strcat(includedir, argv[i]);
		} else
			printf("lcc816: Unknown option: %s\n", argv[i]);
	}

	/* Create filenames */

	strcpy(vmfile, argv[i]);

	if (strchr(vmfile, '.'))
		*(char *)strchr(vmfile, '.') = 0;

	strcat(vmfile, ".vm");

	strcpy(asmfile, argv[i]);

	if (strchr(asmfile, '.'))
		*(char *)strchr(asmfile, '.') = 0;

	strcat(asmfile, ".asm");

	strcpy(cppfile, argv[i]);

	if (strchr(cppfile, '.'))
		*(char *)strchr(cppfile, '.') = 0;

	strcat(cppfile, ".cpp");


	/* Preprocess file */

	sprintf(args, "-nostdinc -D__APPLEIIGS__ -I%s %s -o %s", includedir, argv[i], cppfile);
	fake_execv("cpp", args);

	/* Compile file */

	sprintf(args, "%s %s", cppfile, vmfile);
	fake_execv("rcc", args);

	/* Convert file to 65816 assembly */

	if (info_flag)
		sprintf(args, "-info %s %s", vmfile, asmfile);
	else
		sprintf(args, "%s %s", vmfile, asmfile);

	fake_execv("vm2gs2", args);

	exit(0);
}
