/*	 $NetBSD: bold8x16.h,v 1.9 2005/02/27 00:27:52 perry Exp $ */

/*-
 * Copyright (c) 1999 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Andrew Doran.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the NetBSD
 *	Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * This font lives in the public domain. It it a PC font, IBM encoding,
 * which was designed for use with syscons.
 */
extern u_char bold8x16_data[];

struct wsdisplay_font bold8x16 = {
	"Boldface",			/* typeface name */
	1,				/* firstchar */
	254,				/* numchars */
	WSDISPLAY_FONTENC_IBM,		/* encoding */
	8,				/* width */
	16,				/* height */
	1,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	bold8x16_data			/* data */
};

static u_char bold8x16_data[] = {
	/* 0x01 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x42, 	/* .*....*. */
	0x81, 	/* *......* */
	0xe7, 	/* ***..*** */
	0xa5, 	/* *.*..*.* */
	0x99, 	/* *..**..* */
	0x81, 	/* *......* */
	0x99, 	/* *..**..* */
	0x42, 	/* .*....*. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x02 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x7e, 	/* .******. */
	0xff, 	/* ******** */
	0x99, 	/* *..**..* */
	0xdb, 	/* **.**.** */
	0xe7, 	/* ***..*** */
	0xff, 	/* ******** */
	0xe7, 	/* ***..*** */
	0x7e, 	/* .******. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x03 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0x7c, 	/* .*****.. */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x04 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x7c, 	/* .*****.. */
	0xfe, 	/* *******. */
	0x7c, 	/* .*****.. */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x05 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0xd6, 	/* **.*.**. */
	0xfe, 	/* *******. */
	0xd6, 	/* **.*.**. */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x06 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x7c, 	/* .*****.. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0x54, 	/* .*.*.*.. */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x07 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x08 */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xe7, 	/* ***..*** */
	0xc3, 	/* **....** */
	0xc3, 	/* **....** */
	0xe7, 	/* ***..*** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */

	/* 0x09 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x42, 	/* .*....*. */
	0x42, 	/* .*....*. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x0A */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xc3, 	/* **....** */
	0x99, 	/* *..**..* */
	0xbd, 	/* *.****.* */
	0xbd, 	/* *.****.* */
	0x99, 	/* *..**..* */
	0xc3, 	/* **....** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */

	/* 0x0B */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1e, 	/* ...****. */
	0x0e, 	/* ....***. */
	0x1a, 	/* ...**.*. */
	0x30, 	/* ..**.... */
	0x78, 	/* .****... */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x0C */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x0D */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x18, 	/* ...**... */
	0x14, 	/* ...*.*.. */
	0x14, 	/* ...*.*.. */
	0x14, 	/* ...*.*.. */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x30, 	/* ..**.... */
	0x70, 	/* .***.... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x0E */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3e, 	/* ..*****. */
	0x22, 	/* ..*...*. */
	0x3e, 	/* ..*****. */
	0x22, 	/* ..*...*. */
	0x22, 	/* ..*...*. */
	0x22, 	/* ..*...*. */
	0x22, 	/* ..*...*. */
	0x26, 	/* ..*..**. */
	0x6e, 	/* .**.***. */
	0xe4, 	/* ***..*.. */
	0x40, 	/* .*...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x0F */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x92, 	/* *..*..*. */
	0x54, 	/* .*.*.*.. */
	0x28, 	/* ..*.*... */
	0xc6, 	/* **...**. */
	0x28, 	/* ..*.*... */
	0x54, 	/* .*.*.*.. */
	0x92, 	/* *..*..*. */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x10 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x70, 	/* .***.... */
	0x78, 	/* .****... */
	0x7c, 	/* .*****.. */
	0x7e, 	/* .******. */
	0x7e, 	/* .******. */
	0x7c, 	/* .*****.. */
	0x78, 	/* .****... */
	0x70, 	/* .***.... */
	0x60, 	/* .**..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x11 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0e, 	/* ....***. */
	0x1e, 	/* ...****. */
	0x3e, 	/* ..*****. */
	0x7e, 	/* .******. */
	0x7e, 	/* .******. */
	0x3e, 	/* ..*****. */
	0x1e, 	/* ...****. */
	0x0e, 	/* ....***. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x12 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x7c, 	/* .*****.. */
	0xfe, 	/* *******. */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0xfe, 	/* *******. */
	0x7c, 	/* .*****.. */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x13 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x14 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xf4, 	/* ****.*.. */
	0xf4, 	/* ****.*.. */
	0xf4, 	/* ****.*.. */
	0x74, 	/* .***.*.. */
	0x14, 	/* ...*.*.. */
	0x14, 	/* ...*.*.. */
	0x14, 	/* ...*.*.. */
	0x14, 	/* ...*.*.. */
	0x14, 	/* ...*.*.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x15 */
	0x00, 	/* ........ */
	0x1e, 	/* ...****. */
	0x30, 	/* ..**.... */
	0x78, 	/* .****... */
	0xdc, 	/* **.***.. */
	0xce, 	/* **..***. */
	0xe7, 	/* ***..*** */
	0x73, 	/* .***..** */
	0x3b, 	/* ..***.** */
	0x1e, 	/* ...****. */
	0x0c, 	/* ....**.. */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x16 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x17 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x7c, 	/* .*****.. */
	0xfe, 	/* *******. */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0xfe, 	/* *******. */
	0x7c, 	/* .*****.. */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */

	/* 0x18 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x7c, 	/* .*****.. */
	0xfe, 	/* *******. */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x19 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0xfe, 	/* *******. */
	0x7c, 	/* .*****.. */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x1A */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x08, 	/* ....*... */
	0x0c, 	/* ....**.. */
	0xfe, 	/* *******. */
	0xff, 	/* ******** */
	0xfe, 	/* *******. */
	0x0c, 	/* ....**.. */
	0x08, 	/* ....*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x1B */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x30, 	/* ..**.... */
	0x7f, 	/* .******* */
	0xff, 	/* ******** */
	0x7f, 	/* .******* */
	0x30, 	/* ..**.... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x1C */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x33, 	/* ..**..** */
	0x66, 	/* .**..**. */
	0xee, 	/* ***.***. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x1D */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x24, 	/* ..*..*.. */
	0x66, 	/* .**..**. */
	0xff, 	/* ******** */
	0x66, 	/* .**..**. */
	0x24, 	/* ..*..*.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x1E */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x7e, 	/* .******. */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x1F */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x7e, 	/* .******. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/*   */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ! */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* " */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x77, 	/* .***.*** */
	0x66, 	/* .**..**. */
	0xcc, 	/* **..**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* # */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0xfe, 	/* *******. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0xfe, 	/* *******. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* $ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x7c, 	/* .*****.. */
	0xd6, 	/* **.*.**. */
	0xd0, 	/* **.*.... */
	0xd0, 	/* **.*.... */
	0x7c, 	/* .*****.. */
	0x16, 	/* ...*.**. */
	0x16, 	/* ...*.**. */
	0xd6, 	/* **.*.**. */
	0x7c, 	/* .*****.. */
	0x10, 	/* ...*.... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* % */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc4, 	/* **...*.. */
	0x0c, 	/* ....**.. */
	0x08, 	/* ....*... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x20, 	/* ..*..... */
	0x60, 	/* .**..... */
	0x46, 	/* .*...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* & */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0x76, 	/* .***.**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ' */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1c, 	/* ...***.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ( */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ) */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* * */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0xff, 	/* ******** */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* + */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* , */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1c, 	/* ...***.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* - */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* . */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* / */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x04, 	/* .....*.. */
	0x0c, 	/* ....**.. */
	0x08, 	/* ....*... */
	0x18, 	/* ...**... */
	0x10, 	/* ...*.... */
	0x30, 	/* ..**.... */
	0x20, 	/* ..*..... */
	0x60, 	/* .**..... */
	0x40, 	/* .*...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 1 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 2 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 3 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x3c, 	/* ..****.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 4 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x1c, 	/* ...***.. */
	0x3c, 	/* ..****.. */
	0x6c, 	/* .**.**.. */
	0xcc, 	/* **..**.. */
	0xfe, 	/* *******. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 5 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 6 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 7 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 8 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 9 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* : */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ; */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* < */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* = */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* > */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ? */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x1c, 	/* ...***.. */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* @ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xde, 	/* **.****. */
	0xde, 	/* **.****. */
	0xde, 	/* **.****. */
	0xde, 	/* **.****. */
	0xdc, 	/* **.***.. */
	0xc0, 	/* **...... */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* A */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* B */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* C */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* D */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xcc, 	/* **..**.. */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* E */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* F */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* G */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xce, 	/* **..***. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* H */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* I */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* J */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1e, 	/* ...****. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0x78, 	/* .****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* K */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xcc, 	/* **..**.. */
	0xd8, 	/* **.**... */
	0xf0, 	/* ****.... */
	0xe0, 	/* ***..... */
	0xe0, 	/* ***..... */
	0xf0, 	/* ****.... */
	0xd8, 	/* **.**... */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* L */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* M */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xee, 	/* ***.***. */
	0xfe, 	/* *******. */
	0xfe, 	/* *******. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* N */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xe6, 	/* ***..**. */
	0xf6, 	/* ****.**. */
	0xfe, 	/* *******. */
	0xde, 	/* **.****. */
	0xce, 	/* **..***. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* O */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* P */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* Q */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xf6, 	/* ****.**. */
	0xde, 	/* **.****. */
	0x7c, 	/* .*****.. */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* R */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xd8, 	/* **.**... */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* S */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0x60, 	/* .**..... */
	0x38, 	/* ..***... */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* T */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* U */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* V */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* W */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xfe, 	/* *******. */
	0xee, 	/* ***.***. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* X */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* Y */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* Z */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* [ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* \ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0x40, 	/* .*...... */
	0x60, 	/* .**..... */
	0x20, 	/* ..*..... */
	0x30, 	/* ..**.... */
	0x10, 	/* ...*.... */
	0x18, 	/* ...**... */
	0x08, 	/* ....*... */
	0x0c, 	/* ....**.. */
	0x04, 	/* .....*.. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ] */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x0c, 	/* ....**.. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ^ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* _ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ` */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* a */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* b */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* c */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* d */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* e */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* f */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xf0, 	/* ****.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* g */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */

	/* h */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* i */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* j */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */

	/* k */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0xcc, 	/* **..**.. */
	0xd8, 	/* **.**... */
	0xf0, 	/* ****.... */
	0xd8, 	/* **.**... */
	0xcc, 	/* **..**.. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* l */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* m */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xec, 	/* ***.**.. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* n */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* o */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* p */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */

	/* q */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */

	/* r */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* s */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc0, 	/* **...... */
	0x70, 	/* .***.... */
	0x1c, 	/* ...***.. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* t */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0xfc, 	/* ******.. */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x30, 	/* ..**.... */
	0x1c, 	/* ...***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* u */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* v */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x10, 	/* ...*.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* w */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xd6, 	/* **.*.**. */
	0xd6, 	/* **.*.**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* x */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* y */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */

	/* z */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* { */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0e, 	/* ....***. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x0e, 	/* ....***. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* | */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* } */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x70, 	/* .***.... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* ~ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x7F */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x80 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x98, 	/* *..**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */

	/* 0x81 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x82 */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x83 */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x84 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x85 */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x86 */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x87 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x38, 	/* ..***... */
	0x98, 	/* *..**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */

	/* 0x88 */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x89 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x8A */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x8B */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x8C */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x8D */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x8E */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x10, 	/* ...*.... */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x8F */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x90 */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfc, 	/* ******.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x91 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xdb, 	/* **.**.** */
	0x1b, 	/* ...**.** */
	0x7f, 	/* .******* */
	0xd8, 	/* **.**... */
	0xdb, 	/* **.**.** */
	0x6e, 	/* .**.***. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x92 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3f, 	/* ..****** */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x6c, 	/* .**.**.. */
	0x6f, 	/* .**.**** */
	0x6c, 	/* .**.**.. */
	0x7c, 	/* .*****.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcf, 	/* **..**** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x93 */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x94 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x95 */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x96 */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x97 */
	0x00, 	/* ........ */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x98 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */

	/* 0x99 */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x9A */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x9B */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0xc3, 	/* **....** */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc3, 	/* **....** */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x9C */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x60, 	/* .**..... */
	0xf0, 	/* ****.... */
	0x60, 	/* .**..... */
	0xf0, 	/* ****.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x66, 	/* .**..**. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x9D */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x9E */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xcf, 	/* **..**** */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x07, 	/* .....*** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0x9F */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0e, 	/* ....***. */
	0x1b, 	/* ...**.** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x3c, 	/* ..****.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xd8, 	/* **.**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xA0 */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xA1 */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xA2 */
	0x00, 	/* ........ */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xA3 */
	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xA4 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xA5 */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0xc6, 	/* **...**. */
	0xe6, 	/* ***..**. */
	0xf6, 	/* ****.**. */
	0xfe, 	/* *******. */
	0xde, 	/* **.****. */
	0xce, 	/* **..***. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xA6 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xA7 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xA8 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x70, 	/* .***.... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xA9 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xAA */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x06, 	/* .....**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xAB */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x2c, 	/* ..*.**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xAC */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x38, 	/* ..***... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x38, 	/* ..***... */
	0x68, 	/* .**.*... */
	0x7c, 	/* .*****.. */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xAD */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xAE */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x36, 	/* ..**.**. */
	0x6c, 	/* .**.**.. */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0x6c, 	/* .**.**.. */
	0x36, 	/* ..**.**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xAF */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xd8, 	/* **.**... */
	0x6c, 	/* .**.**.. */
	0x36, 	/* ..**.**. */
	0x36, 	/* ..**.**. */
	0x6c, 	/* .**.**.. */
	0xd8, 	/* **.**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xB0 */
	0x82, 	/* *.....*. */
	0x10, 	/* ...*.... */
	0x82, 	/* *.....*. */
	0x10, 	/* ...*.... */
	0x82, 	/* *.....*. */
	0x10, 	/* ...*.... */
	0x82, 	/* *.....*. */
	0x10, 	/* ...*.... */
	0x82, 	/* *.....*. */
	0x10, 	/* ...*.... */
	0x82, 	/* *.....*. */
	0x10, 	/* ...*.... */
	0x82, 	/* *.....*. */
	0x10, 	/* ...*.... */
	0x82, 	/* *.....*. */
	0x10, 	/* ...*.... */

	/* 0xB1 */
	0x00, 	/* ........ */
	0x95, 	/* *..*.*.* */
	0x00, 	/* ........ */
	0xa9, 	/* *.*.*..* */
	0x00, 	/* ........ */
	0x95, 	/* *..*.*.* */
	0x00, 	/* ........ */
	0xa9, 	/* *.*.*..* */
	0x00, 	/* ........ */
	0x95, 	/* *..*.*.* */
	0x00, 	/* ........ */
	0xa9, 	/* *.*.*..* */
	0x00, 	/* ........ */
	0x95, 	/* *..*.*.* */
	0x00, 	/* ........ */
	0xa9, 	/* *.*.*..* */

	/* 0xB2 */
	0x92, 	/* *..*..*. */
	0x49, 	/* .*..*..* */
	0x92, 	/* *..*..*. */
	0x49, 	/* .*..*..* */
	0x92, 	/* *..*..*. */
	0x49, 	/* .*..*..* */
	0x92, 	/* *..*..*. */
	0x49, 	/* .*..*..* */
	0x92, 	/* *..*..*. */
	0x49, 	/* .*..*..* */
	0x92, 	/* *..*..*. */
	0x49, 	/* .*..*..* */
	0x92, 	/* *..*..*. */
	0x49, 	/* .*..*..* */
	0x92, 	/* *..*..*. */
	0x49, 	/* .*..*..* */

	/* 0xB3 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xB4 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xf8, 	/* *****... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xB5 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xf8, 	/* *****... */
	0xf8, 	/* *****... */
	0xf8, 	/* *****... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xB6 */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0xfc, 	/* ******.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xB7 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xB8 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0xf8, 	/* *****... */
	0xf8, 	/* *****... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xB9 */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0xfc, 	/* ******.. */
	0xfc, 	/* ******.. */
	0xfc, 	/* ******.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xBA */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xBB */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfc, 	/* ******.. */
	0xfc, 	/* ******.. */
	0xfc, 	/* ******.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xBC */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0xfc, 	/* ******.. */
	0xfc, 	/* ******.. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xBD */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xBE */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xf8, 	/* *****... */
	0xf8, 	/* *****... */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xBF */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xf8, 	/* *****... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xC0 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1f, 	/* ...***** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xC1 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xC2 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xC3 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1f, 	/* ...***** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xC4 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xC5 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xff, 	/* ******** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xC6 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1f, 	/* ...***** */
	0x1f, 	/* ...***** */
	0x1f, 	/* ...***** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xC7 */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3f, 	/* ..****** */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xC8 */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3f, 	/* ..****** */
	0x3f, 	/* ..****** */
	0x3f, 	/* ..****** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xC9 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3f, 	/* ..****** */
	0x3f, 	/* ..****** */
	0x3f, 	/* ..****** */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xCA */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xCB */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xCC */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3f, 	/* ..****** */
	0x3f, 	/* ..****** */
	0x3f, 	/* ..****** */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xCD */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xCE */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xCF */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xD0 */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xD1 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xD2 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xD3 */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3f, 	/* ..****** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xD4 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x1f, 	/* ...***** */
	0x1f, 	/* ...***** */
	0x1f, 	/* ...***** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xD5 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1f, 	/* ...***** */
	0x1f, 	/* ...***** */
	0x1f, 	/* ...***** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xD6 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3f, 	/* ..****** */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xD7 */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0xff, 	/* ******** */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */
	0x3c, 	/* ..****.. */

	/* 0xD8 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xD9 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xf8, 	/* *****... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xDA */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1f, 	/* ...***** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xDB */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */

	/* 0xDC */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */

	/* 0xDD */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */
	0xf0, 	/* ****.... */

	/* 0xDE */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */
	0x0f, 	/* ....**** */

	/* 0xDF */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0xff, 	/* ******** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xE0 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x77, 	/* .***.*** */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xcc, 	/* **..**.. */
	0xde, 	/* **.****. */
	0x73, 	/* .***..** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xE1 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc4, 	/* **...*.. */
	0xc8, 	/* **..*... */
	0xc4, 	/* **...*.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xdc, 	/* **.***.. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xE2 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xE3 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x03, 	/* ......** */
	0x7e, 	/* .******. */
	0xec, 	/* ***.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x68, 	/* .**.*... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xE4 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xE5 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7f, 	/* .******* */
	0xf0, 	/* ****.... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xE6 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x7c, 	/* .*****.. */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */

	/* 0xE7 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xE8 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0xdb, 	/* **.**.** */
	0xdb, 	/* **.**.** */
	0xdb, 	/* **.**.** */
	0xdb, 	/* **.**.** */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xE9 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xfe, 	/* *******. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xEA */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x3c, 	/* ..****.. */
	0x66, 	/* .**..**. */
	0xc3, 	/* **....** */
	0xc3, 	/* **....** */
	0xc3, 	/* **....** */
	0xc3, 	/* **....** */
	0x66, 	/* .**..**. */
	0x24, 	/* ..*..*.. */
	0xa5, 	/* *.*..*.* */
	0xe7, 	/* ***..*** */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xEB */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1e, 	/* ...****. */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x3e, 	/* ..*****. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x66, 	/* .**..**. */
	0x3c, 	/* ..****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xEC */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0xdb, 	/* **.**.** */
	0xdb, 	/* **.**.** */
	0xdb, 	/* **.**.** */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xED */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x03, 	/* ......** */
	0x06, 	/* .....**. */
	0x7e, 	/* .******. */
	0xcf, 	/* **..**** */
	0xdb, 	/* **.**.** */
	0xf3, 	/* ****..** */
	0x7e, 	/* .******. */
	0x60, 	/* .**..... */
	0xc0, 	/* **...... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xEE */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x1c, 	/* ...***.. */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x7c, 	/* .*****.. */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x1c, 	/* ...***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xEF */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0xc6, 	/* **...**. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xF0 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xfe, 	/* *******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xF1 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x7e, 	/* .******. */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xF2 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x06, 	/* .....**. */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xF3 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0c, 	/* ....**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0x30, 	/* ..**.... */
	0x18, 	/* ...**... */
	0x0c, 	/* ....**.. */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xF4 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x0e, 	/* ....***. */
	0x1b, 	/* ...**.** */
	0x1b, 	/* ...**.** */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */

	/* 0xF5 */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0xd8, 	/* **.**... */
	0xd8, 	/* **.**... */
	0x70, 	/* .***.... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xF6 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x7e, 	/* .******. */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xF7 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0x76, 	/* .***.**. */
	0xdc, 	/* **.***.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xF8 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x38, 	/* ..***... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x38, 	/* ..***... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xF9 */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xFA */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x18, 	/* ...**... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xFB */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x03, 	/* ......** */
	0x02, 	/* ......*. */
	0x06, 	/* .....**. */
	0x04, 	/* .....*.. */
	0x0c, 	/* ....**.. */
	0x08, 	/* ....*... */
	0xd8, 	/* **.**... */
	0x50, 	/* .*.*.... */
	0x70, 	/* .***.... */
	0x20, 	/* ..*..... */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xFC */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0xd8, 	/* **.**... */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x6c, 	/* .**.**.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xFD */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x78, 	/* .****... */
	0xcc, 	/* **..**.. */
	0x18, 	/* ...**... */
	0x30, 	/* ..**.... */
	0x60, 	/* .**..... */
	0xfc, 	/* ******.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */

	/* 0xFE */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x7c, 	/* .*****.. */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
	0x00, 	/* ........ */
};
