/* $NetBSD: sunos_syscallargs.h,v 1.56 2005/02/26 23:58:20 perry Exp $ */

/*
 * System call argument lists.
 *
 * DO NOT EDIT-- this file is automatically generated.
 * created from	NetBSD: syscalls.master,v 1.61 2005/02/26 23:10:21 perry Exp
 */

#ifndef _SUNOS_SYS__SYSCALLARGS_H_
#define	_SUNOS_SYS__SYSCALLARGS_H_

#ifdef	syscallarg
#undef	syscallarg
#endif

#define	syscallarg(x)							\
	union {								\
		register_t pad;						\
		struct { x datum; } le;					\
		struct { /* LINTED zero array dimension */		\
			int8_t pad[  /* CONSTCOND */			\
				(sizeof (register_t) < sizeof (x))	\
				? 0					\
				: sizeof (register_t) - sizeof (x)];	\
			x datum;					\
		} be;							\
	}

struct sunos_sys_open_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
	syscallarg(int) mode;
};

struct sunos_sys_wait4_args {
	syscallarg(int) pid;
	syscallarg(int *) status;
	syscallarg(int) options;
	syscallarg(struct rusage *) rusage;
};

struct sunos_sys_creat_args {
	syscallarg(const char *) path;
	syscallarg(int) mode;
};

struct sunos_sys_execv_args {
	syscallarg(const char *) path;
	syscallarg(char **) argp;
};

struct sunos_sys_mknod_args {
	syscallarg(const char *) path;
	syscallarg(int) mode;
	syscallarg(int) dev;
};

struct sunos_sys_stime_args {
	syscallarg(time_t *) tp;
};

struct sunos_sys_ptrace_args {
	syscallarg(int) req;
	syscallarg(pid_t) pid;
	syscallarg(caddr_t) addr;
	syscallarg(int) data;
	syscallarg(char *) addr2;
};

struct sunos_sys_access_args {
	syscallarg(const char *) path;
	syscallarg(int) flags;
};

struct sunos_sys_stat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat43 *) ub;
};

struct sunos_sys_lstat_args {
	syscallarg(const char *) path;
	syscallarg(struct stat43 *) ub;
};

struct sunos_sys_mctl_args {
	syscallarg(void *) addr;
	syscallarg(int) len;
	syscallarg(int) func;
	syscallarg(void *) arg;
};

struct sunos_sys_ioctl_args {
	syscallarg(int) fd;
	syscallarg(u_long) com;
	syscallarg(caddr_t) data;
};

struct sunos_sys_reboot_args {
	syscallarg(int) howto;
	syscallarg(char *) bootstr;
};

struct sunos_sys_execve_args {
	syscallarg(const char *) path;
	syscallarg(char **) argp;
	syscallarg(char **) envp;
};

struct sunos_sys_omsync_args {
	syscallarg(caddr_t) addr;
	syscallarg(size_t) len;
	syscallarg(int) flags;
};

struct sunos_sys_mmap_args {
	syscallarg(void *) addr;
	syscallarg(size_t) len;
	syscallarg(int) prot;
	syscallarg(int) flags;
	syscallarg(int) fd;
	syscallarg(long) pos;
};

struct sunos_sys_setpgrp_args {
	syscallarg(int) pid;
	syscallarg(int) pgid;
};

struct sunos_sys_fcntl_args {
	syscallarg(int) fd;
	syscallarg(int) cmd;
	syscallarg(void *) arg;
};

struct sunos_sys_socket_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
};

struct sunos_sys_setsockopt_args {
	syscallarg(int) s;
	syscallarg(int) level;
	syscallarg(int) name;
	syscallarg(caddr_t) val;
	syscallarg(int) valsize;
};

struct sunos_sys_sigvec_args {
	syscallarg(int) signum;
	syscallarg(struct sigvec *) nsv;
	syscallarg(struct sigvec *) osv;
};

struct sunos_sys_sigsuspend_args {
	syscallarg(int) mask;
};

struct sunos_sys_socketpair_args {
	syscallarg(int) domain;
	syscallarg(int) type;
	syscallarg(int) protocol;
	syscallarg(int *) rsv;
};

struct sunos_sys_sigreturn_args {
	syscallarg(struct sigcontext *) sigcntxp;
};

struct sunos_sys_getrlimit_args {
	syscallarg(u_int) which;
	syscallarg(struct orlimit *) rlp;
};

struct sunos_sys_setrlimit_args {
	syscallarg(u_int) which;
	syscallarg(struct orlimit *) rlp;
};
#ifdef NFSSERVER

struct sunos_sys_nfssvc_args {
	syscallarg(int) fd;
};
#else
#endif

struct sunos_sys_statfs_args {
	syscallarg(const char *) path;
	syscallarg(struct sunos_statfs *) buf;
};

struct sunos_sys_fstatfs_args {
	syscallarg(int) fd;
	syscallarg(struct sunos_statfs *) buf;
};

struct sunos_sys_unmount_args {
	syscallarg(char *) path;
};
#ifdef NFS
#else
#endif

struct sunos_sys_quotactl_args {
	syscallarg(int) cmd;
	syscallarg(char *) special;
	syscallarg(int) uid;
	syscallarg(caddr_t) addr;
};

struct sunos_sys_exportfs_args {
	syscallarg(char *) path;
	syscallarg(char *) ex;
};

struct sunos_sys_mount_args {
	syscallarg(char *) type;
	syscallarg(char *) dir;
	syscallarg(int) flags;
	syscallarg(caddr_t) data;
};

struct sunos_sys_ustat_args {
	syscallarg(int) dev;
	syscallarg(struct sunos_ustat *) buf;
};
#ifdef SYSVSEM
#else
#endif
#ifdef SYSVMSG
#else
#endif
#ifdef SYSVSHM
#else
#endif

struct sunos_sys_auditsys_args {
	syscallarg(char *) record;
};

struct sunos_sys_getdents_args {
	syscallarg(int) fd;
	syscallarg(char *) buf;
	syscallarg(int) nbytes;
};

struct sunos_sys_sigpending_args {
	syscallarg(int *) mask;
};

struct sunos_sys_sysconf_args {
	syscallarg(int) name;
};

struct sunos_sys_uname_args {
	syscallarg(struct sunos_utsname *) name;
};

/*
 * System call prototypes.
 */

int	sys_nosys(struct lwp *, void *, register_t *);

int	sys_exit(struct lwp *, void *, register_t *);

int	sys_fork(struct lwp *, void *, register_t *);

int	sys_read(struct lwp *, void *, register_t *);

int	sys_write(struct lwp *, void *, register_t *);

int	sunos_sys_open(struct lwp *, void *, register_t *);

int	sys_close(struct lwp *, void *, register_t *);

int	sunos_sys_wait4(struct lwp *, void *, register_t *);

int	sunos_sys_creat(struct lwp *, void *, register_t *);

int	sys_link(struct lwp *, void *, register_t *);

int	sys_unlink(struct lwp *, void *, register_t *);

int	sunos_sys_execv(struct lwp *, void *, register_t *);

int	sys_chdir(struct lwp *, void *, register_t *);

int	sunos_sys_mknod(struct lwp *, void *, register_t *);

int	sys_chmod(struct lwp *, void *, register_t *);

int	sys_chown(struct lwp *, void *, register_t *);

int	sys_obreak(struct lwp *, void *, register_t *);

int	compat_43_sys_lseek(struct lwp *, void *, register_t *);

int	sys_getpid_with_ppid(struct lwp *, void *, register_t *);

int	sys_setuid(struct lwp *, void *, register_t *);

int	sys_getuid_with_euid(struct lwp *, void *, register_t *);

int	sunos_sys_stime(struct lwp *, void *, register_t *);

int	sunos_sys_ptrace(struct lwp *, void *, register_t *);

int	sunos_sys_access(struct lwp *, void *, register_t *);

int	sys_sync(struct lwp *, void *, register_t *);

int	sys_kill(struct lwp *, void *, register_t *);

int	sunos_sys_stat(struct lwp *, void *, register_t *);

int	sunos_sys_lstat(struct lwp *, void *, register_t *);

int	sys_dup(struct lwp *, void *, register_t *);

int	sys_pipe(struct lwp *, void *, register_t *);

int	sys_profil(struct lwp *, void *, register_t *);

int	sys_setgid(struct lwp *, void *, register_t *);

int	sys_getgid_with_egid(struct lwp *, void *, register_t *);

int	sys_acct(struct lwp *, void *, register_t *);

int	sunos_sys_mctl(struct lwp *, void *, register_t *);

int	sunos_sys_ioctl(struct lwp *, void *, register_t *);

int	sunos_sys_reboot(struct lwp *, void *, register_t *);

int	sys_symlink(struct lwp *, void *, register_t *);

int	sys_readlink(struct lwp *, void *, register_t *);

int	sunos_sys_execve(struct lwp *, void *, register_t *);

int	sys_umask(struct lwp *, void *, register_t *);

int	sys_chroot(struct lwp *, void *, register_t *);

int	compat_43_sys_fstat(struct lwp *, void *, register_t *);

int	compat_43_sys_getpagesize(struct lwp *, void *, register_t *);

int	sunos_sys_omsync(struct lwp *, void *, register_t *);

int	sys_vfork(struct lwp *, void *, register_t *);

int	sys_sbrk(struct lwp *, void *, register_t *);

int	sys_sstk(struct lwp *, void *, register_t *);

int	sunos_sys_mmap(struct lwp *, void *, register_t *);

int	sys_ovadvise(struct lwp *, void *, register_t *);

int	sys_munmap(struct lwp *, void *, register_t *);

int	sys_mprotect(struct lwp *, void *, register_t *);

int	sys_madvise(struct lwp *, void *, register_t *);

int	sunos_sys_vhangup(struct lwp *, void *, register_t *);

int	sys_mincore(struct lwp *, void *, register_t *);

int	sys_getgroups(struct lwp *, void *, register_t *);

int	sys_setgroups(struct lwp *, void *, register_t *);

int	sys_getpgrp(struct lwp *, void *, register_t *);

int	sunos_sys_setpgrp(struct lwp *, void *, register_t *);

int	sys_setitimer(struct lwp *, void *, register_t *);

int	compat_12_sys_swapon(struct lwp *, void *, register_t *);

int	sys_getitimer(struct lwp *, void *, register_t *);

int	compat_43_sys_gethostname(struct lwp *, void *, register_t *);

int	compat_43_sys_sethostname(struct lwp *, void *, register_t *);

int	compat_43_sys_getdtablesize(struct lwp *, void *, register_t *);

int	sys_dup2(struct lwp *, void *, register_t *);

int	sunos_sys_fcntl(struct lwp *, void *, register_t *);

int	sys_select(struct lwp *, void *, register_t *);

int	sys_fsync(struct lwp *, void *, register_t *);

int	sys_setpriority(struct lwp *, void *, register_t *);

int	sunos_sys_socket(struct lwp *, void *, register_t *);

int	sys_connect(struct lwp *, void *, register_t *);

int	compat_43_sys_accept(struct lwp *, void *, register_t *);

int	sys_getpriority(struct lwp *, void *, register_t *);

int	compat_43_sys_send(struct lwp *, void *, register_t *);

int	compat_43_sys_recv(struct lwp *, void *, register_t *);

int	sys_bind(struct lwp *, void *, register_t *);

int	sunos_sys_setsockopt(struct lwp *, void *, register_t *);

int	sys_listen(struct lwp *, void *, register_t *);

int	sunos_sys_sigvec(struct lwp *, void *, register_t *);

int	compat_43_sys_sigblock(struct lwp *, void *, register_t *);

int	compat_43_sys_sigsetmask(struct lwp *, void *, register_t *);

int	sunos_sys_sigsuspend(struct lwp *, void *, register_t *);

int	compat_43_sys_sigstack(struct lwp *, void *, register_t *);

int	compat_43_sys_recvmsg(struct lwp *, void *, register_t *);

int	compat_43_sys_sendmsg(struct lwp *, void *, register_t *);

int	sys_gettimeofday(struct lwp *, void *, register_t *);

int	sys_getrusage(struct lwp *, void *, register_t *);

int	sys_getsockopt(struct lwp *, void *, register_t *);

int	sys_readv(struct lwp *, void *, register_t *);

int	sys_writev(struct lwp *, void *, register_t *);

int	sys_settimeofday(struct lwp *, void *, register_t *);

int	sys_fchown(struct lwp *, void *, register_t *);

int	sys_fchmod(struct lwp *, void *, register_t *);

int	compat_43_sys_recvfrom(struct lwp *, void *, register_t *);

int	sys_setreuid(struct lwp *, void *, register_t *);

int	sys_setregid(struct lwp *, void *, register_t *);

int	sys_rename(struct lwp *, void *, register_t *);

int	compat_43_sys_truncate(struct lwp *, void *, register_t *);

int	compat_43_sys_ftruncate(struct lwp *, void *, register_t *);

int	sys_flock(struct lwp *, void *, register_t *);

int	sys_sendto(struct lwp *, void *, register_t *);

int	sys_shutdown(struct lwp *, void *, register_t *);

int	sunos_sys_socketpair(struct lwp *, void *, register_t *);

int	sys_mkdir(struct lwp *, void *, register_t *);

int	sys_rmdir(struct lwp *, void *, register_t *);

int	sys_utimes(struct lwp *, void *, register_t *);

int	sunos_sys_sigreturn(struct lwp *, void *, register_t *);

int	sys_adjtime(struct lwp *, void *, register_t *);

int	compat_43_sys_getpeername(struct lwp *, void *, register_t *);

int	compat_43_sys_gethostid(struct lwp *, void *, register_t *);

int	sunos_sys_getrlimit(struct lwp *, void *, register_t *);

int	sunos_sys_setrlimit(struct lwp *, void *, register_t *);

int	compat_43_sys_killpg(struct lwp *, void *, register_t *);

int	compat_43_sys_getsockname(struct lwp *, void *, register_t *);

int	sys_poll(struct lwp *, void *, register_t *);

#ifdef NFSSERVER
int	sunos_sys_nfssvc(struct lwp *, void *, register_t *);

#else
#endif
int	compat_12_sys_getdirentries(struct lwp *, void *, register_t *);

int	sunos_sys_statfs(struct lwp *, void *, register_t *);

int	sunos_sys_fstatfs(struct lwp *, void *, register_t *);

int	sunos_sys_unmount(struct lwp *, void *, register_t *);

#ifdef NFS
int	async_daemon(struct lwp *, void *, register_t *);

int	sys_getfh(struct lwp *, void *, register_t *);

#else
#endif
int	compat_09_sys_getdomainname(struct lwp *, void *, register_t *);

int	compat_09_sys_setdomainname(struct lwp *, void *, register_t *);

int	sunos_sys_quotactl(struct lwp *, void *, register_t *);

int	sunos_sys_exportfs(struct lwp *, void *, register_t *);

int	sunos_sys_mount(struct lwp *, void *, register_t *);

int	sunos_sys_ustat(struct lwp *, void *, register_t *);

#ifdef SYSVSEM
int	compat_10_sys_semsys(struct lwp *, void *, register_t *);

#else
#endif
#ifdef SYSVMSG
int	compat_10_sys_msgsys(struct lwp *, void *, register_t *);

#else
#endif
#ifdef SYSVSHM
int	compat_10_sys_shmsys(struct lwp *, void *, register_t *);

#else
#endif
int	sunos_sys_auditsys(struct lwp *, void *, register_t *);

int	sunos_sys_getdents(struct lwp *, void *, register_t *);

int	sys_setsid(struct lwp *, void *, register_t *);

int	sys_fchdir(struct lwp *, void *, register_t *);

int	sys_fchroot(struct lwp *, void *, register_t *);

int	sunos_sys_sigpending(struct lwp *, void *, register_t *);

int	sys_setpgid(struct lwp *, void *, register_t *);

int	sys_pathconf(struct lwp *, void *, register_t *);

int	sys_fpathconf(struct lwp *, void *, register_t *);

int	sunos_sys_sysconf(struct lwp *, void *, register_t *);

int	sunos_sys_uname(struct lwp *, void *, register_t *);

#endif /* _SUNOS_SYS__SYSCALLARGS_H_ */
