#	from: @(#)Makefile.inc	5.7 (Berkeley) 6/27/91
#	$NetBSD: Makefile.inc,v 1.28 2004/05/10 17:02:21 drochner Exp $

# stdio sources
.PATH: ${.CURDIR}/stdio

CPPFLAGS+=-DFLOATING_POINT

SRCS+=	asprintf.c clrerr.c fclose.c fdopen.c feof.c ferror.c fflush.c \
	fgetc.c fgetln.c fgetpos.c fgets.c fileno.c findfp.c flags.c \
	flockfile.c fopen.c fprintf.c fpurge.c fputc.c fputs.c fread.c \
	freopen.c fscanf.c fseek.c fseeko.c fsetpos.c ftell.c ftello.c \
	funopen.c fvwrite.c fwalk.c fwrite.c getc.c getchar.c gettemp.c \
	getw.c makebuf.c mkdtemp.c mkstemp.c perror.c printf.c putc.c \
	putchar.c puts.c putw.c refill.c remove.c rewind.c rget.c scanf.c \
	setbuf.c setbuffer.c setvbuf.c snprintf.c sscanf.c stdio.c tmpfile.c \
	ungetc.c vasprintf.c vfprintf.c vfscanf.c vprintf.c vscanf.c \
	vsnprintf.c vsscanf.c wbuf.c wsetup.c fputwc.c fputws.c \
	fgetwc.c fgetws.c ungetwc.c putwc.c putwchar.c getwc.c getwchar.c \
	fwide.c fparseln.c fgetstr.c

.if !defined(AUDIT)
SRCS+=	gets.c sprintf.c vsprintf.c tempnam.c tmpnam.c mktemp.c
.endif

# namespace purity wrappers
SRCS+=	_fileno.c _fseeko.c _ftello.c

MAN+=	fclose.3 ferror.3 fflush.3 fgetln.3 fgets.3 flockfile.3 fopen.3 \
	fputs.3 fread.3 fseek.3 funopen.3 getc.3 mktemp.3 perror.3 printf.3 \
	putc.3 remove.3 scanf.3 setbuf.3 stdio.3 tmpnam.3 ungetc.3 putwc.3 \
	getwc.3 ungetwc.3 fwide.3 fparseln.3 fgetws.3 fputws.3

MLINKS+=ferror.3 clearerr.3 ferror.3 feof.3 ferror.3 fileno.3
MLINKS+=fflush.3 fpurge.3
MLINKS+=flockfile.3 ftrylockfile.3 flockfile.3 funlockfile.3
MLINKS+=fgets.3 gets.3
MLINKS+=fopen.3 fdopen.3 fopen.3 freopen.3
MLINKS+=fputs.3 puts.3
MLINKS+=fread.3 fwrite.3
MLINKS+=fseek.3 fgetpos.3 fseek.3 fseeko.3 fseek.3 fsetpos.3 fseek.3 ftell.3 \
	fseek.3 ftello.3 fseek.3 rewind.3
MLINKS+=funopen.3 fropen.3 funopen.3 fwopen.3
MLINKS+=getc.3 fgetc.3 getc.3 getc_unlocked.3 getc.3 getchar.3 \
	getc.3 getchar_unlocked.3 getc.3 getw.3
MLINKS+=mktemp.3 mkdtemp.3 mktemp.3 mkstemp.3
MLINKS+=printf.3 asprintf.3 printf.3 fprintf.3 printf.3 snprintf.3 \
	printf.3 sprintf.3 printf.3 vasprintf.3 printf.3 vfprintf.3 \
	printf.3 vprintf.3 printf.3 vsnprintf.3 printf.3 vsprintf.3 
MLINKS+=putc.3 fputc.3 putc.3 putc_unlocked.3 putc.3 putchar.3 \
	putc.3 putchar_unlocked.3 putc.3 putw.3
MLINKS+=scanf.3 fscanf.3 scanf.3 sscanf.3 scanf.3 vfscanf.3 scanf.3 vscanf.3 \
	scanf.3 vsscanf.3
MLINKS+=setbuf.3 setbuffer.3 setbuf.3 setlinebuf.3 setbuf.3 setvbuf.3
MLINKS+=tmpnam.3 tempnam.3 tmpnam.3 tmpfile.3
MLINKS+=putwc.3 fputwc.3 putwc.3 putwchar.3
MLINKS+=getwc.3 fgetwc.3 getwc.3 getwchar.3
