/* tables.c

   Tables of information... */

/*
 * Copyright (c) 1995-2002 Internet Software Consortium.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of The Internet Software Consortium nor the names
 *    of its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INTERNET SOFTWARE CONSORTIUM AND
 * CONTRIBUTORS ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE INTERNET SOFTWARE CONSORTIUM OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This software has been written for the Internet Software Consortium
 * by Ted Lemon in cooperation with Vixie Enterprises and Nominum, Inc.
 * To learn more about the Internet Software Consortium, see
 * ``http://www.isc.org/''.  To learn more about Vixie Enterprises,
 * see ``http://www.vix.com''.   To learn more about Nominum, Inc., see
 * ``http://www.nominum.com''.
 */

#ifndef lint
static char copyright[] =
"$Id: tables.c,v 1.4 2003/02/18 17:08:41 drochner Exp $ Copyright (c) 1995-2002 The Internet Software Consortium.  All rights reserved.\n";
#endif /* not lint */

#include "dhcpd.h"

/* XXXDPN: Moved here from hash.c, when it moved to libomapi.  Not sure
   where these really belong. */
HASH_FUNCTIONS (group, const char *, struct group_object, group_hash_t,
		group_reference, group_dereference)
HASH_FUNCTIONS (universe, const char *, struct universe, universe_hash_t, 0, 0)
HASH_FUNCTIONS (option, const char *, struct option, option_hash_t, 0, 0)

/* DHCP Option names, formats and codes, from RFC1533.

   Format codes:

   I - IP address
   l - 32-bit signed integer
   L - 32-bit unsigned integer
   s - 16-bit signed integer
   S - 16-bit unsigned integer
   b - 8-bit signed integer
   B - 8-bit unsigned integer
   t - ASCII text
   f - flag (true or false)
   A - array of whatever precedes (e.g., IA means array of IP addresses)
   a - array of the preceding character (e.g., IIa means two or more IP
       addresses)
   U - name of an option space (universe)
   F - implicit flag - the presence of the option indicates that the
       flag is true.
   o - the preceding value is optional.
   E - encapsulation, string or colon-seperated hex list (the latter
       two for parsing).   E is followed by a text string containing
       the name of the option space to encapsulate, followed by a '.'.
       If the E is immediately followed by '.', the applicable vendor
       option space is used if one is defined.
   e - If an encapsulation directive is not the first thing in the string,
       the option scanner requires an efficient way to find the encapsulation.
       This is done by placing a 'e' at the beginning of the option.   The
       'e' has no other purpose, and is not required if 'E' is the first
       thing in the option.
   X - either an ASCII string or binary data.   On output, the string is
       scanned to see if it's printable ASCII and, if so, output as a
       quoted string.   If not, it's output as colon-seperated hex.   On
       input, the option can be specified either as a quoted string or as
       a colon-seperated hex list.
   N - enumeration.   N is followed by a text string containing
       the name of the set of enumeration values to parse or emit,
       followed by a '.'.   The width of the data is specified in the
       named enumeration.   Named enumerations are tracked in parse.c.
   d - Domain name (i.e., FOO or FOO.BAR).
*/

struct universe dhcp_universe;
struct option dhcp_options [256] = {
	{ "pad", "",					&dhcp_universe, 0 },
	{ "subnet-mask", "I",				&dhcp_universe, 1 },
	{ "time-offset", "l",				&dhcp_universe, 2 },
	{ "routers", "IA",				&dhcp_universe, 3 },
	{ "time-servers", "IA",				&dhcp_universe, 4 },
	{ "ien116-name-servers", "IA",			&dhcp_universe, 5 },
	{ "domain-name-servers", "IA",			&dhcp_universe, 6 },
	{ "log-servers", "IA",				&dhcp_universe, 7 },
	{ "cookie-servers", "IA",			&dhcp_universe, 8 },
	{ "lpr-servers", "IA",				&dhcp_universe, 9 },
	{ "impress-servers", "IA",			&dhcp_universe, 10 },
	{ "resource-location-servers", "IA",		&dhcp_universe, 11 },
	{ "host-name", "X",				&dhcp_universe, 12 },
	{ "boot-size", "S",				&dhcp_universe, 13 },
	{ "merit-dump", "t",				&dhcp_universe, 14 },
	{ "domain-name", "t",				&dhcp_universe, 15 },
	{ "swap-server", "I",				&dhcp_universe, 16 },
	{ "root-path", "t",				&dhcp_universe, 17 },
	{ "extensions-path", "t",			&dhcp_universe, 18 },
	{ "ip-forwarding", "f",				&dhcp_universe, 19 },
	{ "non-local-source-routing", "f",		&dhcp_universe, 20 },
	{ "policy-filter", "IIA",			&dhcp_universe, 21 },
	{ "max-dgram-reassembly", "S",			&dhcp_universe, 22 },
	{ "default-ip-ttl", "B",			&dhcp_universe, 23 },
	{ "path-mtu-aging-timeout", "L",		&dhcp_universe, 24 },
	{ "path-mtu-plateau-table", "SA",		&dhcp_universe, 25 },
	{ "interface-mtu", "S",				&dhcp_universe, 26 },
	{ "all-subnets-local", "f",			&dhcp_universe, 27 },
	{ "broadcast-address", "I",			&dhcp_universe, 28 },
	{ "perform-mask-discovery", "f",		&dhcp_universe, 29 },
	{ "mask-supplier", "f",				&dhcp_universe, 30 },
	{ "router-discovery", "f",			&dhcp_universe, 31 },
	{ "router-solicitation-address", "I",		&dhcp_universe, 32 },
	{ "static-routes", "IIA",			&dhcp_universe, 33 },
	{ "trailer-encapsulation", "f",			&dhcp_universe, 34 },
	{ "arp-cache-timeout", "L",			&dhcp_universe, 35 },
	{ "ieee802-3-encapsulation", "f",		&dhcp_universe, 36 },
	{ "default-tcp-ttl", "B",			&dhcp_universe, 37 },
	{ "tcp-keepalive-interval", "L",		&dhcp_universe, 38 },
	{ "tcp-keepalive-garbage", "f",			&dhcp_universe, 39 },
	{ "nis-domain", "t",				&dhcp_universe, 40 },
	{ "nis-servers", "IA",				&dhcp_universe, 41 },
	{ "ntp-servers", "IA",				&dhcp_universe, 42 },
	{ "vendor-encapsulated-options", "E.",		&dhcp_universe, 43 },
	{ "netbios-name-servers", "IA",			&dhcp_universe, 44 },
	{ "netbios-dd-server", "IA",			&dhcp_universe, 45 },
	{ "netbios-node-type", "B",			&dhcp_universe, 46 },
	{ "netbios-scope", "t",				&dhcp_universe, 47 },
	{ "font-servers", "IA",				&dhcp_universe, 48 },
	{ "x-display-manager", "IA",			&dhcp_universe, 49 },
	{ "dhcp-requested-address", "I",		&dhcp_universe, 50 },
	{ "dhcp-lease-time", "L",			&dhcp_universe, 51 },
	{ "dhcp-option-overload", "B",			&dhcp_universe, 52 },
	{ "dhcp-message-type", "B",			&dhcp_universe, 53 },
	{ "dhcp-server-identifier", "I",		&dhcp_universe, 54 },
	{ "dhcp-parameter-request-list", "BA",		&dhcp_universe, 55 },
	{ "dhcp-message", "t",				&dhcp_universe, 56 },
	{ "dhcp-max-message-size", "S",			&dhcp_universe, 57 },
	{ "dhcp-renewal-time", "L",			&dhcp_universe, 58 },
	{ "dhcp-rebinding-time", "L",			&dhcp_universe, 59 },
	{ "vendor-class-identifier", "X",		&dhcp_universe, 60 },
	{ "dhcp-client-identifier", "X",		&dhcp_universe, 61 },
	{ "nwip-domain", "X",				&dhcp_universe, 62 },
	{ "nwip-suboptions", "Enwip.",			&dhcp_universe, 63 },
	{ "nisplus-domain", "t",			&dhcp_universe, 64 },
	{ "nisplus-servers", "IA",			&dhcp_universe, 65 },
	{ "tftp-server-name", "t",			&dhcp_universe, 66 },
	{ "bootfile-name", "t",				&dhcp_universe, 67 },
	{ "mobile-ip-home-agent", "IA",			&dhcp_universe, 68 },
	{ "smtp-server", "IA",				&dhcp_universe, 69 },
	{ "pop-server", "IA",				&dhcp_universe, 70 },
	{ "nntp-server", "IA",				&dhcp_universe, 71 },
	{ "www-server", "IA",				&dhcp_universe, 72 },
	{ "finger-server", "IA",			&dhcp_universe, 73 },
	{ "irc-server", "IA",				&dhcp_universe, 74 },
	{ "streettalk-server", "IA",			&dhcp_universe, 75 },
	{ "streettalk-directory-assistance-server", "IA", &dhcp_universe, 76 },
	{ "user-class", "t",				&dhcp_universe, 77 },
	{ "slp-directory-agent", "fIa",			&dhcp_universe, 78 },
	{ "slp-service-scope", "fto",			&dhcp_universe, 79 },
	{ "#80", "X",					&dhcp_universe, 80 },
	{ "fqdn", "Efqdn.",				&dhcp_universe, 81 },
	{ "relay-agent-information", "Eagent.",		&dhcp_universe, 82 },
	{ "#83", "X",					&dhcp_universe, 83 },
	{ "#84", "X",					&dhcp_universe, 84 },
	{ "nds-servers", "IA",				&dhcp_universe, 85 },
	{ "nds-tree-name", "X",				&dhcp_universe, 86 },
	{ "nds-context", "X",				&dhcp_universe, 87 },
	{ "#88", "X",					&dhcp_universe, 88 },
	{ "#89", "X",					&dhcp_universe, 89 },
	{ "#90", "X",					&dhcp_universe, 90 },
	{ "#91", "X",					&dhcp_universe, 91 },
	{ "#92", "X",					&dhcp_universe, 92 },
	{ "pxe-client-arch-id", "X",			&dhcp_universe, 93 },
	{ "pxe-client-netif-id", "X",			&dhcp_universe, 94 },
	{ "#95", "X",					&dhcp_universe, 95 },
	{ "#96", "X",					&dhcp_universe, 96 },
	{ "pxe-uuid", "X",				&dhcp_universe, 97 },
	{ "uap-servers", "t",				&dhcp_universe, 98 },
	{ "#99", "X",					&dhcp_universe, 99 },
	{ "#100", "X",					&dhcp_universe, 100 },
	{ "#101", "X",					&dhcp_universe, 101 },
	{ "#102", "X",					&dhcp_universe, 102 },
	{ "#103", "X",					&dhcp_universe, 103 },
	{ "#104", "X",					&dhcp_universe, 104 },
	{ "#105", "X",					&dhcp_universe, 105 },
	{ "#106", "X",					&dhcp_universe, 106 },
	{ "#107", "X",					&dhcp_universe, 107 },
	{ "#108", "X",					&dhcp_universe, 108 },
	{ "#109", "X",					&dhcp_universe, 109 },
	{ "#110", "X",					&dhcp_universe, 110 },
	{ "#111", "X",					&dhcp_universe, 111 },
	{ "#112", "X",					&dhcp_universe, 112 },
	{ "#113", "X",					&dhcp_universe, 113 },
	{ "#114", "X",					&dhcp_universe, 114 },
	{ "#115", "X",					&dhcp_universe, 115 },
	{ "#116", "X",					&dhcp_universe, 116 },
	{ "#117", "X",					&dhcp_universe, 117 },
	{ "subnet-selection", "X",			&dhcp_universe, 118 },
	{ "#119", "X",					&dhcp_universe, 119 },
	{ "#120", "X",					&dhcp_universe, 120 },
	{ "#121", "X",					&dhcp_universe, 121 },
	{ "#122", "X",					&dhcp_universe, 122 },
	{ "#123", "X",					&dhcp_universe, 123 },
	{ "#124", "X",					&dhcp_universe, 124 },
	{ "#125", "X",					&dhcp_universe, 125 },
	{ "#126", "X",					&dhcp_universe, 126 },
	{ "#127", "X",					&dhcp_universe, 127 },
	{ "#128", "X",					&dhcp_universe, 128 },
	{ "#129", "X",					&dhcp_universe, 129 },
	{ "#130", "X",					&dhcp_universe, 130 },
	{ "#131", "X",					&dhcp_universe, 131 },
	{ "#132", "X",					&dhcp_universe, 132 },
	{ "#133", "X",					&dhcp_universe, 133 },
	{ "#134", "X",					&dhcp_universe, 134 },
	{ "#135", "X",					&dhcp_universe, 135 },
	{ "#136", "X",					&dhcp_universe, 136 },
	{ "#137", "X",					&dhcp_universe, 137 },
	{ "#138", "X",					&dhcp_universe, 138 },
	{ "#139", "X",					&dhcp_universe, 139 },
	{ "#140", "X",					&dhcp_universe, 140 },
	{ "#141", "X",					&dhcp_universe, 141 },
	{ "#142", "X",					&dhcp_universe, 142 },
	{ "#143", "X",					&dhcp_universe, 143 },
	{ "#144", "X",					&dhcp_universe, 144 },
	{ "#145", "X",					&dhcp_universe, 145 },
	{ "#146", "X",					&dhcp_universe, 146 },
	{ "#147", "X",					&dhcp_universe, 147 },
	{ "#148", "X",					&dhcp_universe, 148 },
	{ "#149", "X",					&dhcp_universe, 149 },
	{ "#150", "X",					&dhcp_universe, 150 },
	{ "#151", "X",					&dhcp_universe, 151 },
	{ "#152", "X",					&dhcp_universe, 152 },
	{ "#153", "X",					&dhcp_universe, 153 },
	{ "#154", "X",					&dhcp_universe, 154 },
	{ "#155", "X",					&dhcp_universe, 155 },
	{ "#156", "X",					&dhcp_universe, 156 },
	{ "#157", "X",					&dhcp_universe, 157 },
	{ "#158", "X",					&dhcp_universe, 158 },
	{ "#159", "X",					&dhcp_universe, 159 },
	{ "#160", "X",					&dhcp_universe, 160 },
	{ "#161", "X",					&dhcp_universe, 161 },
	{ "#162", "X",					&dhcp_universe, 162 },
	{ "#163", "X",					&dhcp_universe, 163 },
	{ "#164", "X",					&dhcp_universe, 164 },
	{ "#165", "X",					&dhcp_universe, 165 },
	{ "#166", "X",					&dhcp_universe, 166 },
	{ "#167", "X",					&dhcp_universe, 167 },
	{ "#168", "X",					&dhcp_universe, 168 },
	{ "#169", "X",					&dhcp_universe, 169 },
	{ "#170", "X",					&dhcp_universe, 170 },
	{ "#171", "X",					&dhcp_universe, 171 },
	{ "#172", "X",					&dhcp_universe, 172 },
	{ "#173", "X",					&dhcp_universe, 173 },
	{ "#174", "X",					&dhcp_universe, 174 },
	{ "#175", "X",					&dhcp_universe, 175 },
	{ "#176", "X",					&dhcp_universe, 176 },
	{ "#177", "X",					&dhcp_universe, 177 },
	{ "#178", "X",					&dhcp_universe, 178 },
	{ "#179", "X",					&dhcp_universe, 179 },
	{ "#180", "X",					&dhcp_universe, 180 },
	{ "#181", "X",					&dhcp_universe, 181 },
	{ "#182", "X",					&dhcp_universe, 182 },
	{ "#183", "X",					&dhcp_universe, 183 },
	{ "#184", "X",					&dhcp_universe, 184 },
	{ "#185", "X",					&dhcp_universe, 185 },
	{ "#186", "X",					&dhcp_universe, 186 },
	{ "#187", "X",					&dhcp_universe, 187 },
	{ "#188", "X",					&dhcp_universe, 188 },
	{ "#189", "X",					&dhcp_universe, 189 },
	{ "#190", "X",					&dhcp_universe, 190 },
	{ "#191", "X",					&dhcp_universe, 191 },
	{ "#192", "X",					&dhcp_universe, 192 },
	{ "#193", "X",					&dhcp_universe, 193 },
	{ "#194", "X",					&dhcp_universe, 194 },
	{ "#195", "X",					&dhcp_universe, 195 },
	{ "#196", "X",					&dhcp_universe, 196 },
	{ "#197", "X",					&dhcp_universe, 197 },
	{ "#198", "X",					&dhcp_universe, 198 },
	{ "#199", "X",					&dhcp_universe, 199 },
	{ "#200", "X",					&dhcp_universe, 200 },
	{ "#201", "X",					&dhcp_universe, 201 },
	{ "#202", "X",					&dhcp_universe, 202 },
	{ "#203", "X",					&dhcp_universe, 203 },
	{ "#204", "X",					&dhcp_universe, 204 },
	{ "#205", "X",					&dhcp_universe, 205 },
	{ "#206", "X",					&dhcp_universe, 206 },
	{ "#207", "X",					&dhcp_universe, 207 },
	{ "#208", "X",					&dhcp_universe, 208 },
	{ "#209", "X",					&dhcp_universe, 209 },
	{ "authenticate", "X",				&dhcp_universe, 210 },
	{ "#211", "X",					&dhcp_universe, 211 },
	{ "#212", "X",					&dhcp_universe, 212 },
	{ "#213", "X",					&dhcp_universe, 213 },
	{ "#214", "X",					&dhcp_universe, 214 },
	{ "#215", "X",					&dhcp_universe, 215 },
	{ "#216", "X",					&dhcp_universe, 216 },
	{ "#217", "X",					&dhcp_universe, 217 },
	{ "#218", "X",					&dhcp_universe, 218 },
	{ "#219", "X",					&dhcp_universe, 219 },
	{ "#220", "X",					&dhcp_universe, 220 },
	{ "#221", "X",					&dhcp_universe, 221 },
	{ "#222", "X",					&dhcp_universe, 222 },
	{ "#223", "X",					&dhcp_universe, 223 },
	{ "#224", "X",					&dhcp_universe, 224 },
	{ "#225", "X",					&dhcp_universe, 225 },
	{ "#226", "X",					&dhcp_universe, 226 },
	{ "#227", "X",					&dhcp_universe, 227 },
	{ "#228", "X",					&dhcp_universe, 228 },
	{ "#229", "X",					&dhcp_universe, 229 },
	{ "#230", "X",					&dhcp_universe, 230 },
	{ "#231", "X",					&dhcp_universe, 231 },
	{ "#232", "X",					&dhcp_universe, 232 },
	{ "#233", "X",					&dhcp_universe, 233 },
	{ "#234", "X",					&dhcp_universe, 234 },
	{ "#235", "X",					&dhcp_universe, 235 },
	{ "#236", "X",					&dhcp_universe, 236 },
	{ "#237", "X",					&dhcp_universe, 237 },
	{ "#238", "X",					&dhcp_universe, 238 },
	{ "#239", "X",					&dhcp_universe, 239 },
	{ "#240", "X",					&dhcp_universe, 240 },
	{ "#241", "X",					&dhcp_universe, 241 },
	{ "#242", "X",					&dhcp_universe, 242 },
	{ "#243", "X",					&dhcp_universe, 243 },
	{ "#244", "X",					&dhcp_universe, 244 },
	{ "#245", "X",					&dhcp_universe, 245 },
	{ "#246", "X",					&dhcp_universe, 246 },
	{ "#247", "X",					&dhcp_universe, 247 },
	{ "#248", "X",					&dhcp_universe, 248 },
	{ "#249", "X",					&dhcp_universe, 249 },
	{ "#250", "X",					&dhcp_universe, 250 },
	{ "#251", "X",					&dhcp_universe, 251 },
	{ "#252", "X",					&dhcp_universe, 252 },
	{ "#253", "X",					&dhcp_universe, 253 },
	{ "#254", "X",					&dhcp_universe, 254 },
	{ "option-end", "e",				&dhcp_universe, 255 },
};

struct universe nwip_universe;
struct option nwip_options [256] = {
	{ "pad", "",					&nwip_universe, 0 },
	{ "illegal-1", "",				&nwip_universe, 1 },
	{ "illegal-2", "",				&nwip_universe, 2 },
	{ "illegal-3", "",				&nwip_universe, 3 },
	{ "illegal-4", "",				&nwip_universe, 4 },
	{ "nsq-broadcast", "f",				&nwip_universe, 5 },
	{ "preferred-dss", "IA",			&nwip_universe, 6 },
	{ "nearest-nwip-server", "IA",			&nwip_universe, 7 },
	{ "autoretries", "B",				&nwip_universe, 8 },
	{ "autoretry-secs", "B",			&nwip_universe, 9 },
	{ "nwip-1-1", "f",				&nwip_universe, 10 },
	{ "primary-dss", "I",				&nwip_universe, 11 },
	{ "#12", "X",				&nwip_universe, 12 },
	{ "#13", "X",				&nwip_universe, 13 },
	{ "#14", "X",				&nwip_universe, 14 },
	{ "#15", "X",				&nwip_universe, 15 },
	{ "#16", "X",				&nwip_universe, 16 },
	{ "#17", "X",				&nwip_universe, 17 },
	{ "#18", "X",				&nwip_universe, 18 },
	{ "#19", "X",				&nwip_universe, 19 },
	{ "#20", "X",				&nwip_universe, 20 },
	{ "#21", "X",				&nwip_universe, 21 },
	{ "#22", "X",				&nwip_universe, 22 },
	{ "#23", "X",				&nwip_universe, 23 },
	{ "#24", "X",				&nwip_universe, 24 },
	{ "#25", "X",				&nwip_universe, 25 },
	{ "#26", "X",				&nwip_universe, 26 },
	{ "#27", "X",				&nwip_universe, 27 },
	{ "#28", "X",				&nwip_universe, 28 },
	{ "#29", "X",				&nwip_universe, 29 },
	{ "#30", "X",				&nwip_universe, 30 },
	{ "#31", "X",				&nwip_universe, 31 },
	{ "#32", "X",				&nwip_universe, 32 },
	{ "#33", "X",				&nwip_universe, 33 },
	{ "#34", "X",				&nwip_universe, 34 },
	{ "#35", "X",				&nwip_universe, 35 },
	{ "#36", "X",				&nwip_universe, 36 },
	{ "#37", "X",				&nwip_universe, 37 },
	{ "#38", "X",				&nwip_universe, 38 },
	{ "#39", "X",				&nwip_universe, 39 },
	{ "#40", "X",				&nwip_universe, 40 },
	{ "#41", "X",				&nwip_universe, 41 },
	{ "#42", "X",				&nwip_universe, 42 },
	{ "#43", "X",				&nwip_universe, 43 },
	{ "#44", "X",				&nwip_universe, 44 },
	{ "#45", "X",				&nwip_universe, 45 },
	{ "#46", "X",				&nwip_universe, 46 },
	{ "#47", "X",				&nwip_universe, 47 },
	{ "#48", "X",				&nwip_universe, 48 },
	{ "#49", "X",				&nwip_universe, 49 },
	{ "#50", "X",				&nwip_universe, 50 },
	{ "#51", "X",				&nwip_universe, 51 },
	{ "#52", "X",				&nwip_universe, 52 },
	{ "#53", "X",				&nwip_universe, 53 },
	{ "#54", "X",				&nwip_universe, 54 },
	{ "#55", "X",				&nwip_universe, 55 },
	{ "#56", "X",				&nwip_universe, 56 },
	{ "#57", "X",				&nwip_universe, 57 },
	{ "#58", "X",				&nwip_universe, 58 },
	{ "#59", "X",				&nwip_universe, 59 },
	{ "#60", "X",				&nwip_universe, 60 },
	{ "#61", "X",				&nwip_universe, 61 },
	{ "#62", "X",				&nwip_universe, 62 },
	{ "#63", "X",				&nwip_universe, 63 },
	{ "#64", "X",				&nwip_universe, 64 },
	{ "#65", "X",				&nwip_universe, 65 },
	{ "#66", "X",				&nwip_universe, 66 },
	{ "#67", "X",				&nwip_universe, 67 },
	{ "#68", "X",				&nwip_universe, 68 },
	{ "#69", "X",				&nwip_universe, 69 },
	{ "#70", "X",				&nwip_universe, 70 },
	{ "#71", "X",				&nwip_universe, 71 },
	{ "#72", "X",				&nwip_universe, 72 },
	{ "#73", "X",				&nwip_universe, 73 },
	{ "#74", "X",				&nwip_universe, 74 },
	{ "#75", "X",				&nwip_universe, 75 },
	{ "#76", "X",				&nwip_universe, 76 },
	{ "#77", "X",				&nwip_universe, 77 },
	{ "#78", "X",				&nwip_universe, 78 },
	{ "#79", "X",				&nwip_universe, 79 },
	{ "#80", "X",				&nwip_universe, 80 },
	{ "#81", "X",				&nwip_universe, 81 },
	{ "#82", "X",				&nwip_universe, 82 },
	{ "#83", "X",				&nwip_universe, 83 },
	{ "#84", "X",				&nwip_universe, 84 },
	{ "#85", "X",				&nwip_universe, 85 },
	{ "#86", "X",				&nwip_universe, 86 },
	{ "#87", "X",				&nwip_universe, 87 },
	{ "#88", "X",				&nwip_universe, 88 },
	{ "#89", "X",				&nwip_universe, 89 },
	{ "#90", "X",				&nwip_universe, 90 },
	{ "#91", "X",				&nwip_universe, 91 },
	{ "#92", "X",				&nwip_universe, 92 },
	{ "#93", "X",				&nwip_universe, 93 },
	{ "#94", "X",				&nwip_universe, 94 },
	{ "#95", "X",				&nwip_universe, 95 },
	{ "#96", "X",				&nwip_universe, 96 },
	{ "#97", "X",				&nwip_universe, 97 },
	{ "#98", "X",				&nwip_universe, 98 },
	{ "#99", "X",				&nwip_universe, 99 },
	{ "#100", "X",				&nwip_universe, 100 },
	{ "#101", "X",				&nwip_universe, 101 },
	{ "#102", "X",				&nwip_universe, 102 },
	{ "#103", "X",				&nwip_universe, 103 },
	{ "#104", "X",				&nwip_universe, 104 },
	{ "#105", "X",				&nwip_universe, 105 },
	{ "#106", "X",				&nwip_universe, 106 },
	{ "#107", "X",				&nwip_universe, 107 },
	{ "#108", "X",				&nwip_universe, 108 },
	{ "#109", "X",				&nwip_universe, 109 },
	{ "#110", "X",				&nwip_universe, 110 },
	{ "#111", "X",				&nwip_universe, 111 },
	{ "#112", "X",				&nwip_universe, 112 },
	{ "#113", "X",				&nwip_universe, 113 },
	{ "#114", "X",				&nwip_universe, 114 },
	{ "#115", "X",				&nwip_universe, 115 },
	{ "#116", "X",				&nwip_universe, 116 },
	{ "#117", "X",				&nwip_universe, 117 },
	{ "#118", "X",				&nwip_universe, 118 },
	{ "#119", "X",				&nwip_universe, 119 },
	{ "#120", "X",				&nwip_universe, 120 },
	{ "#121", "X",				&nwip_universe, 121 },
	{ "#122", "X",				&nwip_universe, 122 },
	{ "#123", "X",				&nwip_universe, 123 },
	{ "#124", "X",				&nwip_universe, 124 },
	{ "#125", "X",				&nwip_universe, 125 },
	{ "#126", "X",				&nwip_universe, 126 },
	{ "#127", "X",				&nwip_universe, 127 },
	{ "#128", "X",				&nwip_universe, 128 },
	{ "#129", "X",				&nwip_universe, 129 },
	{ "#130", "X",				&nwip_universe, 130 },
	{ "#131", "X",				&nwip_universe, 131 },
	{ "#132", "X",				&nwip_universe, 132 },
	{ "#133", "X",				&nwip_universe, 133 },
	{ "#134", "X",				&nwip_universe, 134 },
	{ "#135", "X",				&nwip_universe, 135 },
	{ "#136", "X",				&nwip_universe, 136 },
	{ "#137", "X",				&nwip_universe, 137 },
	{ "#138", "X",				&nwip_universe, 138 },
	{ "#139", "X",				&nwip_universe, 139 },
	{ "#140", "X",				&nwip_universe, 140 },
	{ "#141", "X",				&nwip_universe, 141 },
	{ "#142", "X",				&nwip_universe, 142 },
	{ "#143", "X",				&nwip_universe, 143 },
	{ "#144", "X",				&nwip_universe, 144 },
	{ "#145", "X",				&nwip_universe, 145 },
	{ "#146", "X",				&nwip_universe, 146 },
	{ "#147", "X",				&nwip_universe, 147 },
	{ "#148", "X",				&nwip_universe, 148 },
	{ "#149", "X",				&nwip_universe, 149 },
	{ "#150", "X",				&nwip_universe, 150 },
	{ "#151", "X",				&nwip_universe, 151 },
	{ "#152", "X",				&nwip_universe, 152 },
	{ "#153", "X",				&nwip_universe, 153 },
	{ "#154", "X",				&nwip_universe, 154 },
	{ "#155", "X",				&nwip_universe, 155 },
	{ "#156", "X",				&nwip_universe, 156 },
	{ "#157", "X",				&nwip_universe, 157 },
	{ "#158", "X",				&nwip_universe, 158 },
	{ "#159", "X",				&nwip_universe, 159 },
	{ "#160", "X",				&nwip_universe, 160 },
	{ "#161", "X",				&nwip_universe, 161 },
	{ "#162", "X",				&nwip_universe, 162 },
	{ "#163", "X",				&nwip_universe, 163 },
	{ "#164", "X",				&nwip_universe, 164 },
	{ "#165", "X",				&nwip_universe, 165 },
	{ "#166", "X",				&nwip_universe, 166 },
	{ "#167", "X",				&nwip_universe, 167 },
	{ "#168", "X",				&nwip_universe, 168 },
	{ "#169", "X",				&nwip_universe, 169 },
	{ "#170", "X",				&nwip_universe, 170 },
	{ "#171", "X",				&nwip_universe, 171 },
	{ "#172", "X",				&nwip_universe, 172 },
	{ "#173", "X",				&nwip_universe, 173 },
	{ "#174", "X",				&nwip_universe, 174 },
	{ "#175", "X",				&nwip_universe, 175 },
	{ "#176", "X",				&nwip_universe, 176 },
	{ "#177", "X",				&nwip_universe, 177 },
	{ "#178", "X",				&nwip_universe, 178 },
	{ "#179", "X",				&nwip_universe, 179 },
	{ "#180", "X",				&nwip_universe, 180 },
	{ "#181", "X",				&nwip_universe, 181 },
	{ "#182", "X",				&nwip_universe, 182 },
	{ "#183", "X",				&nwip_universe, 183 },
	{ "#184", "X",				&nwip_universe, 184 },
	{ "#185", "X",				&nwip_universe, 185 },
	{ "#186", "X",				&nwip_universe, 186 },
	{ "#187", "X",				&nwip_universe, 187 },
	{ "#188", "X",				&nwip_universe, 188 },
	{ "#189", "X",				&nwip_universe, 189 },
	{ "#190", "X",				&nwip_universe, 190 },
	{ "#191", "X",				&nwip_universe, 191 },
	{ "#192", "X",				&nwip_universe, 192 },
	{ "#193", "X",				&nwip_universe, 193 },
	{ "#194", "X",				&nwip_universe, 194 },
	{ "#195", "X",				&nwip_universe, 195 },
	{ "#196", "X",				&nwip_universe, 196 },
	{ "#197", "X",				&nwip_universe, 197 },
	{ "#198", "X",				&nwip_universe, 198 },
	{ "#199", "X",				&nwip_universe, 199 },
	{ "#200", "X",				&nwip_universe, 200 },
	{ "#201", "X",				&nwip_universe, 201 },
	{ "#202", "X",				&nwip_universe, 202 },
	{ "#203", "X",				&nwip_universe, 203 },
	{ "#204", "X",				&nwip_universe, 204 },
	{ "#205", "X",				&nwip_universe, 205 },
	{ "#206", "X",				&nwip_universe, 206 },
	{ "#207", "X",				&nwip_universe, 207 },
	{ "#208", "X",				&nwip_universe, 208 },
	{ "#209", "X",				&nwip_universe, 209 },
	{ "#210", "X",				&nwip_universe, 210 },
	{ "#211", "X",				&nwip_universe, 211 },
	{ "#212", "X",				&nwip_universe, 212 },
	{ "#213", "X",				&nwip_universe, 213 },
	{ "#214", "X",				&nwip_universe, 214 },
	{ "#215", "X",				&nwip_universe, 215 },
	{ "#216", "X",				&nwip_universe, 216 },
	{ "#217", "X",				&nwip_universe, 217 },
	{ "#218", "X",				&nwip_universe, 218 },
	{ "#219", "X",				&nwip_universe, 219 },
	{ "#220", "X",				&nwip_universe, 220 },
	{ "#221", "X",				&nwip_universe, 221 },
	{ "#222", "X",				&nwip_universe, 222 },
	{ "#223", "X",				&nwip_universe, 223 },
	{ "#224", "X",				&nwip_universe, 224 },
	{ "#225", "X",				&nwip_universe, 225 },
	{ "#226", "X",				&nwip_universe, 226 },
	{ "#227", "X",				&nwip_universe, 227 },
	{ "#228", "X",				&nwip_universe, 228 },
	{ "#229", "X",				&nwip_universe, 229 },
	{ "#230", "X",				&nwip_universe, 230 },
	{ "#231", "X",				&nwip_universe, 231 },
	{ "#232", "X",				&nwip_universe, 232 },
	{ "#233", "X",				&nwip_universe, 233 },
	{ "#234", "X",				&nwip_universe, 234 },
	{ "#235", "X",				&nwip_universe, 235 },
	{ "#236", "X",				&nwip_universe, 236 },
	{ "#237", "X",				&nwip_universe, 237 },
	{ "#238", "X",				&nwip_universe, 238 },
	{ "#239", "X",				&nwip_universe, 239 },
	{ "#240", "X",				&nwip_universe, 240 },
	{ "#241", "X",				&nwip_universe, 241 },
	{ "#242", "X",				&nwip_universe, 242 },
	{ "#243", "X",				&nwip_universe, 243 },
	{ "#244", "X",				&nwip_universe, 244 },
	{ "#245", "X",				&nwip_universe, 245 },
	{ "#246", "X",				&nwip_universe, 246 },
	{ "#247", "X",				&nwip_universe, 247 },
	{ "#248", "X",				&nwip_universe, 248 },
	{ "#249", "X",				&nwip_universe, 249 },
	{ "#250", "X",				&nwip_universe, 250 },
	{ "#251", "X",				&nwip_universe, 251 },
	{ "#252", "X",				&nwip_universe, 252 },
	{ "#253", "X",				&nwip_universe, 253 },
	{ "#254", "X",				&nwip_universe, 254 },
	{ "#end", "e",				&nwip_universe, 255 },
};

struct universe fqdn_universe;
struct option fqdn_options [256] = {
	{ "pad", "",					&fqdn_universe, 0 },
	{ "no-client-update", "f",			&fqdn_universe, 1 },
	{ "server-update", "f",				&fqdn_universe, 2 },
	{ "encoded", "f",				&fqdn_universe, 3 },
	{ "rcode1", "B",				&fqdn_universe, 4 },
	{ "rcode2", "B",				&fqdn_universe, 5 },
	{ "hostname", "t",				&fqdn_universe, 6 },
	{ "domainname", "t",				&fqdn_universe, 7 },
	{ "fqdn", "t",					&fqdn_universe, 8 },
	{ "#9", "X",				&fqdn_universe, 9 },
	{ "#10", "X",				&fqdn_universe, 10 },
	{ "#11", "X",				&fqdn_universe, 11 },
	{ "#12", "X",				&fqdn_universe, 12 },
	{ "#13", "X",				&fqdn_universe, 13 },
	{ "#14", "X",				&fqdn_universe, 14 },
	{ "#15", "X",				&fqdn_universe, 15 },
	{ "#16", "X",				&fqdn_universe, 16 },
	{ "#17", "X",				&fqdn_universe, 17 },
	{ "#18", "X",				&fqdn_universe, 18 },
	{ "#19", "X",				&fqdn_universe, 19 },
	{ "#20", "X",				&fqdn_universe, 20 },
	{ "#21", "X",				&fqdn_universe, 21 },
	{ "#22", "X",				&fqdn_universe, 22 },
	{ "#23", "X",				&fqdn_universe, 23 },
	{ "#24", "X",				&fqdn_universe, 24 },
	{ "#25", "X",				&fqdn_universe, 25 },
	{ "#26", "X",				&fqdn_universe, 26 },
	{ "#27", "X",				&fqdn_universe, 27 },
	{ "#28", "X",				&fqdn_universe, 28 },
	{ "#29", "X",				&fqdn_universe, 29 },
	{ "#30", "X",				&fqdn_universe, 30 },
	{ "#31", "X",				&fqdn_universe, 31 },
	{ "#32", "X",				&fqdn_universe, 32 },
	{ "#33", "X",				&fqdn_universe, 33 },
	{ "#34", "X",				&fqdn_universe, 34 },
	{ "#35", "X",				&fqdn_universe, 35 },
	{ "#36", "X",				&fqdn_universe, 36 },
	{ "#37", "X",				&fqdn_universe, 37 },
	{ "#38", "X",				&fqdn_universe, 38 },
	{ "#39", "X",				&fqdn_universe, 39 },
	{ "#40", "X",				&fqdn_universe, 40 },
	{ "#41", "X",				&fqdn_universe, 41 },
	{ "#42", "X",				&fqdn_universe, 42 },
	{ "#43", "X",				&fqdn_universe, 43 },
	{ "#44", "X",				&fqdn_universe, 44 },
	{ "#45", "X",				&fqdn_universe, 45 },
	{ "#46", "X",				&fqdn_universe, 46 },
	{ "#47", "X",				&fqdn_universe, 47 },
	{ "#48", "X",				&fqdn_universe, 48 },
	{ "#49", "X",				&fqdn_universe, 49 },
	{ "#50", "X",				&fqdn_universe, 50 },
	{ "#51", "X",				&fqdn_universe, 51 },
	{ "#52", "X",				&fqdn_universe, 52 },
	{ "#53", "X",				&fqdn_universe, 53 },
	{ "#54", "X",				&fqdn_universe, 54 },
	{ "#55", "X",				&fqdn_universe, 55 },
	{ "#56", "X",				&fqdn_universe, 56 },
	{ "#57", "X",				&fqdn_universe, 57 },
	{ "#58", "X",				&fqdn_universe, 58 },
	{ "#59", "X",				&fqdn_universe, 59 },
	{ "#60", "X",				&fqdn_universe, 60 },
	{ "#61", "X",				&fqdn_universe, 61 },
	{ "#62", "X",				&fqdn_universe, 62 },
	{ "#63", "X",				&fqdn_universe, 63 },
	{ "#64", "X",				&fqdn_universe, 64 },
	{ "#65", "X",				&fqdn_universe, 65 },
	{ "#66", "X",				&fqdn_universe, 66 },
	{ "#67", "X",				&fqdn_universe, 67 },
	{ "#68", "X",				&fqdn_universe, 68 },
	{ "#69", "X",				&fqdn_universe, 69 },
	{ "#70", "X",				&fqdn_universe, 70 },
	{ "#71", "X",				&fqdn_universe, 71 },
	{ "#72", "X",				&fqdn_universe, 72 },
	{ "#73", "X",				&fqdn_universe, 73 },
	{ "#74", "X",				&fqdn_universe, 74 },
	{ "#75", "X",				&fqdn_universe, 75 },
	{ "#76", "X",				&fqdn_universe, 76 },
	{ "#77", "X",				&fqdn_universe, 77 },
	{ "#78", "X",				&fqdn_universe, 78 },
	{ "#79", "X",				&fqdn_universe, 79 },
	{ "#80", "X",				&fqdn_universe, 80 },
	{ "#81", "X",				&fqdn_universe, 81 },
	{ "#82", "X",				&fqdn_universe, 82 },
	{ "#83", "X",				&fqdn_universe, 83 },
	{ "#84", "X",				&fqdn_universe, 84 },
	{ "#85", "X",				&fqdn_universe, 85 },
	{ "#86", "X",				&fqdn_universe, 86 },
	{ "#87", "X",				&fqdn_universe, 87 },
	{ "#88", "X",				&fqdn_universe, 88 },
	{ "#89", "X",				&fqdn_universe, 89 },
	{ "#90", "X",				&fqdn_universe, 90 },
	{ "#91", "X",				&fqdn_universe, 91 },
	{ "#92", "X",				&fqdn_universe, 92 },
	{ "#93", "X",				&fqdn_universe, 93 },
	{ "#94", "X",				&fqdn_universe, 94 },
	{ "#95", "X",				&fqdn_universe, 95 },
	{ "#96", "X",				&fqdn_universe, 96 },
	{ "#97", "X",				&fqdn_universe, 97 },
	{ "#98", "X",				&fqdn_universe, 98 },
	{ "#99", "X",				&fqdn_universe, 99 },
	{ "#100", "X",				&fqdn_universe, 100 },
	{ "#101", "X",				&fqdn_universe, 101 },
	{ "#102", "X",				&fqdn_universe, 102 },
	{ "#103", "X",				&fqdn_universe, 103 },
	{ "#104", "X",				&fqdn_universe, 104 },
	{ "#105", "X",				&fqdn_universe, 105 },
	{ "#106", "X",				&fqdn_universe, 106 },
	{ "#107", "X",				&fqdn_universe, 107 },
	{ "#108", "X",				&fqdn_universe, 108 },
	{ "#109", "X",				&fqdn_universe, 109 },
	{ "#110", "X",				&fqdn_universe, 110 },
	{ "#111", "X",				&fqdn_universe, 111 },
	{ "#112", "X",				&fqdn_universe, 112 },
	{ "#113", "X",				&fqdn_universe, 113 },
	{ "#114", "X",				&fqdn_universe, 114 },
	{ "#115", "X",				&fqdn_universe, 115 },
	{ "#116", "X",				&fqdn_universe, 116 },
	{ "#117", "X",				&fqdn_universe, 117 },
	{ "#118", "X",				&fqdn_universe, 118 },
	{ "#119", "X",				&fqdn_universe, 119 },
	{ "#120", "X",				&fqdn_universe, 120 },
	{ "#121", "X",				&fqdn_universe, 121 },
	{ "#122", "X",				&fqdn_universe, 122 },
	{ "#123", "X",				&fqdn_universe, 123 },
	{ "#124", "X",				&fqdn_universe, 124 },
	{ "#125", "X",				&fqdn_universe, 125 },
	{ "#126", "X",				&fqdn_universe, 126 },
	{ "#127", "X",				&fqdn_universe, 127 },
	{ "#128", "X",				&fqdn_universe, 128 },
	{ "#129", "X",				&fqdn_universe, 129 },
	{ "#130", "X",				&fqdn_universe, 130 },
	{ "#131", "X",				&fqdn_universe, 131 },
	{ "#132", "X",				&fqdn_universe, 132 },
	{ "#133", "X",				&fqdn_universe, 133 },
	{ "#134", "X",				&fqdn_universe, 134 },
	{ "#135", "X",				&fqdn_universe, 135 },
	{ "#136", "X",				&fqdn_universe, 136 },
	{ "#137", "X",				&fqdn_universe, 137 },
	{ "#138", "X",				&fqdn_universe, 138 },
	{ "#139", "X",				&fqdn_universe, 139 },
	{ "#140", "X",				&fqdn_universe, 140 },
	{ "#141", "X",				&fqdn_universe, 141 },
	{ "#142", "X",				&fqdn_universe, 142 },
	{ "#143", "X",				&fqdn_universe, 143 },
	{ "#144", "X",				&fqdn_universe, 144 },
	{ "#145", "X",				&fqdn_universe, 145 },
	{ "#146", "X",				&fqdn_universe, 146 },
	{ "#147", "X",				&fqdn_universe, 147 },
	{ "#148", "X",				&fqdn_universe, 148 },
	{ "#149", "X",				&fqdn_universe, 149 },
	{ "#150", "X",				&fqdn_universe, 150 },
	{ "#151", "X",				&fqdn_universe, 151 },
	{ "#152", "X",				&fqdn_universe, 152 },
	{ "#153", "X",				&fqdn_universe, 153 },
	{ "#154", "X",				&fqdn_universe, 154 },
	{ "#155", "X",				&fqdn_universe, 155 },
	{ "#156", "X",				&fqdn_universe, 156 },
	{ "#157", "X",				&fqdn_universe, 157 },
	{ "#158", "X",				&fqdn_universe, 158 },
	{ "#159", "X",				&fqdn_universe, 159 },
	{ "#160", "X",				&fqdn_universe, 160 },
	{ "#161", "X",				&fqdn_universe, 161 },
	{ "#162", "X",				&fqdn_universe, 162 },
	{ "#163", "X",				&fqdn_universe, 163 },
	{ "#164", "X",				&fqdn_universe, 164 },
	{ "#165", "X",				&fqdn_universe, 165 },
	{ "#166", "X",				&fqdn_universe, 166 },
	{ "#167", "X",				&fqdn_universe, 167 },
	{ "#168", "X",				&fqdn_universe, 168 },
	{ "#169", "X",				&fqdn_universe, 169 },
	{ "#170", "X",				&fqdn_universe, 170 },
	{ "#171", "X",				&fqdn_universe, 171 },
	{ "#172", "X",				&fqdn_universe, 172 },
	{ "#173", "X",				&fqdn_universe, 173 },
	{ "#174", "X",				&fqdn_universe, 174 },
	{ "#175", "X",				&fqdn_universe, 175 },
	{ "#176", "X",				&fqdn_universe, 176 },
	{ "#177", "X",				&fqdn_universe, 177 },
	{ "#178", "X",				&fqdn_universe, 178 },
	{ "#179", "X",				&fqdn_universe, 179 },
	{ "#180", "X",				&fqdn_universe, 180 },
	{ "#181", "X",				&fqdn_universe, 181 },
	{ "#182", "X",				&fqdn_universe, 182 },
	{ "#183", "X",				&fqdn_universe, 183 },
	{ "#184", "X",				&fqdn_universe, 184 },
	{ "#185", "X",				&fqdn_universe, 185 },
	{ "#186", "X",				&fqdn_universe, 186 },
	{ "#187", "X",				&fqdn_universe, 187 },
	{ "#188", "X",				&fqdn_universe, 188 },
	{ "#189", "X",				&fqdn_universe, 189 },
	{ "#190", "X",				&fqdn_universe, 190 },
	{ "#191", "X",				&fqdn_universe, 191 },
	{ "#192", "X",				&fqdn_universe, 192 },
	{ "#193", "X",				&fqdn_universe, 193 },
	{ "#194", "X",				&fqdn_universe, 194 },
	{ "#195", "X",				&fqdn_universe, 195 },
	{ "#196", "X",				&fqdn_universe, 196 },
	{ "#197", "X",				&fqdn_universe, 197 },
	{ "#198", "X",				&fqdn_universe, 198 },
	{ "#199", "X",				&fqdn_universe, 199 },
	{ "#200", "X",				&fqdn_universe, 200 },
	{ "#201", "X",				&fqdn_universe, 201 },
	{ "#202", "X",				&fqdn_universe, 202 },
	{ "#203", "X",				&fqdn_universe, 203 },
	{ "#204", "X",				&fqdn_universe, 204 },
	{ "#205", "X",				&fqdn_universe, 205 },
	{ "#206", "X",				&fqdn_universe, 206 },
	{ "#207", "X",				&fqdn_universe, 207 },
	{ "#208", "X",				&fqdn_universe, 208 },
	{ "#209", "X",				&fqdn_universe, 209 },
	{ "#210", "X",				&fqdn_universe, 210 },
	{ "#211", "X",				&fqdn_universe, 211 },
	{ "#212", "X",				&fqdn_universe, 212 },
	{ "#213", "X",				&fqdn_universe, 213 },
	{ "#214", "X",				&fqdn_universe, 214 },
	{ "#215", "X",				&fqdn_universe, 215 },
	{ "#216", "X",				&fqdn_universe, 216 },
	{ "#217", "X",				&fqdn_universe, 217 },
	{ "#218", "X",				&fqdn_universe, 218 },
	{ "#219", "X",				&fqdn_universe, 219 },
	{ "#220", "X",				&fqdn_universe, 220 },
	{ "#221", "X",				&fqdn_universe, 221 },
	{ "#222", "X",				&fqdn_universe, 222 },
	{ "#223", "X",				&fqdn_universe, 223 },
	{ "#224", "X",				&fqdn_universe, 224 },
	{ "#225", "X",				&fqdn_universe, 225 },
	{ "#226", "X",				&fqdn_universe, 226 },
	{ "#227", "X",				&fqdn_universe, 227 },
	{ "#228", "X",				&fqdn_universe, 228 },
	{ "#229", "X",				&fqdn_universe, 229 },
	{ "#230", "X",				&fqdn_universe, 230 },
	{ "#231", "X",				&fqdn_universe, 231 },
	{ "#232", "X",				&fqdn_universe, 232 },
	{ "#233", "X",				&fqdn_universe, 233 },
	{ "#234", "X",				&fqdn_universe, 234 },
	{ "#235", "X",				&fqdn_universe, 235 },
	{ "#236", "X",				&fqdn_universe, 236 },
	{ "#237", "X",				&fqdn_universe, 237 },
	{ "#238", "X",				&fqdn_universe, 238 },
	{ "#239", "X",				&fqdn_universe, 239 },
	{ "#240", "X",				&fqdn_universe, 240 },
	{ "#241", "X",				&fqdn_universe, 241 },
	{ "#242", "X",				&fqdn_universe, 242 },
	{ "#243", "X",				&fqdn_universe, 243 },
	{ "#244", "X",				&fqdn_universe, 244 },
	{ "#245", "X",				&fqdn_universe, 245 },
	{ "#246", "X",				&fqdn_universe, 246 },
	{ "#247", "X",				&fqdn_universe, 247 },
	{ "#248", "X",				&fqdn_universe, 248 },
	{ "#249", "X",				&fqdn_universe, 249 },
	{ "#250", "X",				&fqdn_universe, 250 },
	{ "#251", "X",				&fqdn_universe, 251 },
	{ "#252", "X",				&fqdn_universe, 252 },
	{ "#253", "X",				&fqdn_universe, 253 },
	{ "#254", "X",				&fqdn_universe, 254 },
	{ "#end", "e",				&fqdn_universe, 255 },
};

const char *hardware_types [] = {
	"unknown-0",
	"ethernet",
	"unknown-2",
	"unknown-3",
	"unknown-4",
	"unknown-5",
	"token-ring",
	"unknown-7",
	"fddi",
	"unknown-9",
	"unknown-10",
	"unknown-11",
	"unknown-12",
	"unknown-13",
	"unknown-14",
	"unknown-15",
	"unknown-16",
	"unknown-17",
	"unknown-18",
	"unknown-19",
	"unknown-20",
	"unknown-21",
	"unknown-22",
	"unknown-23",
	"unknown-24",
	"unknown-25",
	"unknown-26",
	"unknown-27",
	"unknown-28",
	"unknown-29",
	"unknown-30",
	"unknown-31",
	"unknown-32",
	"unknown-33",
	"unknown-34",
	"unknown-35",
	"unknown-36",
	"unknown-37",
	"unknown-38",
	"unknown-39",
	"unknown-40",
	"unknown-41",
	"unknown-42",
	"unknown-43",
	"unknown-44",
	"unknown-45",
	"unknown-46",
	"unknown-47",
	"unknown-48",
	"unknown-49",
	"unknown-50",
	"unknown-51",
	"unknown-52",
	"unknown-53",
	"unknown-54",
	"unknown-55",
	"unknown-56",
	"unknown-57",
	"unknown-58",
	"unknown-59",
	"unknown-60",
	"unknown-61",
	"unknown-62",
	"unknown-63",
	"unknown-64",
	"unknown-65",
	"unknown-66",
	"unknown-67",
	"unknown-68",
	"unknown-69",
	"unknown-70",
	"unknown-71",
	"unknown-72",
	"unknown-73",
	"unknown-74",
	"unknown-75",
	"unknown-76",
	"unknown-77",
	"unknown-78",
	"unknown-79",
	"unknown-80",
	"unknown-81",
	"unknown-82",
	"unknown-83",
	"unknown-84",
	"unknown-85",
	"unknown-86",
	"unknown-87",
	"unknown-88",
	"unknown-89",
	"unknown-90",
	"unknown-91",
	"unknown-92",
	"unknown-93",
	"unknown-94",
	"unknown-95",
	"unknown-96",
	"unknown-97",
	"unknown-98",
	"unknown-99",
	"unknown-100",
	"unknown-101",
	"unknown-102",
	"unknown-103",
	"unknown-104",
	"unknown-105",
	"unknown-106",
	"unknown-107",
	"unknown-108",
	"unknown-109",
	"unknown-110",
	"unknown-111",
	"unknown-112",
	"unknown-113",
	"unknown-114",
	"unknown-115",
	"unknown-116",
	"unknown-117",
	"unknown-118",
	"unknown-119",
	"unknown-120",
	"unknown-121",
	"unknown-122",
	"unknown-123",
	"unknown-124",
	"unknown-125",
	"unknown-126",
	"unknown-127",
	"unknown-128",
	"unknown-129",
	"unknown-130",
	"unknown-131",
	"unknown-132",
	"unknown-133",
	"unknown-134",
	"unknown-135",
	"unknown-136",
	"unknown-137",
	"unknown-138",
	"unknown-139",
	"unknown-140",
	"unknown-141",
	"unknown-142",
	"unknown-143",
	"unknown-144",
	"unknown-145",
	"unknown-146",
	"unknown-147",
	"unknown-148",
	"unknown-149",
	"unknown-150",
	"unknown-151",
	"unknown-152",
	"unknown-153",
	"unknown-154",
	"unknown-155",
	"unknown-156",
	"unknown-157",
	"unknown-158",
	"unknown-159",
	"unknown-160",
	"unknown-161",
	"unknown-162",
	"unknown-163",
	"unknown-164",
	"unknown-165",
	"unknown-166",
	"unknown-167",
	"unknown-168",
	"unknown-169",
	"unknown-170",
	"unknown-171",
	"unknown-172",
	"unknown-173",
	"unknown-174",
	"unknown-175",
	"unknown-176",
	"unknown-177",
	"unknown-178",
	"unknown-179",
	"unknown-180",
	"unknown-181",
	"unknown-182",
	"unknown-183",
	"unknown-184",
	"unknown-185",
	"unknown-186",
	"unknown-187",
	"unknown-188",
	"unknown-189",
	"unknown-190",
	"unknown-191",
	"unknown-192",
	"unknown-193",
	"unknown-194",
	"unknown-195",
	"unknown-196",
	"unknown-197",
	"unknown-198",
	"unknown-199",
	"unknown-200",
	"unknown-201",
	"unknown-202",
	"unknown-203",
	"unknown-204",
	"unknown-205",
	"unknown-206",
	"unknown-207",
	"unknown-208",
	"unknown-209",
	"unknown-210",
	"unknown-211",
	"unknown-212",
	"unknown-213",
	"unknown-214",
	"unknown-215",
	"unknown-216",
	"unknown-217",
	"unknown-218",
	"unknown-219",
	"unknown-220",
	"unknown-221",
	"unknown-222",
	"unknown-223",
	"unknown-224",
	"unknown-225",
	"unknown-226",
	"unknown-227",
	"unknown-228",
	"unknown-229",
	"unknown-230",
	"unknown-231",
	"unknown-232",
	"unknown-233",
	"unknown-234",
	"unknown-235",
	"unknown-236",
	"unknown-237",
	"unknown-238",
	"unknown-239",
	"unknown-240",
	"unknown-241",
	"unknown-242",
	"unknown-243",
	"unknown-244",
	"unknown-245",
	"unknown-246",
	"unknown-247",
	"unknown-248",
	"unknown-249",
	"unknown-250",
	"unknown-251",
	"unknown-252",
	"unknown-253",
	"unknown-254",
	"unknown-255" };

universe_hash_t *universe_hash;
struct universe **universes;
int universe_count, universe_max;

/* Universe containing names of configuration options, which, rather than
   writing "option universe-name.option-name ...;", can be set by writing
   "option-name ...;". */

struct universe *config_universe;

void initialize_common_option_spaces()
{
	int i;

	universe_max = 10;
	universes = ((struct universe **)
		     dmalloc (universe_max * sizeof (struct universe *), MDL));
	if (!universes)
		log_fatal ("Can't allocate option space table.");
	memset (universes, 0, universe_max * sizeof (struct universe *));

	/* Set up the DHCP option universe... */
	dhcp_universe.name = "dhcp";
	dhcp_universe.lookup_func = lookup_hashed_option;
	dhcp_universe.option_state_dereference =
		hashed_option_state_dereference;
	dhcp_universe.save_func = save_hashed_option;
	dhcp_universe.delete_func = delete_hashed_option;
	dhcp_universe.encapsulate = hashed_option_space_encapsulate;
	dhcp_universe.foreach = hashed_option_space_foreach;
	dhcp_universe.decode = parse_option_buffer;
	dhcp_universe.length_size = 1;
	dhcp_universe.tag_size = 1;
	dhcp_universe.store_tag = putUChar;
	dhcp_universe.store_length = putUChar;
	dhcp_universe.index = universe_count++;
	universes [dhcp_universe.index] = &dhcp_universe;
	if (!option_new_hash (&dhcp_universe.hash, 1, MDL))
		log_fatal ("Can't allocate dhcp option hash table.");
	for (i = 0; i < 256; i++) {
		dhcp_universe.options [i] = &dhcp_options [i];
		option_hash_add (dhcp_universe.hash,
				 dhcp_options [i].name, 0,
				 &dhcp_options [i], MDL);
	}

	/* Set up the Novell option universe (for option 63)... */
	nwip_universe.name = "nwip";
	nwip_universe.lookup_func = lookup_linked_option;
	nwip_universe.option_state_dereference =
		linked_option_state_dereference;
	nwip_universe.save_func = save_linked_option;
	nwip_universe.delete_func = delete_linked_option;
	nwip_universe.encapsulate = nwip_option_space_encapsulate;
	nwip_universe.foreach = linked_option_space_foreach;
	nwip_universe.decode = parse_option_buffer;
	nwip_universe.length_size = 1;
	nwip_universe.tag_size = 1;
	nwip_universe.store_tag = putUChar;
	nwip_universe.store_length = putUChar;
	nwip_universe.enc_opt = &dhcp_options [DHO_NWIP_SUBOPTIONS];
	nwip_universe.index = universe_count++;
	universes [nwip_universe.index] = &nwip_universe;
	option_new_hash (&nwip_universe.hash, 1, MDL);
	if (!nwip_universe.hash)
		log_fatal ("Can't allocate nwip option hash table.");
	for (i = 0; i < 256; i++) {
		nwip_universe.options [i] = &nwip_options [i];
		option_hash_add (nwip_universe.hash,
				 nwip_options [i].name, 0,
				 &nwip_options [i], MDL);
	}

	/* Set up the FQDN option universe... */
	fqdn_universe.name = "fqdn";
	fqdn_universe.lookup_func = lookup_linked_option;
	fqdn_universe.option_state_dereference =
		linked_option_state_dereference;
	fqdn_universe.save_func = save_linked_option;
	fqdn_universe.delete_func = delete_linked_option;
	fqdn_universe.encapsulate = fqdn_option_space_encapsulate;
	fqdn_universe.foreach = linked_option_space_foreach;
	fqdn_universe.decode = fqdn_universe_decode;
	fqdn_universe.length_size = 1;
	fqdn_universe.tag_size = 1;
	fqdn_universe.store_tag = putUChar;
	fqdn_universe.store_length = putUChar;
	fqdn_universe.index = universe_count++;
	fqdn_universe.enc_opt = &dhcp_options [DHO_FQDN];
	universes [fqdn_universe.index] = &fqdn_universe;
	option_new_hash (&fqdn_universe.hash, 1, MDL);
	if (!fqdn_universe.hash)
		log_fatal ("Can't allocate fqdn option hash table.");
	for (i = 0; i < 256; i++) {
		fqdn_universe.options [i] = &fqdn_options [i];
		option_hash_add (fqdn_universe.hash,
				 fqdn_options [i].name, 0,
				 &fqdn_options [i], MDL);
	}

	/* Set up the hash of universes. */
	universe_new_hash (&universe_hash, 1, MDL);
	universe_hash_add (universe_hash,
			   dhcp_universe.name, 0,
			   &dhcp_universe, MDL);
	universe_hash_add (universe_hash,
			   nwip_universe.name, 0,
			   &nwip_universe, MDL);
	universe_hash_add (universe_hash,
			   fqdn_universe.name, 0,
			   &fqdn_universe, MDL);
}
